/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.partitions;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.common.job.PartitionState;
import org.apache.hyracks.control.nc.partitions.MaterializedPartition;
import org.apache.hyracks.control.nc.partitions.PartitionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaterializedPartitionWriter
implements IFrameWriter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IHyracksTaskContext ctx;
    private final PartitionManager manager;
    private final PartitionId pid;
    private final TaskAttemptId taId;
    private final Executor executor;
    private FileReference fRef;
    private IFileHandle handle;
    private long size;
    private boolean failed;

    public MaterializedPartitionWriter(IHyracksTaskContext ctx, PartitionManager manager, PartitionId pid, TaskAttemptId taId, Executor executor) {
        this.ctx = ctx;
        this.manager = manager;
        this.pid = pid;
        this.taId = taId;
        this.executor = executor;
    }

    public void open() throws HyracksDataException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("open(" + this.pid + " by " + this.taId);
        }
        this.failed = false;
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        if (this.handle == null) {
            this.fRef = this.manager.getFileFactory().createUnmanagedWorkspaceFile(this.pid.toString());
            this.handle = this.ctx.getIoManager().open(this.fRef, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
            this.size = 0L;
        }
        this.size += (long)this.ctx.getIoManager().syncWrite(this.handle, this.size, buffer);
    }

    public void fail() throws HyracksDataException {
        this.failed = true;
    }

    public void close() throws HyracksDataException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("close(" + this.pid + " by " + this.taId);
        }
        if (this.handle != null) {
            this.ctx.getIoManager().close(this.handle);
        }
        if (!this.failed) {
            this.manager.registerPartition(this.pid, this.ctx.getJobletContext().getJobId().getCcId(), this.taId, new MaterializedPartition(this.ctx, this.fRef, this.executor, this.ctx.getIoManager()), PartitionState.COMMITTED, this.taId.getAttempt() != 0);
        }
    }

    public void flush() throws HyracksDataException {
    }
}

