/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.projection;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.runtime.projection.ExternalDatasetProjectionFiltrationInfo;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksStringBuilderWriter;

public class ColumnDatasetProjectionFiltrationInfo
extends ExternalDatasetProjectionFiltrationInfo {
    private final ARecordType metaProjectedType;
    private final ILogicalExpression rangeFilterExpression;

    public ColumnDatasetProjectionFiltrationInfo(ARecordType recordRequestedType, ARecordType metaProjectedType, Map<String, FunctionCallInformation> sourceInformationMap, Map<ILogicalExpression, ARecordType> filterPaths, ILogicalExpression filterExpression, ILogicalExpression rangeFilterExpression) {
        super(recordRequestedType, sourceInformationMap, filterPaths, filterExpression, false);
        this.metaProjectedType = metaProjectedType;
        this.rangeFilterExpression = rangeFilterExpression;
    }

    private ColumnDatasetProjectionFiltrationInfo(ColumnDatasetProjectionFiltrationInfo other) {
        super(other.projectedType, other.functionCallInfoMap, ColumnDatasetProjectionFiltrationInfo.clonePaths(other.filterPaths), ColumnDatasetProjectionFiltrationInfo.cloneExpression(other.filterExpression), false);
        this.metaProjectedType = other.metaProjectedType;
        this.rangeFilterExpression = ColumnDatasetProjectionFiltrationInfo.cloneExpression(other.rangeFilterExpression);
    }

    @Override
    public void substituteFilterVariable(LogicalVariable oldVar, LogicalVariable newVar) {
        super.substituteFilterVariable(oldVar, newVar);
        if (this.rangeFilterExpression != null) {
            this.rangeFilterExpression.substituteVar(oldVar, newVar);
        }
    }

    @Override
    public ColumnDatasetProjectionFiltrationInfo createCopy() {
        return new ColumnDatasetProjectionFiltrationInfo(this);
    }

    @Override
    public void print(AlgebricksStringBuilderWriter writer) {
        StringBuilder builder = new StringBuilder();
        if (this.projectedType != ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE) {
            writer.append((CharSequence)" project (");
            if (this.projectedType == ProjectionFiltrationTypeUtil.EMPTY_TYPE) {
                writer.append((CharSequence)this.projectedType.getTypeName());
            } else {
                writer.append((CharSequence)ColumnDatasetProjectionFiltrationInfo.getOnelinerSchema(this.projectedType, builder));
            }
            writer.append(')');
        }
        if (this.metaProjectedType != null && this.metaProjectedType != ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE) {
            writer.append((CharSequence)" project-meta (");
            writer.append((CharSequence)ColumnDatasetProjectionFiltrationInfo.getOnelinerSchema(this.metaProjectedType, builder));
            writer.append(')');
        }
        if (this.filterExpression != null) {
            writer.append((CharSequence)" filter on: ");
            writer.append((CharSequence)this.filterExpression.toString());
        }
        if (this.rangeFilterExpression != null) {
            writer.append((CharSequence)" range-filter on: ");
            writer.append((CharSequence)this.rangeFilterExpression.toString());
        }
    }

    @Override
    public void print(JsonGenerator generator) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (this.projectedType != ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE) {
            if (this.projectedType == ProjectionFiltrationTypeUtil.EMPTY_TYPE) {
                generator.writeStringField("project", this.projectedType.getTypeName());
            } else {
                generator.writeStringField("project", ColumnDatasetProjectionFiltrationInfo.getOnelinerSchema(this.projectedType, builder));
            }
        }
        if (this.metaProjectedType != null && this.metaProjectedType != ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE) {
            generator.writeStringField("project-meta", ColumnDatasetProjectionFiltrationInfo.getOnelinerSchema(this.projectedType, builder));
        }
        if (this.filterExpression != null) {
            generator.writeStringField("filter-on", this.filterExpression.toString());
        }
        if (this.rangeFilterExpression != null) {
            generator.writeStringField("range-filter-on", this.rangeFilterExpression.toString());
        }
    }

    public ARecordType getMetaProjectedType() {
        return this.metaProjectedType;
    }

    public ILogicalExpression getRangeFilterExpression() {
        return this.rangeFilterExpression;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDatasetProjectionFiltrationInfo otherInfo = (ColumnDatasetProjectionFiltrationInfo)o;
        return this.projectedType.deepEqual((IAObject)otherInfo.projectedType) && Objects.equals(this.metaProjectedType, otherInfo.metaProjectedType) && ColumnDatasetProjectionFiltrationInfo.filterExpressionEquals(this.filterExpression, otherInfo.filterExpression) && ColumnDatasetProjectionFiltrationInfo.filterExpressionEquals(this.rangeFilterExpression, otherInfo.rangeFilterExpression);
    }
}

