/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.runtime;

import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.transaction.management.runtime.CommitRuntime;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.io.MessagingFrameTupleAppender;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;

public class NoOpCommitRuntime
extends CommitRuntime {
    public NoOpCommitRuntime(IHyracksTaskContext ctx, TxnId txnId, int datasetId, int[] primaryKeyFields, boolean isWriteTransaction, int resourcePartition, boolean isSink, ITuplePartitionerFactory partitionerFactory, int[] datasetPartitions) {
        super(ctx, txnId, datasetId, primaryKeyFields, isWriteTransaction, resourcePartition, isSink, partitionerFactory, datasetPartitions);
    }

    @Override
    public void open() throws HyracksDataException {
        try {
            this.transactionContext = this.transactionManager.getTransactionContext(this.txnId);
            this.transactionContext.setWriteTxn(this.isWriteTransaction);
            if (this.isSink) {
                return;
            }
            this.initAccessAppend(this.ctx);
            super.open();
        }
        catch (ACIDException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.tAccess.reset(buffer);
        int nTuple = this.tAccess.getTupleCount();
        for (int t = 0; t < nTuple; ++t) {
            this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
            try {
                if (this.isSink) continue;
                this.appendTupleToFrame(t);
                continue;
            }
            catch (ACIDException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        IFrame message = (IFrame)TaskUtil.get((String)"HYX:MSG", (IHyracksTaskContext)this.ctx);
        if (message != null && MessagingFrameTupleAppender.getMessageType((IFrame)message) == 3) {
            message.reset();
            message.getBuffer().put((byte)1);
            message.getBuffer().flip();
        }
    }

    public void fail() {
        this.failed = true;
    }
}

