/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.transaction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.cluster.IGlobalTxManager;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.IGlobalTransactionContext;
import org.apache.asterix.transaction.management.service.transaction.AtomicTransactionLog;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;

public class GlobalTransactionContext
implements IGlobalTransactionContext {
    protected final JobId jobId;
    private AtomicInteger acksReceived;
    private final int numNodes;
    private IGlobalTxManager.TransactionStatus status;
    private final List<Integer> datasetIds;
    private final int numPartitions;
    private final Map<String, Map<String, ILSMComponentId>> nodeResourceMap;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public GlobalTransactionContext(JobId jobId, List<Integer> datasetIds, int numNodes, int numPartitions) {
        this.jobId = jobId;
        this.datasetIds = datasetIds;
        this.numNodes = numNodes;
        this.numPartitions = numPartitions;
        this.acksReceived = new AtomicInteger(0);
        this.nodeResourceMap = new HashMap<String, Map<String, ILSMComponentId>>();
        this.status = IGlobalTxManager.TransactionStatus.ACTIVE;
    }

    public GlobalTransactionContext(FileReference txnLogFileRef, IOManager ioManager) {
        try {
            AtomicTransactionLog txnLog = (AtomicTransactionLog)OBJECT_MAPPER.readValue(new String(ioManager.readAllBytes(txnLogFileRef)), AtomicTransactionLog.class);
            this.jobId = txnLog.getJobId();
            this.datasetIds = txnLog.getDatasetIds();
            this.nodeResourceMap = txnLog.getNodeResourceMap();
            this.numNodes = this.nodeResourceMap.keySet().size();
            this.numPartitions = txnLog.getNumPartitions();
            this.acksReceived = new AtomicInteger(0);
        }
        catch (JsonProcessingException | HyracksDataException e) {
            throw new ACIDException(e);
        }
    }

    public void setTxnStatus(IGlobalTxManager.TransactionStatus status) {
        this.status = status;
    }

    public IGlobalTxManager.TransactionStatus getTxnStatus() {
        return this.status;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public int incrementAndGetAcksReceived() {
        return this.acksReceived.incrementAndGet();
    }

    public int getAcksReceived() {
        return this.acksReceived.get();
    }

    public void resetAcksReceived() {
        this.acksReceived = new AtomicInteger(0);
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public List<Integer> getDatasetIds() {
        return this.datasetIds;
    }

    public Map<String, Map<String, ILSMComponentId>> getNodeResourceMap() {
        return this.nodeResourceMap;
    }

    public void persist(IOManager ioManager) {
        try {
            FileReference fref = ioManager.resolve(Paths.get(String.format("%s.log", this.jobId), new String[0]).toString());
            AtomicTransactionLog txnLog = new AtomicTransactionLog(this.jobId, this.datasetIds, this.nodeResourceMap.keySet(), this.nodeResourceMap, this.numPartitions);
            ioManager.overwrite(fref, OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)txnLog).getBytes());
        }
        catch (JsonProcessingException | HyracksDataException e) {
            throw new ACIDException(e);
        }
    }

    public void delete(IOManager ioManager) {
        try {
            FileReference fref = ioManager.resolve(Paths.get(String.format("%s.log", this.jobId), new String[0]).toString());
            ioManager.delete(fref);
        }
        catch (HyracksDataException e) {
            throw new RuntimeException(e);
        }
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + this.jobId + "\n");
        sb.append("TransactionState: " + this.status + "\n");
        return sb.toString();
    }
}

