/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.util.TimerTask;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ProtocolEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractPollTableEntry
extends ProtocolEndpoint {
    private static final Log log = LogFactory.getLog(AbstractPollTableEntry.class);
    public static final int SUCCSESSFUL = 0;
    public static final int WITH_ERRORS = 1;
    public static final int FAILED = 2;
    public static final int NONE = 3;
    private long nextPollTime;
    private long lastPollTime;
    private long pollInterval;
    private int lastPollState;
    private boolean concurrentPollingAllowed = false;
    TimerTask timerTask;
    boolean canceled;

    public long getNextPollTime() {
        return this.nextPollTime;
    }

    public void setNextPollTime(long nextPollTime) {
        this.nextPollTime = nextPollTime;
    }

    public long getLastPollTime() {
        return this.lastPollTime;
    }

    public void setLastPollTime(long lastPollTime) {
        this.lastPollTime = lastPollTime;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public int getLastPollState() {
        return this.lastPollState;
    }

    public void setLastPollState(int lastPollState) {
        this.lastPollState = lastPollState;
    }

    public boolean isConcurrentPollingAllowed() {
        return this.concurrentPollingAllowed;
    }

    public void setConcurrentPollingAllowed(boolean concurrentPollingAllowed) {
        this.concurrentPollingAllowed = concurrentPollingAllowed;
    }

    @Override
    public boolean loadConfiguration(ParameterInclude params) throws AxisFault {
        Parameter param = params.getParameter("transport.PollInterval");
        this.pollInterval = 300000L;
        if (param != null && param.getValue() instanceof String) {
            int multiplier;
            String s = (String)param.getValue();
            if (s.endsWith("ms")) {
                s = s.substring(0, s.length() - 2);
                multiplier = 1;
            } else {
                multiplier = 1000;
            }
            try {
                this.pollInterval = Integer.parseInt(s) * multiplier;
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid poll interval : " + String.valueOf(param.getValue()) + ",  default to : 300sec"), (Throwable)e);
            }
        }
        return true;
    }
}

