/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.beans;

import org.apache.axis2.addressing.EndpointReference;
import org.apache.sandesha2.storage.beans.RMBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;

public class RMSBean
extends RMSequenceBean {
    private static final long serialVersionUID = 7051201094510208784L;
    private String internalSequenceID;
    private String createSeqMsgID;
    private String createSequenceMsgStoreKey;
    private String referenceMessageStoreKey;
    private Exception lastSendError = null;
    private String highestOutRelatesTo = null;
    private RangeString clientCompletedMessages = null;
    private String transportTo;
    private String offeredEndPoint = null;
    private EndpointReference offeredEndPointEPR = null;
    private String offeredSequence = null;
    private String anonymousUUID = null;
    private long lastSendErrorTimestamp = -1L;
    private long lastOutMessage = 0L;
    private long highestOutMessageNumber = 0L;
    private long nextMessageNumber = -1L;
    private boolean terminateAdded = false;
    private boolean timedOut = false;
    private boolean sequenceClosedClient = false;
    private long expectedReplies = 0L;
    private int soapVersion;
    private boolean terminationPauserForCS = false;
    private boolean avoidAutoTermination = false;
    private int rmsFlags = 0;
    private int reallocated = 0;
    private String internalSeqIDOfSeqUsedForReallocation = null;
    public static final int LAST_SEND_ERROR_TIME_FLAG = 1;
    public static final int LAST_OUT_MSG_FLAG = 16;
    public static final int HIGHEST_OUT_MSG_FLAG = 256;
    public static final int NEXT_MSG_NUM_FLAG = 4096;
    public static final int TERMINATE_ADDED_FLAG = 65536;
    public static final int TIMED_OUT_FLAG = 0x100000;
    public static final int SEQ_CLOSED_CLIENT_FLAG = 0x1000000;
    public static final int ACKED_MESSAGES_FLAG = 0x10000000;
    public static final int TERM_PAUSER_FOR_CS = 2;
    public static final int EXPECTED_REPLIES = 32;
    public static final int SOAP_VERSION_FLAG = 512;
    public static final int REALLOCATED = 8192;

    public RMSBean() {
    }

    public RMSBean(RMSBean beanToCopy) {
        super(beanToCopy);
        this.anonymousUUID = beanToCopy.getAnonymousUUID();
        if (beanToCopy.getClientCompletedMessages() != null) {
            this.clientCompletedMessages = new RangeString(beanToCopy.getClientCompletedMessages());
        }
        this.createSeqMsgID = beanToCopy.getCreateSeqMsgID();
        this.createSequenceMsgStoreKey = beanToCopy.getCreateSequenceMsgStoreKey();
        this.expectedReplies = beanToCopy.getExpectedReplies();
        this.highestOutMessageNumber = beanToCopy.getHighestOutMessageNumber();
        this.highestOutRelatesTo = beanToCopy.getHighestOutRelatesTo();
        this.internalSequenceID = beanToCopy.getInternalSequenceID();
        this.lastOutMessage = beanToCopy.getLastOutMessage();
        this.lastSendError = beanToCopy.getLastSendError();
        this.lastSendErrorTimestamp = beanToCopy.getLastSendErrorTimestamp();
        this.nextMessageNumber = beanToCopy.getNextMessageNumber();
        this.offeredEndPoint = beanToCopy.getOfferedEndPoint();
        this.offeredEndPointEPR = beanToCopy.getOfferedEndPointEPR();
        this.offeredSequence = beanToCopy.getOfferedSequence();
        this.referenceMessageStoreKey = beanToCopy.getReferenceMessageStoreKey();
        this.sequenceClosedClient = beanToCopy.isSequenceClosedClient();
        this.soapVersion = beanToCopy.getSoapVersion();
        this.terminateAdded = beanToCopy.isTerminateAdded();
        this.terminationPauserForCS = beanToCopy.isTerminationPauserForCS();
        this.timedOut = beanToCopy.isTimedOut();
        this.transportTo = beanToCopy.getTransportTo();
        this.avoidAutoTermination = beanToCopy.isAvoidAutoTermination();
        this.reallocated = beanToCopy.isReallocated();
        this.internalSeqIDOfSeqUsedForReallocation = beanToCopy.getInternalSeqIDOfSeqUsedForReallocation();
    }

    public String getCreateSeqMsgID() {
        return this.createSeqMsgID;
    }

    public void setCreateSeqMsgID(String createSeqMsgID) {
        this.createSeqMsgID = createSeqMsgID;
    }

    public String getInternalSequenceID() {
        return this.internalSequenceID;
    }

    public void setInternalSequenceID(String internalSequenceID) {
        this.internalSequenceID = internalSequenceID;
    }

    public String getCreateSequenceMsgStoreKey() {
        return this.createSequenceMsgStoreKey;
    }

    public void setCreateSequenceMsgStoreKey(String createSequenceMsgStoreKey) {
        this.createSequenceMsgStoreKey = createSequenceMsgStoreKey;
    }

    public String getReferenceMessageStoreKey() {
        return this.referenceMessageStoreKey;
    }

    public void setReferenceMessageStoreKey(String referenceMessageStoreKey) {
        this.referenceMessageStoreKey = referenceMessageStoreKey;
    }

    public Exception getLastSendError() {
        return this.lastSendError;
    }

    public void setLastSendError(Exception lastSendError) {
        this.lastSendError = lastSendError;
    }

    public long getLastSendErrorTimestamp() {
        return this.lastSendErrorTimestamp;
    }

    public void setLastSendErrorTimestamp(long lastSendErrorTimestamp) {
        this.lastSendErrorTimestamp = lastSendErrorTimestamp;
        this.rmsFlags |= 1;
    }

    public long getLastOutMessage() {
        return this.lastOutMessage;
    }

    public void setLastOutMessage(long lastOutMessage) {
        this.lastOutMessage = lastOutMessage;
        this.rmsFlags |= 0x10;
    }

    public long getHighestOutMessageNumber() {
        return this.highestOutMessageNumber;
    }

    public void setHighestOutMessageNumber(long highestOutMessageNumber) {
        this.highestOutMessageNumber = highestOutMessageNumber;
        this.rmsFlags |= 0x100;
    }

    public String getHighestOutRelatesTo() {
        return this.highestOutRelatesTo;
    }

    public void setHighestOutRelatesTo(String highestOutRelatesTo) {
        this.highestOutRelatesTo = highestOutRelatesTo;
    }

    public long getNextMessageNumber() {
        return this.nextMessageNumber;
    }

    public void setNextMessageNumber(long nextMessageNumber) {
        this.nextMessageNumber = nextMessageNumber;
        this.rmsFlags |= 0x1000;
    }

    public RangeString getClientCompletedMessages() {
        return this.clientCompletedMessages;
    }

    public void setClientCompletedMessages(RangeString clientCompletedMessages) {
        this.clientCompletedMessages = clientCompletedMessages;
    }

    public boolean isTerminateAdded() {
        return this.terminateAdded;
    }

    public void setTerminateAdded(boolean terminateAdded) {
        this.terminateAdded = terminateAdded;
        this.rmsFlags |= 0x10000;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
        this.rmsFlags |= 0x100000;
    }

    public boolean isSequenceClosedClient() {
        return this.sequenceClosedClient;
    }

    public void setSequenceClosedClient(boolean sequenceClosedClient) {
        this.sequenceClosedClient = sequenceClosedClient;
        this.rmsFlags |= 0x1000000;
    }

    public long getNumberOfMessagesAcked() {
        long numberOfMessagesAcked = 0L;
        if (this.clientCompletedMessages != null) {
            Range[] ranges = this.clientCompletedMessages.getRanges();
            for (int rangeIndex = 0; rangeIndex < ranges.length; ++rangeIndex) {
                Range range = ranges[rangeIndex];
                numberOfMessagesAcked = range.upperValue - range.lowerValue + 1L;
            }
        }
        return numberOfMessagesAcked;
    }

    public String getTransportTo() {
        return this.transportTo;
    }

    public void setTransportTo(String transportTo) {
        this.transportTo = transportTo;
    }

    public String getOfferedEndPoint() {
        return this.offeredEndPoint;
    }

    public void setOfferedEndPoint(String offeredEndPoint) {
        this.offeredEndPoint = offeredEndPoint;
    }

    public String getOfferedSequence() {
        return this.offeredSequence;
    }

    public void setOfferedSequence(String offeredSequence) {
        this.offeredSequence = offeredSequence;
    }

    public boolean isTerminationPauserForCS() {
        return this.terminationPauserForCS;
    }

    public void setTerminationPauserForCS(boolean terminationPauserForCS) {
        this.terminationPauserForCS = terminationPauserForCS;
        this.rmsFlags |= 2;
    }

    public long getExpectedReplies() {
        return this.expectedReplies;
    }

    public void setExpectedReplies(long expectedReplies) {
        this.expectedReplies = expectedReplies;
        this.rmsFlags |= 0x20;
    }

    public String getAnonymousUUID() {
        return this.anonymousUUID;
    }

    public void setAnonymousUUID(String anonymousUUID) {
        this.anonymousUUID = anonymousUUID;
    }

    public boolean isAvoidAutoTermination() {
        return this.avoidAutoTermination;
    }

    public void setAvoidAutoTermination(boolean avoidAutoTermination) {
        this.avoidAutoTermination = avoidAutoTermination;
    }

    public int getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(int soapVersion) {
        this.soapVersion = soapVersion;
    }

    public int getRmsFlags() {
        return this.rmsFlags;
    }

    public void setRmsFlags(int rmsFlags) {
        this.rmsFlags = rmsFlags;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName());
        result.append(super.toString());
        result.append("\nInternal Seq Id  : ");
        result.append(this.internalSequenceID);
        result.append("\nCreateSeq Msg Id : ");
        result.append(this.createSeqMsgID);
        result.append("\nCreateSeq Msg Key: ");
        result.append(this.createSequenceMsgStoreKey);
        result.append("\nReference Msg Key: ");
        result.append(this.referenceMessageStoreKey);
        result.append("\nLastOutMessageNumber: ");
        result.append(this.lastOutMessage);
        result.append("\nHighestOutMessage: ");
        result.append(this.highestOutMessageNumber);
        result.append("\nHighestOutRelatesTo: ");
        result.append(this.highestOutRelatesTo);
        result.append("\nNextMessageNumber: ");
        result.append(this.nextMessageNumber);
        result.append("\nTerminateAdded   : ");
        result.append(this.terminateAdded);
        result.append("\nTerminatePauser  : ");
        result.append(this.terminationPauserForCS);
        result.append("\nTimedOut         : ");
        result.append(this.timedOut);
        result.append("\nClosedClient     : ");
        result.append(this.sequenceClosedClient);
        result.append("\nExpectedReplies  : ");
        result.append(this.expectedReplies);
        result.append("\nTransportTo      : ");
        result.append(this.transportTo);
        if (this.offeredEndPointEPR != null) {
            result.append("\nOfferedEndPoint  : ");
            result.append(this.offeredEndPointEPR.getAddress());
        } else {
            result.append("\nOfferedEndPoint  : null");
        }
        result.append("\nOfferedSequence  : ");
        result.append(this.offeredSequence);
        if (this.lastSendErrorTimestamp > 0L) {
            result.append("\nLastError        : ");
            result.append(this.lastSendError);
            result.append("\nLastErrorTime    : ");
            result.append(this.lastSendErrorTimestamp);
        }
        result.append("\nClientCompletedMsgs: ");
        result.append(this.clientCompletedMessages);
        result.append("\nAnonymous UUID     : ");
        result.append(this.anonymousUUID);
        result.append("\nSOAPVersion  : ");
        result.append(this.soapVersion);
        result.append("\nReallocated  : ");
        result.append(this.reallocated);
        result.append("\nInternalSeqIDOfSeqUsedForReallocation  : ");
        result.append(this.internalSeqIDOfSeqUsedForReallocation);
        return result.toString();
    }

    public boolean match(RMBean matchInfo) {
        RMSBean bean = (RMSBean)matchInfo;
        boolean match = true;
        if (!super.match(matchInfo)) {
            match = false;
        } else if (bean.getInternalSequenceID() != null && !bean.getInternalSequenceID().equals(this.getInternalSequenceID())) {
            match = false;
        } else if (bean.getCreateSeqMsgID() != null && !bean.getCreateSeqMsgID().equals(this.getCreateSeqMsgID())) {
            match = false;
        } else if (bean.getCreateSequenceMsgStoreKey() != null && !bean.getCreateSequenceMsgStoreKey().equals(this.getCreateSequenceMsgStoreKey())) {
            match = false;
        } else if (bean.getReferenceMessageStoreKey() != null && !bean.getReferenceMessageStoreKey().equals(this.getReferenceMessageStoreKey())) {
            match = false;
        } else if (bean.getHighestOutRelatesTo() != null && !bean.getHighestOutRelatesTo().equals(this.getHighestOutRelatesTo())) {
            match = false;
        } else if (bean.getClientCompletedMessages() != null && !bean.getClientCompletedMessages().equals(this.getClientCompletedMessages())) {
            match = false;
        } else if (bean.getTransportTo() != null && !bean.getTransportTo().equals(this.getTransportTo())) {
            match = false;
        } else if (bean.getOfferedEndPointEPR() != null && !bean.getOfferedEndPointEPR().getAddress().equals(this.getOfferedEndPointEPR().getAddress())) {
            match = false;
        } else if (bean.getOfferedEndPoint() != null && !bean.getOfferedEndPoint().equals(this.getOfferedEndPoint())) {
            match = false;
        } else if (bean.getOfferedSequence() != null && !bean.getOfferedSequence().equals(this.getOfferedSequence())) {
            match = false;
        } else if (bean.getAnonymousUUID() != null && !bean.getAnonymousUUID().equals(this.getAnonymousUUID())) {
            match = false;
        } else if (bean.getInternalSeqIDOfSeqUsedForReallocation() != null && !bean.getInternalSeqIDOfSeqUsedForReallocation().equals(this.getInternalSeqIDOfSeqUsedForReallocation())) {
            match = false;
        } else if ((bean.rmsFlags & 0x2000) != 0 && bean.isReallocated() != this.isReallocated()) {
            match = false;
        } else if ((bean.rmsFlags & 0x10) != 0 && bean.getLastOutMessage() != this.getLastOutMessage()) {
            match = false;
        } else if ((bean.rmsFlags & 0x100) != 0 && bean.getHighestOutMessageNumber() != this.getHighestOutMessageNumber()) {
            match = false;
        } else if ((bean.rmsFlags & 0x1000) != 0 && bean.getNextMessageNumber() != this.getNextMessageNumber()) {
            match = false;
        } else if ((bean.rmsFlags & 0x10000) != 0 && bean.isTerminateAdded() != this.isTerminateAdded()) {
            match = false;
        } else if ((bean.rmsFlags & 0x200) != 0 && bean.getSoapVersion() != this.getSoapVersion()) {
            match = false;
        } else if ((bean.rmsFlags & 0x100000) != 0 && bean.isTimedOut() != this.isTimedOut()) {
            match = false;
        } else if ((bean.rmsFlags & 0x1000000) != 0 && bean.isSequenceClosedClient() != this.isSequenceClosedClient()) {
            match = false;
        } else if ((bean.rmsFlags & 0x10000000) != 0 && bean.getNumberOfMessagesAcked() != this.getNumberOfMessagesAcked()) {
            match = false;
        } else if ((bean.rmsFlags & 2) != 0 && bean.isTerminationPauserForCS() != this.isTerminationPauserForCS()) {
            match = false;
        } else if ((bean.rmsFlags & 0x20) != 0 && bean.getExpectedReplies() != this.getExpectedReplies()) {
            match = false;
        }
        return match;
    }

    public int isReallocated() {
        return this.reallocated;
    }

    public void setReallocated(int reallocated) {
        this.reallocated = reallocated;
        this.rmsFlags |= 0x2000;
    }

    public String getInternalSeqIDOfSeqUsedForReallocation() {
        return this.internalSeqIDOfSeqUsedForReallocation;
    }

    public void setInternalSeqIDOfSeqUsedForReallocation(String internalSeqIDOfSeqUsedForReallocation) {
        this.internalSeqIDOfSeqUsedForReallocation = internalSeqIDOfSeqUsedForReallocation;
    }

    public EndpointReference getOfferedEndPointEPR() {
        return this.offeredEndPointEPR;
    }

    public void setOfferedEndPointEPR(EndpointReference offeredEndPointEPR) {
        this.offeredEndPointEPR = offeredEndPointEPR;
        this.offeredEndPoint = offeredEndPointEPR.getAddress();
    }
}

