/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.google.common.base.Preconditions;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoIsAuditorService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(WhoIsAuditorService.class);
    protected ServerConfiguration conf;
    protected ZooKeeper zk;

    public WhoIsAuditorService(ServerConfiguration conf, ZooKeeper zk) {
        Preconditions.checkNotNull((Object)((Object)conf));
        this.conf = conf;
        this.zk = zk;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET == request.getMethod()) {
            BookieSocketAddress bookieId = null;
            try {
                bookieId = AuditorElector.getCurrentAuditor(this.conf, this.zk);
                if (bookieId == null) {
                    response.setCode(HttpServer.StatusCode.NOT_FOUND);
                    response.setBody("No auditor elected");
                    return response;
                }
            }
            catch (Exception e) {
                LOG.error("Meet Exception: ", (Throwable)e);
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Exception when get." + e.getMessage());
                return response;
            }
            response.setCode(HttpServer.StatusCode.OK);
            response.setBody("Auditor: " + bookieId.getSocketAddress().getAddress().getCanonicalHostName() + "/" + bookieId.getSocketAddress().getAddress().getHostAddress() + ":" + bookieId.getSocketAddress().getPort());
            LOG.debug("response body:" + response.getBody());
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

