/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PemTrustOptions;
import java.util.Base64;

public class PemTrustOptionsConverter {
    public static void fromJson(JsonObject json, PemTrustOptions obj) {
        if (json.getValue("certPaths") instanceof JsonArray) {
            json.getJsonArray("certPaths").forEach(item -> {
                if (item instanceof String) {
                    obj.addCertPath((String)item);
                }
            });
        }
        if (json.getValue("certValues") instanceof JsonArray) {
            json.getJsonArray("certValues").forEach(item -> {
                if (item instanceof String) {
                    obj.addCertValue(Buffer.buffer(Base64.getDecoder().decode((String)item)));
                }
            });
        }
    }

    public static void toJson(PemTrustOptions obj, JsonObject json) {
        JsonArray array;
        if (obj.getCertPaths() != null) {
            array = new JsonArray();
            obj.getCertPaths().forEach(item -> array.add((String)item));
            json.put("certPaths", array);
        }
        if (obj.getCertValues() != null) {
            array = new JsonArray();
            obj.getCertValues().forEach(item -> array.add(item.getBytes()));
            json.put("certValues", array);
        }
    }
}

