/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookies;

import com.beust.jcommander.Parameter;
import java.util.Collection;
import java.util.Set;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.tools.cli.helpers.CommandHelpers;
import org.apache.bookkeeper.tools.cli.helpers.DiscoveryCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.versioning.Versioned;

public class ListBookiesCommand
extends DiscoveryCommand<Flags> {
    private static final String NAME = "list";
    private static final String DESC = "List the bookies, which are running as either readwrite or readonly mode.";

    public ListBookiesCommand() {
        this(new Flags());
    }

    public ListBookiesCommand(Flags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).build());
    }

    @Override
    protected void run(RegistrationClient regClient, Flags flags) throws Exception {
        Set bookies;
        if (!(flags.readwrite || flags.readonly || flags.all)) {
            flags.readwrite = true;
            flags.readonly = true;
            flags.all = true;
        }
        boolean hasBookies = false;
        if (flags.readwrite && !(bookies = (Set)((Versioned)FutureUtils.result(regClient.getWritableBookies())).getValue()).isEmpty()) {
            System.out.println("ReadWrite Bookies :");
            ListBookiesCommand.printBookies(bookies);
            hasBookies = true;
        }
        if (flags.readonly && !(bookies = (Set)((Versioned)FutureUtils.result(regClient.getReadOnlyBookies())).getValue()).isEmpty()) {
            System.out.println("Readonly Bookies :");
            ListBookiesCommand.printBookies(bookies);
            hasBookies = true;
        }
        if (flags.all && !(bookies = (Set)((Versioned)FutureUtils.result(regClient.getAllBookies())).getValue()).isEmpty()) {
            System.out.println("All Bookies :");
            ListBookiesCommand.printBookies(bookies);
            hasBookies = true;
        }
        if (!hasBookies) {
            System.err.println("No bookie exists!");
        }
    }

    private static void printBookies(Collection<BookieSocketAddress> bookies) {
        for (BookieSocketAddress b : bookies) {
            System.out.println(CommandHelpers.getBookieSocketAddrStringRepresentation(b));
        }
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-rw", "--readwrite"}, description="Print readwrite bookies")
        private boolean readwrite = false;
        @Parameter(names={"-ro", "--readonly"}, description="Print readonly bookies")
        private boolean readonly = false;
        @Parameter(names={"-a", "--all"}, description="Print all bookies")
        private boolean all = false;

        public Flags readwrite(boolean readwrite) {
            this.readwrite = readwrite;
            return this;
        }

        public Flags readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public Flags all(boolean all) {
            this.all = all;
            return this;
        }
    }
}

