/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.internal.GrpcUtil;
import io.grpc.xds.ClientLoadCounter;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.ReferenceCounted;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class LoadStatsStoreImpl
implements LoadStatsManager.LoadStatsStore {
    private final String clusterName;
    @Nullable
    private final String clusterServiceName;
    private final ConcurrentMap<EnvoyProtoData.Locality, ReferenceCounted<ClientLoadCounter>> localityLoadCounters = new ConcurrentHashMap<EnvoyProtoData.Locality, ReferenceCounted<ClientLoadCounter>>();
    private final ConcurrentMap<String, AtomicLong> dropCounters;
    private final Stopwatch stopwatch;

    LoadStatsStoreImpl(String clusterName, @Nullable String clusterServiceName) {
        this(clusterName, clusterServiceName, (Stopwatch)GrpcUtil.STOPWATCH_SUPPLIER.get(), new ConcurrentHashMap<String, AtomicLong>());
    }

    @VisibleForTesting
    LoadStatsStoreImpl(String clusterName, @Nullable String clusterServiceName, Stopwatch stopwatch, ConcurrentMap<String, AtomicLong> dropCounters) {
        this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
        this.clusterServiceName = clusterServiceName;
        this.stopwatch = (Stopwatch)Preconditions.checkNotNull((Object)stopwatch, (Object)"stopwatch");
        this.dropCounters = (ConcurrentMap)Preconditions.checkNotNull(dropCounters, (Object)"dropCounters");
        stopwatch.reset().start();
    }

    @Override
    public EnvoyProtoData.ClusterStats generateLoadReport() {
        EnvoyProtoData.ClusterStats.Builder statsBuilder = EnvoyProtoData.ClusterStats.newBuilder();
        statsBuilder.setClusterName(this.clusterName);
        if (this.clusterServiceName != null) {
            statsBuilder.setClusterServiceName(this.clusterServiceName);
        }
        for (Map.Entry entry : this.localityLoadCounters.entrySet()) {
            ClientLoadCounter.ClientLoadSnapshot snapshot = ((ClientLoadCounter)((ReferenceCounted)entry.getValue()).get()).snapshot();
            EnvoyProtoData.UpstreamLocalityStats.Builder localityStatsBuilder = EnvoyProtoData.UpstreamLocalityStats.newBuilder().setLocality((EnvoyProtoData.Locality)entry.getKey());
            localityStatsBuilder.setTotalSuccessfulRequests(snapshot.getCallsSucceeded()).setTotalErrorRequests(snapshot.getCallsFailed()).setTotalRequestsInProgress(snapshot.getCallsInProgress()).setTotalIssuedRequests(snapshot.getCallsIssued());
            for (Map.Entry<String, ClientLoadCounter.MetricValue> metric : snapshot.getMetricValues().entrySet()) {
                localityStatsBuilder.addLoadMetricStats(EnvoyProtoData.EndpointLoadMetricStats.newBuilder().setMetricName(metric.getKey()).setNumRequestsFinishedWithMetric(metric.getValue().getNumReports()).setTotalMetricValue(metric.getValue().getTotalValue()).build());
            }
            statsBuilder.addUpstreamLocalityStats(localityStatsBuilder.build());
            if (((ReferenceCounted)entry.getValue()).getReferenceCount() != 0 || snapshot.getCallsInProgress() != 0L) continue;
            this.localityLoadCounters.remove(entry.getKey());
        }
        long totalDrops = 0L;
        for (Map.Entry entry : this.dropCounters.entrySet()) {
            long drops = ((AtomicLong)entry.getValue()).getAndSet(0L);
            totalDrops += drops;
            statsBuilder.addDroppedRequests(new EnvoyProtoData.ClusterStats.DroppedRequests((String)entry.getKey(), drops));
        }
        statsBuilder.setTotalDroppedRequests(totalDrops);
        statsBuilder.setLoadReportIntervalNanos(this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
        this.stopwatch.reset().start();
        return statsBuilder.build();
    }

    @Override
    public ClientLoadCounter addLocality(EnvoyProtoData.Locality locality) {
        ReferenceCounted<ClientLoadCounter> counter = (ReferenceCounted<ClientLoadCounter>)this.localityLoadCounters.get(locality);
        if (counter == null) {
            counter = ReferenceCounted.wrap(new ClientLoadCounter());
            this.localityLoadCounters.put(locality, counter);
        }
        counter.retain();
        return (ClientLoadCounter)counter.get();
    }

    @Override
    public void removeLocality(EnvoyProtoData.Locality locality) {
        ReferenceCounted counter = (ReferenceCounted)this.localityLoadCounters.get(locality);
        counter.release();
    }

    @Override
    public void recordDroppedRequest(String category) {
        AtomicLong counter = (AtomicLong)this.dropCounters.get(category);
        if (counter == null && (counter = this.dropCounters.putIfAbsent(category, new AtomicLong())) == null) {
            counter = (AtomicLong)this.dropCounters.get(category);
        }
        counter.getAndIncrement();
    }

    static LoadStatsManager.LoadStatsStoreFactory getDefaultFactory() {
        return new LoadStatsManager.LoadStatsStoreFactory(){

            @Override
            public LoadStatsManager.LoadStatsStore newLoadStatsStore(String cluster, String clusterService) {
                return new LoadStatsStoreImpl(cluster, clusterService);
            }
        };
    }
}

