/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.property;

import java.util.Set;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.ValueType;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;
import org.inferred.freebuilder.shaded.com.google.common.collect.TreeMultimap;

public class MergeAction
extends ValueType {
    private final String verb;
    private final String noun;
    private final boolean builderOnly;

    public static MergeAction appendingToCollections() {
        return new MergeAction("appending to", "collections", false);
    }

    public static MergeAction skippingDefaults() {
        return new MergeAction("skipping", "defaults", false);
    }

    public static MergeAction skippingEmptyOptionals() {
        return new MergeAction("skipping", "empty optionals", false);
    }

    public static MergeAction skippingUnsetProperties() {
        return new MergeAction("skipping", "unset properties", true);
    }

    public static void addActionsTo(SourceBuilder code, Set<MergeAction> mergeActions, boolean forBuilder) {
        TreeMultimap nounsByVerb = TreeMultimap.create();
        mergeActions.forEach(mergeAction -> {
            if (forBuilder || !mergeAction.builderOnly) {
                nounsByVerb.put(mergeAction.verb, mergeAction.noun);
            }
        });
        ImmutableList verbs = ImmutableList.copyOf(nounsByVerb.keySet());
        String lastVerb = Iterables.getLast(verbs, null);
        for (String verb : nounsByVerb.keySet()) {
            code.add(", %s%s", verbs.size() > 1 && verb.equals(lastVerb) ? "and " : "", verb);
            ImmutableList nouns = ImmutableList.copyOf(nounsByVerb.get(verb));
            for (int i = 0; i < nouns.size(); ++i) {
                String separator = i == 0 ? "" : (i == nouns.size() - 1 ? " and" : ",");
                code.add("%s %s", separator, nouns.get(i));
            }
        }
    }

    private MergeAction(String verb, String noun, boolean builderOnly) {
        this.verb = verb;
        this.noun = noun;
        this.builderOnly = builderOnly;
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("verb", this.verb);
        fields.add("noun", this.noun);
        fields.add("builderOnly", this.builderOnly);
    }

    @Override
    public String toString() {
        return this.verb + " " + this.noun + (this.builderOnly ? " on builders" : "");
    }
}

