/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.inferred.freebuilder.processor.source.IdKey;
import org.inferred.freebuilder.processor.source.ImportManager;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.QualifiedNameAppendable;
import org.inferred.freebuilder.processor.source.Scope;
import org.inferred.freebuilder.processor.source.ScopeHandler;
import org.inferred.freebuilder.processor.source.SourceParser;
import org.inferred.freebuilder.processor.source.TypeUsage;
import org.inferred.freebuilder.processor.source.feature.Feature;
import org.inferred.freebuilder.processor.source.feature.FeatureSet;
import org.inferred.freebuilder.processor.source.feature.FeatureType;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.Formatter;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.FormatterException;

class CompilationUnitBuilder
implements QualifiedNameAppendable,
SourceParser.EventHandler {
    private final FeatureSet features;
    private final ScopeHandler scopeHandler;
    private final SourceParser parser;
    private final List<Scope> scopes = new ArrayList<Scope>();
    private final List<QualifiedName> types = new ArrayList<QualifiedName>();
    private final List<TypeUsage> usages = new ArrayList<TypeUsage>();
    private String pkg;
    private String topLevelType;
    private int importsIndex = -1;
    private final StringBuilder source = new StringBuilder();

    CompilationUnitBuilder(ScopeHandler.Reflection reflect, FeatureSet features) {
        this.features = features;
        this.scopeHandler = new ScopeHandler(reflect);
        this.parser = new SourceParser(this);
        this.scopes.add(new InitialScope());
        this.types.add(null);
    }

    public <T extends Feature<T>> T feature(FeatureType<T> feature) {
        return this.features.get(feature);
    }

    public QualifiedName typename() {
        Preconditions.checkState(this.pkg != null, "No package statement");
        Preconditions.checkState(this.topLevelType != null, "No class declaration");
        return QualifiedName.of(this.pkg, this.topLevelType, new String[0]);
    }

    @Override
    public void onPackageStatement(String packageName) {
        Preconditions.checkState(this.importsIndex == -1, "Package redeclared");
        Preconditions.checkState(this.scopes.size() == 1, "Package declaration too late");
        InitialScope initialScope = (InitialScope)Iterables.getLast(this.scopes);
        Preconditions.checkState(initialScope.isEmpty(), "Package declaration too late");
        this.scopes.add(new Scope.FileScope());
        this.pkg = packageName;
        this.importsIndex = this.source.length();
    }

    @Override
    public void onTypeBlockStart(String keyword, String simpleName, Set<String> supertypes) {
        if (this.topLevelType == null) {
            this.topLevelType = simpleName;
        }
        QualifiedName type = this.nestedType(simpleName);
        this.types.add(type);
        this.scopes.add(Iterables.getLast(this.scopes));
        this.scopeHandler.declareGeneratedType(ScopeHandler.Visibility.UNKNOWN, type, supertypes);
    }

    private QualifiedName nestedType(String simpleName) {
        QualifiedName outerType = Iterables.getLast(this.types);
        if (outerType == null) {
            return QualifiedName.of(this.pkg, simpleName, new String[0]);
        }
        return outerType.nestedType(simpleName);
    }

    @Override
    public void onMethodBlockStart(String methodName, Set<String> paramNames) {
        Scope.MethodScope methodScope = new Scope.MethodScope(Iterables.getLast(this.scopes));
        for (String paramName : paramNames) {
            methodScope.putIfAbsent(new IdKey(paramName), methodScope);
        }
        this.types.add(Iterables.getLast(this.types));
        this.scopes.add(methodScope);
    }

    @Override
    public void onOtherBlockStart() {
        this.types.add(Iterables.getLast(this.types));
        this.scopes.add(Iterables.getLast(this.scopes));
    }

    @Override
    public void onBlockEnd() {
        this.types.remove(this.types.size() - 1);
        this.scopes.remove(this.scopes.size() - 1);
        Preconditions.checkState(!this.types.isEmpty(), "Unexpected '}'");
    }

    @Override
    public void append(char c) {
        this.source.append(c);
        this.parser.parse(c);
    }

    @Override
    public void append(CharSequence csq) {
        this.append(csq, 0, csq.length());
    }

    @Override
    public void append(CharSequence csq, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
    }

    @Override
    public void append(QualifiedName type) {
        if (type.getPackage().isEmpty() && type.isTopLevel()) {
            this.append(type.getSimpleName());
            return;
        }
        TypeUsage.Builder usage = new TypeUsage.Builder().start(this.source.length()).type(type).nullableScope(Iterables.getLast(this.types));
        this.append(type.toString());
        this.usages.add(usage.end(this.source.length()).build());
    }

    public Scope scope() {
        return Iterables.getLast(this.scopes);
    }

    public String toString() {
        if (this.importsIndex == -1) {
            return CompilationUnitBuilder.formatSnippet(this.source, this.usages);
        }
        return CompilationUnitBuilder.formatSource(ImportManager.shortenReferences(this.source, this.pkg, this.importsIndex, this.usages, this.scopeHandler));
    }

    private static String formatSnippet(StringBuilder source, List<TypeUsage> usages) {
        StringBuilder snippet = new StringBuilder();
        int offset = 0;
        for (TypeUsage usage : usages) {
            snippet.append(source, offset, usage.start());
            snippet.append(usage.type().getSimpleNames().stream().collect(Collectors.joining(".")));
            offset = usage.end();
        }
        snippet.append(source, offset, source.length());
        return snippet.toString();
    }

    private static String formatSource(String source) {
        try {
            return new Formatter().formatSource(source);
        }
        catch (RuntimeException | FormatterException e) {
            StringBuilder message = new StringBuilder().append("Formatter failed:\n").append(e.getMessage()).append("\nGenerated source:");
            int lineNo = 0;
            for (String line : source.split("\n")) {
                message.append("\n").append(++lineNo).append(": ").append(line);
            }
            throw new RuntimeException(message.toString());
        }
    }

    private static class InitialScope
    extends Scope {
        private InitialScope() {
        }

        @Override
        protected boolean canStore(Scope.Key<?> key) {
            return true;
        }
    }
}

