/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;

public class ConcurrentOpenHashSet<V> {
    private static final Object EmptyValue = null;
    private static final Object DeletedValue = new Object();
    private static final float MapFillFactor = 0.66f;
    private static final int DefaultExpectedItems = 256;
    private static final int DefaultConcurrencyLevel = 16;
    private final Section<V>[] sections;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public ConcurrentOpenHashSet() {
        this(256);
    }

    public ConcurrentOpenHashSet(int expectedItems) {
        this(expectedItems, 16);
    }

    public ConcurrentOpenHashSet(int expectedItems, int concurrencyLevel) {
        Preconditions.checkArgument((expectedItems > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((concurrencyLevel > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((expectedItems >= concurrencyLevel ? 1 : 0) != 0);
        int numSections = concurrencyLevel;
        int perSectionExpectedItems = expectedItems / numSections;
        int perSectionCapacity = (int)((float)perSectionExpectedItems / 0.66f);
        this.sections = new Section[numSections];
        for (int i = 0; i < numSections; ++i) {
            this.sections[i] = new Section(perSectionCapacity);
        }
    }

    public long size() {
        long size = 0L;
        for (Section<V> s : this.sections) {
            size += (long)((Section)s).size;
        }
        return size;
    }

    public long capacity() {
        long capacity = 0L;
        for (Section<V> s : this.sections) {
            capacity += (long)((Section)s).capacity;
        }
        return capacity;
    }

    public boolean isEmpty() {
        for (Section<V> s : this.sections) {
            if (((Section)s).size == 0) continue;
            return false;
        }
        return true;
    }

    public boolean contains(V value) {
        Preconditions.checkNotNull(value);
        long h = ConcurrentOpenHashSet.hash(value);
        return this.getSection(h).contains(value, (int)h);
    }

    public boolean add(V value) {
        Preconditions.checkNotNull(value);
        long h = ConcurrentOpenHashSet.hash(value);
        return this.getSection(h).add(value, (int)h);
    }

    public boolean remove(V value) {
        Preconditions.checkNotNull(value);
        long h = ConcurrentOpenHashSet.hash(value);
        return ((Section)this.getSection(h)).remove(value, (int)h);
    }

    private Section<V> getSection(long hash) {
        int sectionIdx = (int)(hash >>> 32) & this.sections.length - 1;
        return this.sections[sectionIdx];
    }

    public void clear() {
        for (Section<V> s : this.sections) {
            s.clear();
        }
    }

    public void forEach(Consumer<? super V> processor) {
        for (Section<? super V> section : this.sections) {
            section.forEach(processor);
        }
    }

    List<V> values() {
        ArrayList values = Lists.newArrayList();
        this.forEach(value -> values.add(value));
        return values;
    }

    static final <K> long hash(K key) {
        long hash = (long)key.hashCode() * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    static final int signSafeMod(long n, int max) {
        return (int)n & max - 1;
    }

    private static int alignToPowerOfTwo(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    private static final class Section<V>
    extends StampedLock {
        private volatile V[] values;
        private volatile int capacity;
        private volatile int size;
        private int usedBuckets;
        private int resizeThreshold;

        Section(int capacity) {
            this.capacity = ConcurrentOpenHashSet.alignToPowerOfTwo(capacity);
            this.values = new Object[this.capacity];
            this.size = 0;
            this.usedBuckets = 0;
            this.resizeThreshold = (int)((float)this.capacity * 0.66f);
        }

        boolean contains(V value, int keyHash) {
            int bucket = keyHash;
            long stamp = this.tryOptimisticRead();
            boolean acquiredLock = false;
            try {
                while (true) {
                    int capacity = this.capacity;
                    bucket = ConcurrentOpenHashSet.signSafeMod(bucket, capacity);
                    V storedValue = this.values[bucket];
                    if (!acquiredLock && this.validate(stamp)) {
                        if (value.equals(storedValue)) {
                            boolean bl = true;
                            return bl;
                        }
                        if (storedValue == EmptyValue) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        if (!acquiredLock) {
                            stamp = this.readLock();
                            acquiredLock = true;
                            storedValue = this.values[bucket];
                        }
                        if (capacity != this.capacity) {
                            bucket = keyHash;
                            continue;
                        }
                        if (value.equals(storedValue)) {
                            boolean bl = true;
                            return bl;
                        }
                        if (storedValue == EmptyValue) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    ++bucket;
                }
            }
            finally {
                if (acquiredLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(V value, int keyHash) {
            int bucket = keyHash;
            long stamp = this.writeLock();
            int capacity = this.capacity;
            int firstDeletedValue = -1;
            try {
                while (true) {
                    V storedValue;
                    if (value.equals(storedValue = this.values[bucket = ConcurrentOpenHashSet.signSafeMod(bucket, capacity)])) {
                        boolean bl = false;
                        return bl;
                    }
                    if (storedValue == EmptyValue) {
                        if (firstDeletedValue != -1) {
                            bucket = firstDeletedValue;
                        } else {
                            ++this.usedBuckets;
                        }
                        this.values[bucket] = value;
                        ++this.size;
                        boolean bl = true;
                        return bl;
                    }
                    if (storedValue == DeletedValue && firstDeletedValue == -1) {
                        firstDeletedValue = bucket;
                    }
                    ++bucket;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThreshold) {
                    try {
                        this.rehash();
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        private boolean remove(V value, int keyHash) {
            int bucket = keyHash;
            long stamp = this.writeLock();
            try {
                while (true) {
                    int capacity;
                    V storedValue;
                    if (value.equals(storedValue = this.values[bucket = ConcurrentOpenHashSet.signSafeMod(bucket, capacity = this.capacity)])) {
                        --this.size;
                        int nextInArray = ConcurrentOpenHashSet.signSafeMod(bucket + 1, capacity);
                        if (this.values[nextInArray] == EmptyValue) {
                            this.values[bucket] = EmptyValue;
                            --this.usedBuckets;
                        } else {
                            this.values[bucket] = DeletedValue;
                        }
                        boolean bl = true;
                        return bl;
                    }
                    if (storedValue == EmptyValue) {
                        boolean bl = false;
                        return bl;
                    }
                    ++bucket;
                }
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        void clear() {
            long stamp = this.writeLock();
            try {
                Arrays.fill(this.values, EmptyValue);
                this.size = 0;
                this.usedBuckets = 0;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(Consumer<? super V> processor) {
            long stamp = this.tryOptimisticRead();
            int capacity = this.capacity;
            V[] values = this.values;
            boolean acquiredReadLock = false;
            try {
                if (!this.validate(stamp)) {
                    stamp = this.readLock();
                    acquiredReadLock = true;
                    capacity = this.capacity;
                    values = this.values;
                }
                for (int bucket = 0; bucket < capacity; ++bucket) {
                    V storedValue = values[bucket];
                    if (!acquiredReadLock && !this.validate(stamp)) {
                        stamp = this.readLock();
                        acquiredReadLock = true;
                        storedValue = values[bucket];
                    }
                    if (storedValue == DeletedValue || storedValue == EmptyValue) continue;
                    processor.accept(storedValue);
                }
            }
            finally {
                if (acquiredReadLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        private void rehash() {
            int newCapacity = this.capacity * 2;
            Object[] newValues = new Object[newCapacity];
            for (int i = 0; i < this.values.length; ++i) {
                V storedValue = this.values[i];
                if (storedValue == EmptyValue || storedValue == DeletedValue) continue;
                Section.insertValueNoLock(newValues, storedValue);
            }
            this.values = newValues;
            this.usedBuckets = this.size;
            this.capacity = newCapacity;
            this.resizeThreshold = (int)((float)this.capacity * 0.66f);
        }

        private static <V> void insertValueNoLock(V[] values, V value) {
            int bucket = (int)ConcurrentOpenHashSet.hash(value);
            while (true) {
                V storedValue;
                if ((storedValue = values[bucket = ConcurrentOpenHashSet.signSafeMod(bucket, values.length)]) == EmptyValue) {
                    values[bucket] = value;
                    return;
                }
                ++bucket;
            }
        }
    }
}

