/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.File;
import java.time.LocalDateTime;
import java.util.function.Consumer;
import org.apache.zookeeper.util.ServiceUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKTestCase {
    protected static final File testBaseDir = new File(System.getProperty("build.test.dir", "build"));
    private static final Logger LOG = LoggerFactory.getLogger(ZKTestCase.class);
    private String testName;

    protected String getTestName() {
        return this.testName;
    }

    @BeforeAll
    public static void before() {
        if (!testBaseDir.exists()) {
            Assertions.assertTrue((boolean)testBaseDir.mkdirs(), (String)("Cannot properly create test base directory " + testBaseDir.getAbsolutePath()));
        } else if (!testBaseDir.isDirectory()) {
            Assertions.assertTrue((boolean)testBaseDir.delete(), (String)("Cannot properly delete file with duplicate name of test base directory " + testBaseDir.getAbsolutePath()));
            Assertions.assertTrue((boolean)testBaseDir.mkdirs(), (String)("Cannot properly create test base directory " + testBaseDir.getAbsolutePath()));
        }
    }

    @BeforeEach
    public void starting(TestInfo testInfo) {
        System.setProperty("zookeeper.admin.enableServer", "false");
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        LOG.info("STARTING {}", (Object)testInfo.getTestMethod());
    }

    @AfterEach
    public void finished(TestInfo testInfo) {
        LOG.info("FINISHED {}", (Object)testInfo.getTestMethod());
    }

    public void waitFor(String msg, WaitForCondition condition, int timeout) throws InterruptedException {
        LocalDateTime deadline = LocalDateTime.now().plusSeconds(timeout);
        while (LocalDateTime.now().isBefore(deadline)) {
            if (condition.evaluate()) {
                return;
            }
            Thread.sleep(100L);
        }
        Assertions.fail((String)msg);
    }

    static {
        ServiceUtils.setSystemExitProcedure((Consumer)ServiceUtils.LOG_ONLY);
    }

    public static interface WaitForCondition {
        public boolean evaluate();
    }
}

