/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.auth;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.auth.KerberosSecurityTestcase;
import org.apache.zookeeper.server.quorum.auth.KerberosTestUtils;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class QuorumKerberosAuthTest
extends KerberosSecurityTestcase {
    private static File keytabFile;

    @BeforeAll
    public static void setUp() throws Exception {
        keytabFile = new File(KerberosTestUtils.getKeytabFile());
        String learnerPrincipal = KerberosTestUtils.getLearnerPrincipal();
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        learnerPrincipal = learnerPrincipal.substring(0, learnerPrincipal.lastIndexOf("@"));
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        QuorumKerberosAuthTest.getKdc().createPrincipal(keytabFile, learnerPrincipal, serverPrincipal);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        for (QuorumPeerTestBase.MainThread mainThread : this.mt) {
            mainThread.shutdown();
            mainThread.deleteBaseDir();
        }
        super.tearDown();
    }

    @AfterAll
    public static void cleanup() {
        if (keytabFile != null) {
            FileUtils.deleteQuietly((File)keytabFile);
        }
        QuorumKerberosAuthTest.cleanupJaasConfig();
    }

    @Test
    @Timeout(value=120L)
    public void testValidCredentials() throws Exception {
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        authConfigs.put("quorum.auth.kerberos.servicePrincipal", serverPrincipal);
        String connectStr = this.startQuorum(3, authConfigs, 3);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            zk.create("/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
    }

    @Test
    @Timeout(value=120L)
    public void testValidCredentialsWithMultiAddresses() throws Exception {
        String serverPrincipal = KerberosTestUtils.getServerPrincipal();
        serverPrincipal = serverPrincipal.substring(0, serverPrincipal.lastIndexOf("@"));
        HashMap<String, String> authConfigs = new HashMap<String, String>();
        authConfigs.put("quorum.auth.enableSasl", "true");
        authConfigs.put("quorum.auth.serverRequireSasl", "true");
        authConfigs.put("quorum.auth.learnerRequireSasl", "true");
        authConfigs.put("quorum.auth.kerberos.servicePrincipal", serverPrincipal);
        String connectStr = this.startMultiAddressQuorum(3, authConfigs, 3);
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(connectStr, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        for (int i = 0; i < 10; ++i) {
            zk.create("/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
    }

    static {
        String keytabFilePath = FilenameUtils.normalize((String)KerberosTestUtils.getKeytabFile(), (boolean)true);
        String jaasEntries = "QuorumServer {\n       com.sun.security.auth.module.Krb5LoginModule required\n       useKeyTab=true\n       keyTab=\"" + keytabFilePath + "\"\n       storeKey=true\n       useTicketCache=false\n       debug=false\n       refreshKrb5Config=true\n       principal=\"" + KerberosTestUtils.getServerPrincipal() + "\";\n};\nQuorumLearner {\n       com.sun.security.auth.module.Krb5LoginModule required\n       useKeyTab=true\n       keyTab=\"" + keytabFilePath + "\"\n       storeKey=true\n       useTicketCache=false\n       debug=false\n       refreshKrb5Config=true\n       principal=\"" + KerberosTestUtils.getLearnerPrincipal() + "\";\n};\n";
        QuorumKerberosAuthTest.setupJaasConfig(jaasEntries);
    }
}

