/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.command.StatResetCommand;
import org.apache.zookeeper.server.quorum.BufferStats;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class StatResetCommandTest {
    private StatResetCommand statResetCommand;
    private StringWriter outputWriter;
    private ZooKeeperServer zks;
    private ServerStats serverStats;

    @BeforeEach
    public void setUp() {
        this.outputWriter = new StringWriter();
        ServerCnxn serverCnxnMock = (ServerCnxn)Mockito.mock(ServerCnxn.class);
        this.zks = (ZooKeeperServer)Mockito.mock(ZooKeeperServer.class);
        Mockito.when((Object)this.zks.isRunning()).thenReturn((Object)true);
        this.serverStats = (ServerStats)Mockito.mock(ServerStats.class);
        Mockito.when((Object)this.zks.serverStats()).thenReturn((Object)this.serverStats);
        this.statResetCommand = new StatResetCommand(new PrintWriter(this.outputWriter), serverCnxnMock);
        this.statResetCommand.setZkServer(this.zks);
    }

    @Test
    public void testStatResetWithZKNotRunning() {
        Mockito.when((Object)this.zks.isRunning()).thenReturn((Object)false);
        this.statResetCommand.commandRun();
        String output = this.outputWriter.toString();
        Assertions.assertEquals((Object)"This ZooKeeper instance is not currently serving requests\n", (Object)output);
    }

    @Test
    public void testStatResetWithFollower() {
        Mockito.when((Object)this.zks.isRunning()).thenReturn((Object)true);
        Mockito.when((Object)this.serverStats.getServerState()).thenReturn((Object)"follower");
        this.statResetCommand.commandRun();
        String output = this.outputWriter.toString();
        Assertions.assertEquals((Object)"Server stats reset.\n", (Object)output);
        ((ServerStats)Mockito.verify((Object)this.serverStats, (VerificationMode)Mockito.times((int)1))).reset();
    }

    @Test
    public void testStatResetWithLeader() {
        LeaderZooKeeperServer leaderZks = (LeaderZooKeeperServer)Mockito.mock(LeaderZooKeeperServer.class);
        Mockito.when((Object)leaderZks.isRunning()).thenReturn((Object)true);
        Mockito.when((Object)leaderZks.serverStats()).thenReturn((Object)this.serverStats);
        Leader leader = (Leader)Mockito.mock(Leader.class);
        Mockito.when((Object)leaderZks.getLeader()).thenReturn((Object)leader);
        this.statResetCommand.setZkServer((ZooKeeperServer)leaderZks);
        Mockito.when((Object)this.serverStats.getServerState()).thenReturn((Object)"leader");
        BufferStats bufferStats = (BufferStats)Mockito.mock(BufferStats.class);
        Mockito.when((Object)leader.getProposalStats()).thenReturn((Object)bufferStats);
        this.statResetCommand.commandRun();
        String output = this.outputWriter.toString();
        Assertions.assertEquals((Object)"Server stats reset.\n", (Object)output);
        ((ServerStats)Mockito.verify((Object)this.serverStats, (VerificationMode)Mockito.times((int)1))).reset();
        ((BufferStats)Mockito.verify((Object)bufferStats, (VerificationMode)Mockito.times((int)1))).reset();
    }
}

