/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.stats;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.StatImpl;
import com.twitter.common.stats.Stats;
import java.util.concurrent.atomic.AtomicLong;

public class Elapsed {
    private final Ticker ticker;
    private final AtomicLong lastEventNs = new AtomicLong();

    public Elapsed(String name) {
        this(name, Time.NANOSECONDS);
    }

    public Elapsed(String name, Time granularity) {
        this(name, granularity, Ticker.systemTicker());
    }

    public Elapsed(String name, final Time granularity, final Ticker ticker) {
        MorePreconditions.checkNotBlank((String)name);
        Preconditions.checkNotNull((Object)granularity);
        this.ticker = (Ticker)Preconditions.checkNotNull((Object)ticker);
        this.reset();
        Stats.export(new StatImpl<Long>(name){

            public Long read() {
                return (Long)Amount.of((long)(ticker.read() - Elapsed.this.lastEventNs.get()), (Unit)Time.NANOSECONDS).as((Unit)granularity);
            }
        });
    }

    public void reset() {
        this.lastEventNs.set(this.ticker.read());
    }
}

