/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Collection;
import javax.lang.model.element.PackageElement;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AbstractPackageIndexWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.RawHtml;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;

public class PackageIndexFrameWriter
extends AbstractPackageIndexWriter {
    public PackageIndexFrameWriter(ConfigurationImpl configuration, DocPath filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(ConfigurationImpl configuration) {
        DocPath filename = DocPaths.OVERVIEW_FRAME;
        try {
            PackageIndexFrameWriter packgen = new PackageIndexFrameWriter(configuration, filename);
            packgen.buildPackageIndexFile("doclet.Window_Overview", false);
            packgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    @Override
    protected void addPackagesList(Collection<PackageElement> packages, String text, String tableSummary, Content body) {
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.PACKAGE_HEADING, true, this.packagesLabel);
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN(HtmlStyle.indexContainer, heading) : HtmlTree.DIV(HtmlStyle.indexContainer, heading);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.setTitle(this.packagesLabel);
        for (PackageElement aPackage : packages) {
            if (aPackage == null || this.configuration.nodeprecated && this.utils.isDeprecated(aPackage)) continue;
            ul.addContent(this.getPackage(aPackage));
        }
        htmlTree.addContent(ul);
        body.addContent(htmlTree);
    }

    protected Content getPackage(PackageElement pe) {
        Content packageLinkContent;
        if (pe.isUnnamed()) {
            StringContent packageLabel = new StringContent("<unnamed package>");
            packageLinkContent = this.getHyperLink(DocPaths.PACKAGE_FRAME, (Content)packageLabel, "", "packageFrame");
        } else {
            Content packageLabel = this.getPackageLabel(pe.getQualifiedName());
            packageLinkContent = this.getHyperLink(this.pathString(pe, DocPaths.PACKAGE_FRAME), packageLabel, "", "packageFrame");
        }
        HtmlTree li = HtmlTree.LI(packageLinkContent);
        return li;
    }

    @Override
    protected void addNavigationBarHeader(Content body) {
        RawHtml headerContent = this.configuration.packagesheader.length() > 0 ? new RawHtml(this.replaceDocRootDir(this.configuration.packagesheader)) : new RawHtml(this.replaceDocRootDir(this.configuration.header));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.bar, headerContent);
        body.addContent(heading);
    }

    @Override
    protected void addOverviewHeader(Content body) {
    }

    @Override
    protected void addAllClassesLink(Content ul) {
        Content linkContent = this.getHyperLink(DocPaths.ALLCLASSES_FRAME, this.allclassesLabel, "", "packageFrame");
        HtmlTree li = HtmlTree.LI(linkContent);
        ul.addContent(li);
    }

    @Override
    protected void addNavigationBarFooter(Content body) {
        HtmlTree p = HtmlTree.P(this.getSpace());
        body.addContent(p);
    }
}

