/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.finagle.builder.ClientBuilder;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.thrift.ClientId$;
import com.twitter.util.Duration;
import com.twitter.util.FutureEventListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.callback.LogSegmentListener;
import org.apache.distributedlog.callback.NamespaceListener;
import org.apache.distributedlog.client.monitor.MonitorServiceClient;
import org.apache.distributedlog.client.serverset.DLZkServerSet;
import org.apache.distributedlog.service.DistributedLogClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorService
implements NamespaceListener {
    private static final Logger logger = LoggerFactory.getLogger(MonitorService.class);
    private Namespace dlNamespace = null;
    private MonitorServiceClient dlClient = null;
    private DLZkServerSet[] zkServerSets = null;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private final CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private final Map<String, StreamChecker> knownStreams = new HashMap<String, StreamChecker>();
    private int regionId = 0;
    private int interval = 100;
    private String streamRegex = null;
    private boolean watchNamespaceChanges = false;
    private boolean handshakeWithClientInfo = false;
    private int heartbeatEveryChecks = 0;
    private int instanceId = -1;
    private int totalInstances = -1;
    private boolean isThriftMux = false;
    private final Optional<String> uriArg;
    private final Optional<String> confFileArg;
    private final Optional<String> serverSetArg;
    private final Optional<Integer> intervalArg;
    private final Optional<Integer> regionIdArg;
    private final Optional<String> streamRegexArg;
    private final Optional<Integer> instanceIdArg;
    private final Optional<Integer> totalInstancesArg;
    private final Optional<Integer> heartbeatEveryChecksArg;
    private final Optional<Boolean> handshakeWithClientInfoArg;
    private final Optional<Boolean> watchNamespaceChangesArg;
    private final Optional<Boolean> isThriftMuxArg;
    private final StatsProvider statsProvider;
    private final StatsReceiver statsReceiver;
    private final StatsReceiver monitorReceiver;
    private final Stat successStat;
    private final Stat failureStat;
    private final Gauge<Number> numOfStreamsGauge;
    private final HashFunction hashFunction = Hashing.md5();

    MonitorService(Optional<String> uriArg, Optional<String> confFileArg, Optional<String> serverSetArg, Optional<Integer> intervalArg, Optional<Integer> regionIdArg, Optional<String> streamRegexArg, Optional<Integer> instanceIdArg, Optional<Integer> totalInstancesArg, Optional<Integer> heartbeatEveryChecksArg, Optional<Boolean> handshakeWithClientInfoArg, Optional<Boolean> watchNamespaceChangesArg, Optional<Boolean> isThriftMuxArg, StatsReceiver statsReceiver, StatsProvider statsProvider) {
        this.uriArg = uriArg;
        this.confFileArg = confFileArg;
        this.serverSetArg = serverSetArg;
        this.intervalArg = intervalArg;
        this.regionIdArg = regionIdArg;
        this.streamRegexArg = streamRegexArg;
        this.instanceIdArg = instanceIdArg;
        this.totalInstancesArg = totalInstancesArg;
        this.heartbeatEveryChecksArg = heartbeatEveryChecksArg;
        this.handshakeWithClientInfoArg = handshakeWithClientInfoArg;
        this.watchNamespaceChangesArg = watchNamespaceChangesArg;
        this.isThriftMuxArg = isThriftMuxArg;
        this.statsReceiver = statsReceiver;
        this.monitorReceiver = statsReceiver.scope("monitor");
        this.successStat = this.monitorReceiver.stat0("success");
        this.failureStat = this.monitorReceiver.stat0("failure");
        this.statsProvider = statsProvider;
        this.numOfStreamsGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                return MonitorService.this.knownStreams.size();
            }
        };
    }

    public void runServer() throws IllegalArgumentException, IOException {
        Preconditions.checkArgument((boolean)this.uriArg.isPresent(), (Object)"No distributedlog uri provided.");
        Preconditions.checkArgument((boolean)this.serverSetArg.isPresent(), (Object)"No proxy server set provided.");
        if (this.intervalArg.isPresent()) {
            this.interval = (Integer)this.intervalArg.get();
        }
        if (this.regionIdArg.isPresent()) {
            this.regionId = (Integer)this.regionIdArg.get();
        }
        if (this.streamRegexArg.isPresent()) {
            this.streamRegex = (String)this.streamRegexArg.get();
        }
        if (this.instanceIdArg.isPresent()) {
            this.instanceId = (Integer)this.instanceIdArg.get();
        }
        if (this.totalInstancesArg.isPresent()) {
            this.totalInstances = (Integer)this.totalInstancesArg.get();
        }
        if (this.heartbeatEveryChecksArg.isPresent()) {
            this.heartbeatEveryChecks = (Integer)this.heartbeatEveryChecksArg.get();
        }
        if (this.instanceId < 0 || this.totalInstances <= 0 || this.instanceId >= this.totalInstances) {
            throw new IllegalArgumentException("Invalid instance id or total instances number.");
        }
        this.handshakeWithClientInfo = this.handshakeWithClientInfoArg.isPresent();
        this.watchNamespaceChanges = this.watchNamespaceChangesArg.isPresent();
        this.isThriftMux = this.isThriftMuxArg.isPresent();
        URI uri = URI.create((String)this.uriArg.get());
        DistributedLogConfiguration dlConf = new DistributedLogConfiguration();
        if (this.confFileArg.isPresent()) {
            String configFile = (String)this.confFileArg.get();
            try {
                dlConf.loadConf(new File(configFile).toURI().toURL());
            }
            catch (ConfigurationException e) {
                throw new IOException("Failed to load distributedlog configuration from " + configFile + ".");
            }
            catch (MalformedURLException e) {
                throw new IOException("Failed to load distributedlog configuration from malformed " + configFile + ".");
            }
        }
        logger.info("Starting stats provider : {}.", this.statsProvider.getClass());
        this.statsProvider.start((Configuration)dlConf);
        String[] serverSetPaths = StringUtils.split((String)((String)this.serverSetArg.get()), (String)",");
        if (serverSetPaths.length == 0) {
            throw new IllegalArgumentException("Invalid serverset paths provided : " + (String)this.serverSetArg.get());
        }
        ServerSet[] serverSets = this.createServerSets(serverSetPaths);
        ServerSet local = serverSets[0];
        ServerSet[] remotes = new ServerSet[serverSets.length - 1];
        System.arraycopy(serverSets, 1, remotes, 0, remotes.length);
        ClientBuilder finagleClientBuilder = ClientBuilder.get().connectTimeout(Duration.fromSeconds((int)1)).tcpConnectTimeout(Duration.fromSeconds((int)1)).requestTimeout(Duration.fromSeconds((int)2)).keepAlive(true).failFast(false);
        if (!this.isThriftMux) {
            finagleClientBuilder = finagleClientBuilder.hostConnectionLimit(2).hostConnectionCoresize(2);
        }
        this.dlClient = DistributedLogClientBuilder.newBuilder().name("monitor").thriftmux(this.isThriftMux).clientId(ClientId$.MODULE$.apply("monitor")).redirectBackoffMaxMs(50).redirectBackoffStartMs(100).requestTimeoutMs(2000).maxRedirects(2).serverSets(local, remotes).streamNameRegex(this.streamRegex).handshakeWithClientInfo(this.handshakeWithClientInfo).clientBuilder(finagleClientBuilder).statsReceiver(this.monitorReceiver.scope("client")).buildMonitorClient();
        this.runMonitor(dlConf, uri);
    }

    ServerSet[] createServerSets(String[] serverSetPaths) {
        ServerSet[] serverSets = new ServerSet[serverSetPaths.length];
        this.zkServerSets = new DLZkServerSet[serverSetPaths.length];
        for (int i = 0; i < serverSetPaths.length; ++i) {
            String serverSetPath = serverSetPaths[i];
            this.zkServerSets[i] = this.parseServerSet(serverSetPath);
            serverSets[i] = this.zkServerSets[i].getServerSet();
        }
        return serverSets;
    }

    protected DLZkServerSet parseServerSet(String serverSetPath) {
        return DLZkServerSet.of((URI)URI.create(serverSetPath), (int)60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamsChanged(Iterator<String> streams) {
        HashSet<String> newSet = new HashSet<String>();
        while (streams.hasNext()) {
            String s = streams.next();
            if (null != this.streamRegex && !s.matches(this.streamRegex) || Math.abs(this.hashFunction.hashUnencodedChars((CharSequence)s).asInt()) % this.totalInstances != this.instanceId) continue;
            newSet.add(s);
        }
        ArrayList<StreamChecker> tasksToCancel = new ArrayList<StreamChecker>();
        Map<String, StreamChecker> map = this.knownStreams;
        synchronized (map) {
            HashSet<String> knownStreamSet = new HashSet<String>(this.knownStreams.keySet());
            ImmutableSet removedStreams = Sets.difference(knownStreamSet, newSet).immutableCopy();
            ImmutableSet addedStreams = Sets.difference(newSet, knownStreamSet).immutableCopy();
            for (String s : removedStreams) {
                StreamChecker task = this.knownStreams.remove(s);
                if (null == task) continue;
                logger.info("Removed stream {}", (Object)s);
                tasksToCancel.add(task);
            }
            for (String s : addedStreams) {
                if (this.knownStreams.containsKey(s)) continue;
                logger.info("Added stream {}", (Object)s);
                StreamChecker sc = new StreamChecker(s);
                this.knownStreams.put(s, sc);
                sc.run();
            }
        }
        for (StreamChecker sc : tasksToCancel) {
            sc.close();
        }
    }

    void runMonitor(DistributedLogConfiguration conf, URI dlUri) throws IOException {
        this.statsProvider.getStatsLogger("monitor").registerGauge("num_streams", this.numOfStreamsGauge);
        logger.info("Construct dl namespace @ {}", (Object)dlUri);
        this.dlNamespace = NamespaceBuilder.newBuilder().conf(conf).uri(dlUri).build();
        if (this.watchNamespaceChanges) {
            this.dlNamespace.registerNamespaceListener((NamespaceListener)this);
        } else {
            this.onStreamsChanged(this.dlNamespace.getLogs());
        }
    }

    public void close() {
        logger.info("Closing monitor service.");
        if (null != this.dlClient) {
            this.dlClient.close();
        }
        if (null != this.zkServerSets) {
            for (DLZkServerSet zkServerSet : this.zkServerSets) {
                zkServerSet.close();
            }
        }
        if (null != this.dlNamespace) {
            this.dlNamespace.close();
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            logger.error("Interrupted on waiting shutting down monitor executor service : ", (Throwable)e);
        }
        if (null != this.statsProvider) {
            this.unregisterGauge();
            this.statsProvider.stop();
        }
        this.keepAliveLatch.countDown();
        logger.info("Closed monitor service.");
    }

    public void join() throws InterruptedException {
        this.keepAliveLatch.await();
    }

    private void unregisterGauge() {
        this.statsProvider.getStatsLogger("monitor").unregisterGauge("num_streams", this.numOfStreamsGauge);
    }

    class StreamChecker
    implements Runnable,
    FutureEventListener<Void>,
    LogSegmentListener {
        private final String name;
        private volatile boolean closed = false;
        private volatile boolean checking = false;
        private final Stopwatch stopwatch = Stopwatch.createUnstarted();
        private DistributedLogManager dlm = null;
        private int numChecks = 0;

        StreamChecker(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (null == this.dlm) {
                try {
                    this.dlm = MonitorService.this.dlNamespace.openLog(this.name);
                    this.dlm.registerListener((LogSegmentListener)this);
                }
                catch (IOException e) {
                    if (null != this.dlm) {
                        try {
                            this.dlm.close();
                        }
                        catch (IOException e1) {
                            logger.error("Failed to close dlm for {} : ", (Object)this.name, (Object)e1);
                        }
                        this.dlm = null;
                    }
                    MonitorService.this.executorService.schedule(this, (long)MonitorService.this.interval, TimeUnit.MILLISECONDS);
                }
            } else {
                boolean sendHeartBeat;
                this.stopwatch.reset().start();
                if (MonitorService.this.heartbeatEveryChecks > 0) {
                    StreamChecker streamChecker = this;
                    synchronized (streamChecker) {
                        ++this.numChecks;
                        if (this.numChecks >= Integer.MAX_VALUE) {
                            this.numChecks = 0;
                        }
                        sendHeartBeat = this.numChecks % MonitorService.this.heartbeatEveryChecks == 0;
                    }
                } else {
                    sendHeartBeat = false;
                }
                if (sendHeartBeat) {
                    MonitorService.this.dlClient.heartbeat(this.name).addEventListener((FutureEventListener)this);
                } else {
                    MonitorService.this.dlClient.check(this.name).addEventListener((FutureEventListener)this);
                }
            }
        }

        public void onSegmentsUpdated(List<LogSegmentMetadata> segments) {
            if (segments.size() > 0 && segments.get(0).getRegionId() == MonitorService.this.regionId) {
                if (!this.checking) {
                    logger.info("Start checking stream {}.", (Object)this.name);
                    this.checking = true;
                    this.run();
                }
            } else if (this.checking) {
                logger.info("Stop checking stream {}.", (Object)this.name);
            }
        }

        public void onLogStreamDeleted() {
            logger.info("Stream {} is deleted", (Object)this.name);
        }

        public void onSuccess(Void value) {
            MonitorService.this.successStat.add((float)this.stopwatch.stop().elapsed(TimeUnit.MICROSECONDS));
            this.scheduleCheck();
        }

        public void onFailure(Throwable cause) {
            MonitorService.this.failureStat.add((float)this.stopwatch.stop().elapsed(TimeUnit.MICROSECONDS));
            this.scheduleCheck();
        }

        private void scheduleCheck() {
            if (this.closed) {
                return;
            }
            if (!this.checking) {
                return;
            }
            try {
                MonitorService.this.executorService.schedule(this, (long)MonitorService.this.interval, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException ree) {
                logger.error("Failed to schedule checking stream {} in {} ms : ", new Object[]{this.name, MonitorService.this.interval, ree});
            }
        }

        private void close() {
            this.closed = true;
            if (null != this.dlm) {
                try {
                    this.dlm.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close dlm for {} : ", (Object)this.name, (Object)e);
                }
            }
        }
    }
}

