/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.bookkeeper.bookie.BookieThread;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerDirsMonitor
extends BookieThread {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerDirsMonitor.class);
    private final int interval;
    private final ServerConfiguration conf;
    private final ConcurrentMap<File, Float> diskUsages;
    private final DiskChecker diskChecker;
    private final LedgerDirsManager ldm;

    public LedgerDirsMonitor(ServerConfiguration conf, DiskChecker diskChecker, LedgerDirsManager ldm) {
        super("LedgerDirsMonitorThread");
        this.interval = conf.getDiskCheckInterval();
        this.conf = conf;
        this.diskChecker = diskChecker;
        this.diskUsages = ldm.getDiskUsages();
        this.ldm = ldm;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            block24: {
                Iterator e4;
                block23: {
                    try {
                        List<File> writableDirs = this.ldm.getWritableLedgerDirs();
                        for (File dir : writableDirs) {
                            try {
                                this.diskUsages.put(dir, Float.valueOf(this.diskChecker.checkDir(dir)));
                            }
                            catch (DiskChecker.DiskErrorException e2) {
                                LOG.error("Ledger directory {} failed on disk checking : ", (Object)dir, (Object)e2);
                                for (LedgerDirsManager.LedgerDirsListener listener : this.ldm.getListeners()) {
                                    listener.diskFailed(dir);
                                }
                            }
                            catch (DiskChecker.DiskWarnThresholdException e3) {
                                LOG.warn("Ledger directory {} is almost full.", (Object)dir);
                                this.diskUsages.put(dir, Float.valueOf(e3.getUsage()));
                                for (LedgerDirsManager.LedgerDirsListener listener : this.ldm.getListeners()) {
                                    listener.diskAlmostFull(dir);
                                }
                            }
                            catch (DiskChecker.DiskOutOfSpaceException e4) {
                                LOG.error("Ledger directory {} is out-of-space.", (Object)dir);
                                this.diskUsages.put(dir, Float.valueOf(e4.getUsage()));
                                this.ldm.addToFilledDirs(dir);
                            }
                        }
                        this.ldm.getWritableLedgerDirs();
                    }
                    catch (LedgerDirsManager.NoWritableLedgerDirException e5) {
                        for (LedgerDirsManager.LedgerDirsListener listener : this.ldm.getListeners()) {
                            listener.allDisksFull();
                        }
                    }
                    ArrayList<File> fullfilledDirs = new ArrayList<File>(this.ldm.getFullFilledLedgerDirs());
                    boolean hasWritableLedgerDirs = this.ldm.hasWritableLedgerDirs();
                    float totalDiskUsage = 0.0f;
                    try {
                        block26: {
                            block25: {
                                float f;
                                if (hasWritableLedgerDirs) break block25;
                                totalDiskUsage = this.diskChecker.getTotalDiskUsage(this.ldm.getAllLedgerDirs());
                                if (!(f < this.conf.getDiskLowWaterMarkUsageThreshold())) break block26;
                            }
                            e4 = fullfilledDirs.iterator();
                            break block23;
                        }
                        LOG.debug("Current TotalDiskUsage: {} is greater than LWMThreshold: {}. So not adding any filledDir to WritableDirsList", (Object)Float.valueOf(totalDiskUsage), (Object)Float.valueOf(this.conf.getDiskLowWaterMarkUsageThreshold()));
                        break block24;
                    }
                    catch (IOException ioe) {
                        LOG.error("Got IOException while monitoring Dirs", (Throwable)ioe);
                        for (LedgerDirsManager.LedgerDirsListener listener : this.ldm.getListeners()) {
                            listener.fatalError();
                        }
                        break block24;
                    }
                }
                while (e4.hasNext()) {
                    File dir = (File)e4.next();
                    try {
                        this.diskUsages.put(dir, Float.valueOf(this.diskChecker.checkDir(dir)));
                        this.ldm.addToWritableDirs(dir, true);
                    }
                    catch (DiskChecker.DiskErrorException e6) {
                        for (LedgerDirsManager.LedgerDirsListener listener : this.ldm.getListeners()) {
                            listener.diskFailed(dir);
                        }
                    }
                    catch (DiskChecker.DiskWarnThresholdException e7) {
                        this.diskUsages.put(dir, Float.valueOf(e7.getUsage()));
                        this.ldm.addToWritableDirs(dir, false);
                    }
                    catch (DiskChecker.DiskOutOfSpaceException e8) {
                        this.diskUsages.put(dir, Float.valueOf(e8.getUsage()));
                    }
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                LOG.info("LedgerDirsMonitor thread is interrupted");
                LOG.info("LedgerDirsMonitorThread exited!");
                return;
            }
        }
    }

    public void init() throws DiskChecker.DiskErrorException, LedgerDirsManager.NoWritableLedgerDirException {
        this.checkDirs(this.ldm.getWritableLedgerDirs());
    }

    @Override
    public void start() {
        this.setDaemon(true);
        super.start();
    }

    public void shutdown() {
        LOG.info("Shutting down LedgerDirsMonitor");
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void checkDirs(List<File> writableDirs) throws DiskChecker.DiskErrorException, LedgerDirsManager.NoWritableLedgerDirException {
        for (File dir : writableDirs) {
            try {
                this.diskChecker.checkDir(dir);
            }
            catch (DiskChecker.DiskWarnThresholdException diskWarnThresholdException) {
            }
            catch (DiskChecker.DiskOutOfSpaceException e) {
                this.ldm.addToFilledDirs(dir);
            }
        }
        this.ldm.getWritableLedgerDirs();
    }
}

