/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.logsegment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.distributedlog.common.concurrent.FutureUtils;
import org.apache.distributedlog.common.functions.VoidFunctions;

public class BKUtils {
    public static CompletableFuture<Void> closeLedger(LedgerHandle lh) {
        final CompletableFuture<Void> closePromise = new CompletableFuture<Void>();
        lh.asyncClose(new AsyncCallback.CloseCallback(){

            public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                if (0 != rc) {
                    FutureUtils.completeExceptionally((CompletableFuture)closePromise, (Throwable)BKException.create((int)rc));
                } else {
                    FutureUtils.complete((CompletableFuture)closePromise, null);
                }
            }
        }, null);
        return closePromise;
    }

    public static CompletableFuture<Void> closeLedgers(LedgerHandle ... lhs) {
        ArrayList closeResults = Lists.newArrayListWithExpectedSize((int)lhs.length);
        for (LedgerHandle lh : lhs) {
            closeResults.add(BKUtils.closeLedger(lh));
        }
        return FutureUtils.collect((List)closeResults).thenApply(VoidFunctions.LIST_TO_VOID_FUNC);
    }
}

