/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.platform;

import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.openjdk.tools.javac.main.Arguments;
import org.openjdk.tools.javac.platform.PlatformDescription;
import org.openjdk.tools.javac.platform.PlatformProvider;

public class PlatformUtils {
    public static PlatformDescription lookupPlatformDescription(String platformString) {
        int separator = platformString.indexOf(":");
        String platformProviderName = separator != -1 ? platformString.substring(0, separator) : platformString;
        String platformOptions = separator != -1 ? platformString.substring(separator + 1) : "";
        ServiceLoader<PlatformProvider> providers = ServiceLoader.load(PlatformProvider.class, Arguments.class.getClassLoader());
        return StreamSupport.stream(providers.spliterator(), false).filter(provider -> StreamSupport.stream(provider.getSupportedPlatformNames().spliterator(), false).anyMatch(platformProviderName::equals)).findFirst().flatMap(provider -> {
            try {
                return Optional.of(provider.getPlatform(platformProviderName, platformOptions));
            }
            catch (PlatformProvider.PlatformNotSupported pns) {
                return Optional.empty();
            }
        }).orElse(null);
    }
}

