/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;
import org.openjdk.source.doctree.AttributeTree;
import org.openjdk.source.doctree.CommentTree;
import org.openjdk.source.doctree.DocRootTree;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.source.doctree.EndElementTree;
import org.openjdk.source.doctree.EntityTree;
import org.openjdk.source.doctree.ErroneousTree;
import org.openjdk.source.doctree.IndexTree;
import org.openjdk.source.doctree.InheritDocTree;
import org.openjdk.source.doctree.LinkTree;
import org.openjdk.source.doctree.LiteralTree;
import org.openjdk.source.doctree.SeeTree;
import org.openjdk.source.doctree.StartElementTree;
import org.openjdk.source.doctree.TextTree;
import org.openjdk.source.util.SimpleDocTreeVisitor;
import org.openjdk.tools.doclint.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ClassWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkFactoryImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.MethodWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SectionName;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SourceToHTMLConverter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.TagletWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.Comment;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.DocType;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlAttr;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlDocWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlDocument;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.RawHtml;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.AnnotationTypeWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.ClassWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.PackageSummaryWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.DocRootTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.TagletWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.CommentHelper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocFile;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocLink;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletConstants;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.ImplementedMethods;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class HtmlDocletWriter
extends HtmlDocWriter {
    public final DocPath pathToRoot;
    public final DocPath path;
    public final DocPath filename;
    public final ConfigurationImpl configuration;
    protected final Utils utils;
    protected boolean printedAnnotationHeading = false;
    protected boolean printedAnnotationFieldHeading = false;
    private boolean isAnnotationDocumented = false;
    private boolean isContainerDocumented = false;
    HtmlTree fixedNavDiv = new HtmlTree(HtmlTag.DIV);
    static final Pattern IMPROPER_HTML_CHARS = Pattern.compile(".*[&<>].*");
    private static final Pattern docrootPattern = Pattern.compile(Pattern.quote("{@docroot}"), 2);
    static final Set<String> blockTags = new HashSet<String>();

    public HtmlDocletWriter(ConfigurationImpl configuration, DocPath path) throws IOException {
        super(configuration, path);
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.path = path;
        this.pathToRoot = path.parent().invert();
        this.filename = path.basename();
    }

    public String replaceDocRootDir(String htmlstr) {
        int index = htmlstr.indexOf("{@");
        if (index < 0) {
            return htmlstr;
        }
        Matcher docrootMatcher = docrootPattern.matcher(htmlstr);
        if (!docrootMatcher.find()) {
            return htmlstr;
        }
        StringBuilder buf = new StringBuilder();
        int prevEnd = 0;
        do {
            int match = docrootMatcher.start();
            buf.append(htmlstr.substring(prevEnd, match));
            prevEnd = docrootMatcher.end();
            if (this.configuration.docrootparent.length() > 0 && htmlstr.startsWith("/..", prevEnd)) {
                buf.append(this.configuration.docrootparent);
                prevEnd += 3;
            } else {
                buf.append(this.pathToRoot.isEmpty() ? "." : this.pathToRoot.getPath());
            }
            if (prevEnd >= htmlstr.length() || htmlstr.charAt(prevEnd) == '/') continue;
            buf.append('/');
        } while (docrootMatcher.find());
        buf.append(htmlstr.substring(prevEnd));
        return buf.toString();
    }

    public Content getAllClassesLinkScript(String id) {
        HtmlTree script = HtmlTree.SCRIPT();
        String scriptCode = "<!--" + DocletConstants.NL + "  allClassesLink = document.getElementById(\"" + id + "\");" + DocletConstants.NL + "  if(window==top) {" + DocletConstants.NL + "    allClassesLink.style.display = \"block\";" + DocletConstants.NL + "  }" + DocletConstants.NL + "  else {" + DocletConstants.NL + "    allClassesLink.style.display = \"none\";" + DocletConstants.NL + "  }" + DocletConstants.NL + "  //-->" + DocletConstants.NL;
        RawHtml scriptContent = new RawHtml(scriptCode);
        script.addContent(scriptContent);
        HtmlTree div = HtmlTree.DIV(script);
        HtmlTree div_noscript = HtmlTree.DIV(this.getResource("doclet.No_Script_Message"));
        HtmlTree noScript = HtmlTree.NOSCRIPT(div_noscript);
        ((Content)div).addContent(noScript);
        return div;
    }

    private void addMethodInfo(ExecutableElement method, Content dl) {
        TypeElement enclosing = this.utils.getEnclosingTypeElement(method);
        List<? extends TypeMirror> intfacs = enclosing.getInterfaces();
        ExecutableElement overriddenMethod = this.utils.overriddenMethod(method);
        if (!intfacs.isEmpty() && !new ImplementedMethods(method, this.configuration).build().isEmpty() || overriddenMethod != null) {
            MethodWriterImpl.addImplementsInfo(this, method, dl);
            if (overriddenMethod != null) {
                MethodWriterImpl.addOverridden(this, this.utils.overriddenType(method), overriddenMethod, dl);
            }
        }
    }

    protected void addTagsInfo(Element e, Content htmltree) {
        if (this.configuration.nocomment) {
            return;
        }
        HtmlTree dl = new HtmlTree(HtmlTag.DL);
        if (this.utils.isExecutableElement(e) && !this.utils.isConstructor(e)) {
            this.addMethodInfo((ExecutableElement)e, dl);
        }
        ContentBuilder output = new ContentBuilder();
        TagletWriter.genTagOutput(this.configuration.tagletManager, e, this.configuration.tagletManager.getCustomTaglets(e), this.getTagletWriterInstance(false), output);
        ((Content)dl).addContent(output);
        htmltree.addContent(dl);
    }

    protected boolean hasSerializationOverviewTags(VariableElement field) {
        ContentBuilder output = new ContentBuilder();
        TagletWriter.genTagOutput(this.configuration.tagletManager, field, this.configuration.tagletManager.getCustomTaglets(field), this.getTagletWriterInstance(false), output);
        return !((Content)output).isEmpty();
    }

    public TagletWriter getTagletWriterInstance(boolean isFirstSentence) {
        return new TagletWriterImpl(this, isFirstSentence);
    }

    public Content getTargetPackageLink(PackageElement pkg, String target, Content label) {
        return this.getHyperLink(this.pathString(pkg, DocPaths.PACKAGE_SUMMARY), label, "", target);
    }

    public void addClassesSummary(SortedSet<TypeElement> classes, String label, String tableSummary, List<String> tableHeader, Content summaryContentTree) {
        if (!classes.isEmpty()) {
            Content caption = this.getTableCaption(new RawHtml(label));
            HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.typeSummary, caption) : HtmlTree.TABLE(HtmlStyle.typeSummary, tableSummary, caption);
            ((Content)table).addContent(this.getSummaryTableHeader(tableHeader, "col"));
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            boolean altColor = true;
            for (TypeElement te : classes) {
                if (!this.utils.isCoreClass(te) || !this.configuration.isGeneratedDoc(te)) continue;
                Content classContent = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.PACKAGE, te));
                HtmlTree tdClass = HtmlTree.TD(HtmlStyle.colFirst, classContent);
                HtmlTree tr = HtmlTree.TR(tdClass);
                tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
                altColor = !altColor;
                HtmlTree tdClassDescription = new HtmlTree(HtmlTag.TD);
                tdClassDescription.addStyle(HtmlStyle.colLast);
                if (this.utils.isDeprecated(te)) {
                    tdClassDescription.addContent(this.deprecatedLabel);
                    List<? extends DocTree> tags = this.utils.getDeprecatedTrees(te);
                    if (!tags.isEmpty()) {
                        this.addSummaryDeprecatedComment(te, tags.get(0), tdClassDescription);
                    }
                } else {
                    this.addSummaryComment(te, tdClassDescription);
                }
                tr.addContent(tdClassDescription);
                ((Content)tbody).addContent(tr);
            }
            ((Content)table).addContent(tbody);
            summaryContentTree.addContent(table);
        }
    }

    public void printHtmlDocument(List<String> metakeywords, boolean includeScript, Content body) throws IOException {
        DocType htmlDocType = this.configuration.isOutputHtml5() ? DocType.HTML5 : DocType.TRANSITIONAL;
        Comment htmlComment = new Comment(this.configuration.getText("doclet.New_Page"));
        HtmlTree head = new HtmlTree(HtmlTag.HEAD);
        ((Content)head).addContent(this.getGeneratedBy(!this.configuration.notimestamp));
        ((Content)head).addContent(this.getTitle());
        HtmlTree meta = HtmlTree.META("Content-Type", "text/html", this.configuration.charset.length() > 0 ? this.configuration.charset : "utf-8");
        ((Content)head).addContent(meta);
        if (!this.configuration.notimestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            meta = HtmlTree.META(this.configuration.isOutputHtml5() ? "dc.created" : "date", dateFormat.format(new Date()));
            ((Content)head).addContent(meta);
        }
        if (metakeywords != null) {
            for (String metakeyword : metakeywords) {
                meta = HtmlTree.META("keywords", metakeyword);
                ((Content)head).addContent(meta);
            }
        }
        this.addStyleSheetProperties(head);
        this.addScriptProperties(head);
        HtmlTree htmlTree = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), head, body);
        HtmlDocument htmlDocument = new HtmlDocument(htmlDocType, htmlComment, htmlTree);
        this.write(htmlDocument);
    }

    public String getWindowTitle(String title) {
        if (this.configuration.windowtitle.length() > 0) {
            title = title + " (" + this.configuration.windowtitle + ")";
        }
        return title;
    }

    public Content getUserHeaderFooter(boolean header) {
        String content = header ? this.replaceDocRootDir(this.configuration.header) : (this.configuration.footer.length() != 0 ? this.replaceDocRootDir(this.configuration.footer) : this.replaceDocRootDir(this.configuration.header));
        RawHtml rawContent = new RawHtml(content);
        return rawContent;
    }

    public void addTop(Content htmlTree) {
        RawHtml top = new RawHtml(this.replaceDocRootDir(this.configuration.top));
        this.fixedNavDiv.addContent(top);
    }

    public void addBottom(Content htmlTree) {
        RawHtml bottom = new RawHtml(this.replaceDocRootDir(this.configuration.bottom));
        HtmlTree small = HtmlTree.SMALL(bottom);
        HtmlTree p = HtmlTree.P(HtmlStyle.legalCopy, small);
        htmlTree.addContent(p);
    }

    protected void addNavLinks(boolean header, Content htmlTree) {
        if (!this.configuration.nonavbar) {
            HtmlTree skipLinkContent;
            Content a;
            Content tree = this.configuration.allowTag(HtmlTag.NAV) ? HtmlTree.NAV() : htmlTree;
            String allClassesId = "allclasses_";
            HtmlTree navDiv = new HtmlTree(HtmlTag.DIV);
            this.fixedNavDiv.addStyle(HtmlStyle.fixedNav);
            Content skipNavLinks = this.configuration.getResource("doclet.Skip_navigation_links");
            if (header) {
                this.fixedNavDiv.addContent(HtmlConstants.START_OF_TOP_NAVBAR);
                navDiv.addStyle(HtmlStyle.topNav);
                allClassesId = allClassesId + "navbar_top";
                a = this.getMarkerAnchor(SectionName.NAVBAR_TOP);
                navDiv.addContent(a);
                skipLinkContent = HtmlTree.DIV(HtmlStyle.skipNav, this.getHyperLink(this.getDocLink(SectionName.SKIP_NAVBAR_TOP), skipNavLinks, skipNavLinks.toString(), ""));
                navDiv.addContent(skipLinkContent);
            } else {
                tree.addContent(HtmlConstants.START_OF_BOTTOM_NAVBAR);
                navDiv.addStyle(HtmlStyle.bottomNav);
                allClassesId = allClassesId + "navbar_bottom";
                a = this.getMarkerAnchor(SectionName.NAVBAR_BOTTOM);
                navDiv.addContent(a);
                skipLinkContent = HtmlTree.DIV(HtmlStyle.skipNav, this.getHyperLink(this.getDocLink(SectionName.SKIP_NAVBAR_BOTTOM), skipNavLinks, skipNavLinks.toString(), ""));
                navDiv.addContent(skipLinkContent);
            }
            if (header) {
                navDiv.addContent(this.getMarkerAnchor(SectionName.NAVBAR_TOP_FIRSTROW));
            } else {
                navDiv.addContent(this.getMarkerAnchor(SectionName.NAVBAR_BOTTOM_FIRSTROW));
            }
            HtmlTree navList = new HtmlTree(HtmlTag.UL);
            navList.addStyle(HtmlStyle.navList);
            navList.addAttr(HtmlAttr.TITLE, this.configuration.getText("doclet.Navigation"));
            if (this.configuration.createoverview) {
                navList.addContent(this.getNavLinkContents());
            }
            if (this.configuration.packages.size() == 1) {
                navList.addContent(this.getNavLinkPackage((PackageElement)this.configuration.packages.first()));
            } else if (!this.configuration.packages.isEmpty()) {
                navList.addContent(this.getNavLinkPackage());
            }
            navList.addContent(this.getNavLinkClass());
            if (this.configuration.classuse) {
                navList.addContent(this.getNavLinkClassUse());
            }
            if (this.configuration.createtree) {
                navList.addContent(this.getNavLinkTree());
            }
            if (!this.configuration.nodeprecated && !this.configuration.nodeprecatedlist) {
                navList.addContent(this.getNavLinkDeprecated());
            }
            if (this.configuration.createindex) {
                navList.addContent(this.getNavLinkIndex());
            }
            if (!this.configuration.nohelp) {
                navList.addContent(this.getNavLinkHelp());
            }
            navDiv.addContent(navList);
            HtmlTree aboutDiv = HtmlTree.DIV(HtmlStyle.aboutLanguage, this.getUserHeaderFooter(header));
            navDiv.addContent(aboutDiv);
            if (header) {
                this.fixedNavDiv.addContent(navDiv);
            } else {
                tree.addContent(navDiv);
            }
            HtmlTree ulNav = HtmlTree.UL(HtmlStyle.navList, this.getNavLinkPrevious());
            ((Content)ulNav).addContent(this.getNavLinkNext());
            HtmlTree subDiv = HtmlTree.DIV(HtmlStyle.subNav, ulNav);
            HtmlTree ulFrames = HtmlTree.UL(HtmlStyle.navList, this.getNavShowLists());
            ((Content)ulFrames).addContent(this.getNavHideLists(this.filename));
            ((Content)subDiv).addContent(ulFrames);
            HtmlTree ulAllClasses = HtmlTree.UL(HtmlStyle.navList, this.getNavLinkClassIndex());
            ulAllClasses.addAttr(HtmlAttr.ID, allClassesId);
            ((Content)subDiv).addContent(ulAllClasses);
            if (header && this.configuration.createindex) {
                HtmlTree inputText = HtmlTree.INPUT("text", "search");
                HtmlTree inputReset = HtmlTree.INPUT("reset", "reset");
                Content searchTxt = this.configuration.getResource("doclet.search");
                searchTxt.addContent(this.getSpace());
                HtmlTree liInput = HtmlTree.LI(HtmlTree.SPAN(searchTxt));
                liInput.addContent(inputText);
                liInput.addContent(inputReset);
                HtmlTree ulSearch = HtmlTree.UL(HtmlStyle.navListSearch, liInput);
                ((Content)subDiv).addContent(ulSearch);
            }
            ((Content)subDiv).addContent(this.getAllClassesLinkScript(allClassesId));
            this.addSummaryDetailLinks(subDiv);
            if (header) {
                ((Content)subDiv).addContent(this.getMarkerAnchor(SectionName.SKIP_NAVBAR_TOP));
                this.fixedNavDiv.addContent(subDiv);
                this.fixedNavDiv.addContent(HtmlConstants.END_OF_TOP_NAVBAR);
                tree.addContent(this.fixedNavDiv);
            } else {
                ((Content)subDiv).addContent(this.getMarkerAnchor(SectionName.SKIP_NAVBAR_BOTTOM));
                tree.addContent(subDiv);
                tree.addContent(HtmlConstants.END_OF_BOTTOM_NAVBAR);
            }
            if (this.configuration.allowTag(HtmlTag.NAV)) {
                htmlTree.addContent(tree);
            }
        }
    }

    protected Content getNavLinkNext() {
        return this.getNavLinkNext(null);
    }

    protected Content getNavLinkPrevious() {
        return this.getNavLinkPrevious(null);
    }

    protected void addSummaryDetailLinks(Content navDiv) {
    }

    protected Content getNavLinkContents() {
        Content linkContent = this.getHyperLink(this.pathToRoot.resolve(DocPaths.OVERVIEW_SUMMARY), this.overviewLabel, "", "");
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected Content getNavLinkPackage(PackageElement pkg) {
        Content linkContent = this.getPackageLink(pkg, this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected Content getNavLinkPackage() {
        HtmlTree li = HtmlTree.LI(this.packageLabel);
        return li;
    }

    protected Content getNavLinkClassUse() {
        HtmlTree li = HtmlTree.LI(this.useLabel);
        return li;
    }

    public Content getNavLinkPrevious(DocPath prev) {
        HtmlTree li = prev != null ? HtmlTree.LI(this.getHyperLink(prev, this.prevLabel, "", "")) : HtmlTree.LI(this.prevLabel);
        return li;
    }

    public Content getNavLinkNext(DocPath next) {
        HtmlTree li = next != null ? HtmlTree.LI(this.getHyperLink(next, this.nextLabel, "", "")) : HtmlTree.LI(this.nextLabel);
        return li;
    }

    protected Content getNavShowLists(DocPath link) {
        DocLink dl = new DocLink(link, this.path.getPath(), null);
        Content framesContent = this.getHyperLink(dl, this.framesLabel, "", "_top");
        HtmlTree li = HtmlTree.LI(framesContent);
        return li;
    }

    protected Content getNavShowLists() {
        return this.getNavShowLists(this.pathToRoot.resolve(DocPaths.INDEX));
    }

    protected Content getNavHideLists(DocPath link) {
        Content noFramesContent = this.getHyperLink(link, this.noframesLabel, "", "_top");
        HtmlTree li = HtmlTree.LI(noFramesContent);
        return li;
    }

    protected Content getNavLinkTree() {
        ArrayList<PackageElement> packages = new ArrayList<PackageElement>(this.utils.getSpecifiedPackages());
        DocPath docPath = packages.size() == 1 && this.utils.getSpecifiedClasses().isEmpty() ? this.pathString((PackageElement)packages.get(0), DocPaths.PACKAGE_TREE) : this.pathToRoot.resolve(DocPaths.OVERVIEW_TREE);
        return HtmlTree.LI(this.getHyperLink(docPath, this.treeLabel, "", ""));
    }

    protected Content getNavLinkMainTree(String label) {
        Content mainTreeContent = this.getHyperLink(this.pathToRoot.resolve(DocPaths.OVERVIEW_TREE), (Content)new StringContent(label));
        HtmlTree li = HtmlTree.LI(mainTreeContent);
        return li;
    }

    protected Content getNavLinkClass() {
        HtmlTree li = HtmlTree.LI(this.classLabel);
        return li;
    }

    protected Content getNavLinkDeprecated() {
        Content linkContent = this.getHyperLink(this.pathToRoot.resolve(DocPaths.DEPRECATED_LIST), this.deprecatedLabel, "", "");
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected Content getNavLinkClassIndex() {
        Content allClassesContent = this.getHyperLink(this.pathToRoot.resolve(DocPaths.ALLCLASSES_NOFRAME), this.allclassesLabel, "", "");
        HtmlTree li = HtmlTree.LI(allClassesContent);
        return li;
    }

    protected Content getNavLinkIndex() {
        Content linkContent = this.getHyperLink(this.pathToRoot.resolve(this.configuration.splitindex ? DocPaths.INDEX_FILES.resolve(DocPaths.indexN(1)) : DocPaths.INDEX_ALL), this.indexLabel, "", "");
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    protected Content getNavLinkHelp() {
        DocPath helpfilenm;
        String helpfile = this.configuration.helpfile;
        if (helpfile.isEmpty()) {
            helpfilenm = DocPaths.HELP_DOC;
        } else {
            DocFile file = DocFile.createFileForInput(this.configuration, helpfile);
            helpfilenm = DocPath.create(file.getName());
        }
        Content linkContent = this.getHyperLink(this.pathToRoot.resolve(helpfilenm), this.helpLabel, "", "");
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    public Content getSummaryTableHeader(List<String> header, String scope) {
        HtmlTree tr = new HtmlTree(HtmlTag.TR);
        int size = header.size();
        if (size == 1) {
            StringContent tableHeader = new StringContent(header.get(0));
            ((Content)tr).addContent(HtmlTree.TH(HtmlStyle.colOne, scope, tableHeader));
            return tr;
        }
        for (int i = 0; i < size; ++i) {
            StringContent tableHeader = new StringContent(header.get(i));
            if (i == 0) {
                ((Content)tr).addContent(HtmlTree.TH(HtmlStyle.colFirst, scope, tableHeader));
                continue;
            }
            if (i == size - 1) {
                ((Content)tr).addContent(HtmlTree.TH(HtmlStyle.colLast, scope, tableHeader));
                continue;
            }
            ((Content)tr).addContent(HtmlTree.TH(scope, tableHeader));
        }
        return tr;
    }

    public Content getTableCaption(Content title) {
        HtmlTree captionSpan = HtmlTree.SPAN(title);
        Content space = this.getSpace();
        HtmlTree tabSpan = HtmlTree.SPAN(HtmlStyle.tabEnd, space);
        HtmlTree caption = HtmlTree.CAPTION(captionSpan);
        ((Content)caption).addContent(tabSpan);
        return caption;
    }

    public Content getMarkerAnchor(String anchorName) {
        return this.getMarkerAnchor(this.getName(anchorName), null);
    }

    public Content getMarkerAnchor(SectionName sectionName) {
        return this.getMarkerAnchor(sectionName.getName(), null);
    }

    public Content getMarkerAnchor(SectionName sectionName, String anchorName) {
        return this.getMarkerAnchor(sectionName.getName() + this.getName(anchorName), null);
    }

    public Content getMarkerAnchor(String anchorName, Content anchorContent) {
        if (anchorContent == null) {
            anchorContent = new Comment(" ");
        }
        HtmlTree markerAnchor = HtmlTree.A(this.configuration.htmlVersion, anchorName, anchorContent);
        return markerAnchor;
    }

    public Content getPackageName(PackageElement packageElement) {
        return packageElement == null || packageElement.isUnnamed() ? this.defaultPackageLabel : this.getPackageLabel(packageElement.getQualifiedName());
    }

    public Content getPackageLabel(CharSequence packageName) {
        return new StringContent(packageName);
    }

    protected void addPackageDeprecatedAPI(SortedSet<Element> deprPkgs, String headingKey, String tableSummary, List<String> tableHeader, Content contentTree) {
        if (deprPkgs.size() > 0) {
            Content caption = this.getTableCaption(this.configuration.getResource(headingKey));
            HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.deprecatedSummary, caption) : HtmlTree.TABLE(HtmlStyle.deprecatedSummary, tableSummary, caption);
            ((Content)table).addContent(this.getSummaryTableHeader(tableHeader, "col"));
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            boolean altColor = true;
            for (Element e : deprPkgs) {
                PackageElement pkg = (PackageElement)e;
                HtmlTree td = HtmlTree.TD(HtmlStyle.colOne, this.getPackageLink(pkg, this.getPackageName(pkg)));
                List<? extends DocTree> tags = this.utils.getDeprecatedTrees(pkg);
                if (!tags.isEmpty()) {
                    this.addInlineDeprecatedComment(pkg, tags.get(0), td);
                }
                HtmlTree tr = HtmlTree.TR(td);
                tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
                altColor = !altColor;
                ((Content)tbody).addContent(tr);
            }
            ((Content)table).addContent(tbody);
            HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
            HtmlTree ul = HtmlTree.UL(HtmlStyle.blockList, li);
            contentTree.addContent(ul);
        }
    }

    protected DocPath pathString(TypeElement te, DocPath name) {
        return this.pathString(this.utils.containingPackage(te), name);
    }

    protected DocPath pathString(PackageElement packageElement, DocPath name) {
        return this.pathToRoot.resolve(DocPath.forPackage(packageElement).resolve(name));
    }

    public String getPackageAnchorName(PackageElement packageElement) {
        return packageElement == null || packageElement.isUnnamed() ? SectionName.UNNAMED_PACKAGE_ANCHOR.getName() : this.utils.getPackageName(packageElement);
    }

    public Content getPackageLink(PackageElement packageElement, CharSequence label) {
        return this.getPackageLink(packageElement, new StringContent(label));
    }

    public Content getPackageLink(PackageElement packageElement) {
        StringContent content = packageElement.isUnnamed() ? new StringContent() : new StringContent(this.utils.getPackageName(packageElement));
        return this.getPackageLink(packageElement, content);
    }

    public Content getPackageLink(PackageElement packageElement, Content label) {
        boolean included;
        boolean bl = included = packageElement != null && this.utils.isIncluded(packageElement);
        if (!included) {
            for (PackageElement p : this.configuration.packages) {
                if (!p.equals(packageElement)) continue;
                included = true;
                break;
            }
        }
        if (included || packageElement == null) {
            return this.getHyperLink(this.pathString(packageElement, DocPaths.PACKAGE_SUMMARY), label);
        }
        DocLink crossPkgLink = this.getCrossPackageLink(this.utils.getPackageName(packageElement));
        if (crossPkgLink != null) {
            return this.getHyperLink(crossPkgLink, label);
        }
        return label;
    }

    public Content interfaceName(TypeElement typeElement, boolean qual) {
        StringContent name = new StringContent(qual ? typeElement.getQualifiedName() : this.utils.getSimpleName(typeElement));
        return this.utils.isInterface(typeElement) ? HtmlTree.SPAN(HtmlStyle.interfaceName, name) : name;
    }

    public void addSrcLink(Element typeElement, Content label, Content htmltree) {
        if (typeElement == null) {
            return;
        }
        TypeElement te = this.utils.getEnclosingTypeElement(typeElement);
        if (te == null) {
            te = (TypeElement)typeElement;
        }
        DocPath href = this.pathToRoot.resolve(DocPaths.SOURCE_OUTPUT).resolve(DocPath.forClass(this.utils, te));
        Content linkContent = this.getHyperLink(href.fragment(SourceToHTMLConverter.getAnchorName(this.utils, typeElement)), label, "", "");
        htmltree.addContent(linkContent);
    }

    public Content getLink(LinkInfoImpl linkInfo) {
        LinkFactoryImpl factory = new LinkFactoryImpl(this);
        return factory.getLink(linkInfo);
    }

    public Content getTypeParameterLinks(LinkInfoImpl linkInfo) {
        LinkFactoryImpl factory = new LinkFactoryImpl(this);
        return factory.getTypeParameterLinks(linkInfo, false);
    }

    public Content getCrossClassLink(String qualifiedClassName, String refMemName, Content label, boolean strong, String style, boolean code) {
        int periodIndex;
        String packageName;
        String className = "";
        String string = packageName = qualifiedClassName == null ? "" : qualifiedClassName;
        while ((periodIndex = packageName.lastIndexOf(46)) != -1) {
            className = packageName.substring(periodIndex + 1, packageName.length()) + (className.length() > 0 ? "." + className : "");
            Content defaultLabel = new StringContent(className);
            if (code) {
                defaultLabel = HtmlTree.CODE(defaultLabel);
            }
            if (this.getCrossPackageLink(packageName = packageName.substring(0, periodIndex)) == null) continue;
            DocLink link = this.configuration.extern.getExternalLink(packageName, this.pathToRoot, className + ".html", refMemName);
            return this.getHyperLink(link, label == null || label.isEmpty() ? defaultLabel : label, strong, style, this.configuration.getText("doclet.Href_Class_Or_Interface_Title", packageName), "");
        }
        return null;
    }

    public boolean isClassLinkable(TypeElement typeElement) {
        if (this.utils.isIncluded(typeElement)) {
            return this.configuration.isGeneratedDoc(typeElement);
        }
        return this.configuration.extern.isExternal(typeElement);
    }

    public DocLink getCrossPackageLink(String pkgName) {
        return this.configuration.extern.getExternalLink(pkgName, this.pathToRoot, DocPaths.PACKAGE_SUMMARY.getPath());
    }

    public Content getQualifiedClassLink(LinkInfoImpl.Kind context, Element element) {
        LinkInfoImpl linkInfoImpl = new LinkInfoImpl(this.configuration, context, (TypeElement)element);
        return this.getLink(linkInfoImpl.label(this.utils.getFullyQualifiedName(element)));
    }

    public void addPreQualifiedClassLink(LinkInfoImpl.Kind context, TypeElement typeElement, Content contentTree) {
        this.addPreQualifiedClassLink(context, typeElement, false, contentTree);
    }

    public Content getPreQualifiedClassLink(LinkInfoImpl.Kind context, TypeElement typeElement, boolean isStrong) {
        ContentBuilder classlink = new ContentBuilder();
        PackageElement pkg = this.utils.containingPackage(typeElement);
        if (pkg != null && !this.configuration.shouldExcludeQualifier(pkg.getSimpleName().toString())) {
            classlink.addContent(this.getEnclosingPackageName(typeElement));
        }
        classlink.addContent(this.getLink(new LinkInfoImpl(this.configuration, context, typeElement).label(this.utils.getSimpleName(typeElement)).strong(isStrong)));
        return classlink;
    }

    public void addPreQualifiedClassLink(LinkInfoImpl.Kind context, TypeElement typeElement, boolean isStrong, Content contentTree) {
        PackageElement pkg = this.utils.containingPackage(typeElement);
        if (pkg != null && !this.configuration.shouldExcludeQualifier(pkg.getSimpleName().toString())) {
            contentTree.addContent(this.getEnclosingPackageName(typeElement));
        }
        LinkInfoImpl linkinfo = new LinkInfoImpl(this.configuration, context, typeElement).label(this.utils.getSimpleName(typeElement)).strong(isStrong);
        Content link = this.getLink(linkinfo);
        contentTree.addContent(link);
    }

    public void addPreQualifiedStrongClassLink(LinkInfoImpl.Kind context, TypeElement typeElement, Content contentTree) {
        this.addPreQualifiedClassLink(context, typeElement, true, contentTree);
    }

    public Content getDocLink(LinkInfoImpl.Kind context, Element element, CharSequence label) {
        return this.getDocLink(context, this.utils.getEnclosingTypeElement(element), element, new StringContent(label));
    }

    public Content getDocLink(LinkInfoImpl.Kind context, Element element, CharSequence label, boolean strong) {
        return this.getDocLink(context, this.utils.getEnclosingTypeElement(element), element, label, strong);
    }

    public Content getDocLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element element, CharSequence label, boolean strong) {
        return this.getDocLink(context, typeElement, element, label, strong, false);
    }

    public Content getDocLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element element, Content label, boolean strong) {
        return this.getDocLink(context, typeElement, element, label, strong, false);
    }

    public Content getDocLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element element, CharSequence label, boolean strong, boolean isProperty) {
        return this.getDocLink(context, typeElement, element, new StringContent(this.check(label)), strong, isProperty);
    }

    CharSequence check(CharSequence s) {
        Matcher m = IMPROPER_HTML_CHARS.matcher(s);
        if (m.matches()) {
            throw new IllegalArgumentException(s.toString());
        }
        return s;
    }

    public Content getDocLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element element, Content label, boolean strong, boolean isProperty) {
        if (!this.utils.isIncluded(element) && !this.utils.isLinkable(typeElement)) {
            return label;
        }
        if (this.utils.isExecutableElement(element)) {
            ExecutableElement ee = (ExecutableElement)element;
            return this.getLink(new LinkInfoImpl(this.configuration, context, typeElement).label(label).where(this.getName(this.getAnchor(ee, isProperty))).strong(strong));
        }
        if (this.utils.isVariableElement(element) || this.utils.isTypeElement(element)) {
            return this.getLink(new LinkInfoImpl(this.configuration, context, typeElement).label(label).where(this.getName(element.getSimpleName().toString())).strong(strong));
        }
        return label;
    }

    public Content getDocLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element element, Content label) {
        if (!this.utils.isIncluded(element) && !this.utils.isLinkable(typeElement)) {
            return label;
        }
        if (this.utils.isExecutableElement(element)) {
            ExecutableElement emd = (ExecutableElement)element;
            return this.getLink(new LinkInfoImpl(this.configuration, context, typeElement).label(label).where(this.getName(this.getAnchor(emd))));
        }
        if (this.utils.isVariableElement(element) || this.utils.isTypeElement(element)) {
            return this.getLink(new LinkInfoImpl(this.configuration, context, typeElement).label(label).where(this.getName(element.getSimpleName().toString())));
        }
        return label;
    }

    public String getAnchor(ExecutableElement executableElement) {
        return this.getAnchor(executableElement, false);
    }

    public String getAnchor(ExecutableElement executableElement, boolean isProperty) {
        if (isProperty) {
            return executableElement.getSimpleName().toString();
        }
        String signature = this.utils.signature(executableElement);
        StringBuilder signatureParsed = new StringBuilder();
        int counter = 0;
        for (int i = 0; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (c == '<') {
                ++counter;
                continue;
            }
            if (c == '>') {
                --counter;
                continue;
            }
            if (counter != 0) continue;
            signatureParsed.append(c);
        }
        return this.utils.getSimpleName(executableElement) + signatureParsed.toString();
    }

    public Content seeTagToContent(Element element, DocTree see) {
        DocTree.Kind kind = see.getKind();
        if (kind != DocTree.Kind.LINK && kind != DocTree.Kind.SEE && kind != DocTree.Kind.LINK_PLAIN) {
            return new ContentBuilder();
        }
        CommentHelper ch = this.utils.getCommentHelper(element);
        String tagName = ch.getTagName(see);
        String seetext = this.replaceDocRootDir(this.utils.normalizeNewlines(ch.getText(see)).toString());
        if (seetext.startsWith("<") || seetext.startsWith("\"")) {
            return new RawHtml(seetext);
        }
        boolean isLinkPlain = kind == DocTree.Kind.LINK_PLAIN;
        Content label = this.plainOrCode(isLinkPlain, new RawHtml(ch.getLabel(this.configuration, see)));
        Content text = this.plainOrCode(kind == DocTree.Kind.LINK_PLAIN, new RawHtml(seetext));
        TypeElement refClass = ch.getReferencedClass(this.configuration, see);
        String refClassName = ch.getReferencedClassName(this.configuration, see);
        Element refMem = ch.getReferencedMember(this.configuration, see);
        String refMemName = ch.getReferencedMemberName(see);
        if (refMemName == null && refMem != null) {
            refMemName = refMem.toString();
        }
        if (refClass == null) {
            PackageElement refPackage = ch.getReferencedPackage(this.configuration, see);
            if (refPackage != null && this.utils.isIncluded(refPackage)) {
                if (label.isEmpty()) {
                    label = this.plainOrCode(isLinkPlain, new StringContent(refPackage.getQualifiedName()));
                }
                return this.getPackageLink(refPackage, label);
            }
            DocLink packageCrossLink = this.getCrossPackageLink(refClassName);
            if (packageCrossLink != null) {
                return this.getHyperLink(packageCrossLink, label.isEmpty() ? text : label);
            }
            Content classCrossLink = this.getCrossClassLink(refClassName, refMemName, label, false, "", !isLinkPlain);
            if (classCrossLink != null) {
                return classCrossLink;
            }
            this.configuration.getDocletSpecificMsg().warning(ch.getDocTreePath(see), "doclet.see.class_or_package_not_found", "@" + tagName, seetext);
            return label.isEmpty() ? text : label;
        }
        if (refMemName == null) {
            if (label.isEmpty()) {
                if (!this.configuration.backwardCompatibility) {
                    StringContent content = this.utils.isEnclosingPackageIncluded(refClass) ? new StringContent(this.utils.getSimpleName(refClass)) : new StringContent(this.utils.getFullyQualifiedName(refClass));
                    label = this.plainOrCode(isLinkPlain, content);
                } else {
                    label = this.plainOrCode(isLinkPlain, new StringContent(this.utils.getSimpleName(refClass)));
                }
            }
            return this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.DEFAULT, refClass).label(label));
        }
        if (refMem == null) {
            return label.isEmpty() ? text : label;
        }
        TypeElement containing = this.utils.getEnclosingTypeElement(refMem);
        if (ch.getText(see).trim().startsWith("#") && !this.utils.isPublic(containing) && !this.utils.isLinkable(containing)) {
            if (this instanceof ClassWriterImpl) {
                containing = ((ClassWriterImpl)this).getTypeElement();
            } else if (!this.utils.isPublic(containing)) {
                this.configuration.getDocletSpecificMsg().warning(ch.getDocTreePath(see), "doclet.see.class_or_package_not_accessible", tagName, this.utils.getFullyQualifiedName(containing));
            } else {
                this.configuration.getDocletSpecificMsg().warning(ch.getDocTreePath(see), "doclet.see.class_or_package_not_found", tagName, seetext);
            }
        }
        if (this.configuration.currentTypeElement != containing) {
            String string = refMemName = this.utils.isConstructor(refMem) ? refMemName : this.utils.getSimpleName(containing) + "." + refMemName;
        }
        if (this.utils.isExecutableElement(refMem) && refMemName.indexOf(40) < 0) {
            refMemName = refMemName + this.utils.makeSignature((ExecutableElement)refMem, true);
        }
        text = this.plainOrCode(kind == DocTree.Kind.LINK_PLAIN, new StringContent(refMemName));
        return this.getDocLink(LinkInfoImpl.Kind.SEE_TAG, containing, refMem, label.isEmpty() ? text : label, false);
    }

    private Content plainOrCode(boolean plain, Content body) {
        return plain || body.isEmpty() ? body : HtmlTree.CODE(body);
    }

    public void addInlineComment(Element element, DocTree tag, Content htmltree) {
        CommentHelper ch = this.utils.getCommentHelper(element);
        List<? extends DocTree> description = ch.getDescription(this.configuration, tag);
        this.addCommentTags(element, tag, description, false, false, htmltree);
    }

    public void addInlineDeprecatedComment(Element e, DocTree tag, Content htmltree) {
        CommentHelper ch = this.utils.getCommentHelper(e);
        this.addCommentTags(e, ch.getBody(this.configuration, tag), true, false, htmltree);
    }

    public void addSummaryComment(Element element, Content htmltree) {
        this.addSummaryComment(element, this.utils.getFirstSentenceTrees(element), htmltree);
    }

    public void addSummaryComment(Element element, List<? extends DocTree> firstSentenceTags, Content htmltree) {
        this.addCommentTags(element, firstSentenceTags, false, true, htmltree);
    }

    public void addSummaryDeprecatedComment(Element element, DocTree tag, Content htmltree) {
        CommentHelper ch = this.utils.getCommentHelper(element);
        List<? extends DocTree> body = ch.getBody(this.configuration, tag);
        this.addCommentTags(element, ch.getFirstSentenceTrees((Configuration)this.configuration, body), true, true, htmltree);
    }

    public void addInlineComment(Element element, Content htmltree) {
        this.addCommentTags(element, this.utils.getBody(element), false, false, htmltree);
    }

    private void addCommentTags(Element element, List<? extends DocTree> tags, boolean depr, boolean first, Content htmltree) {
        this.addCommentTags(element, null, tags, depr, first, htmltree);
    }

    private void addCommentTags(Element element, DocTree holderTag, List<? extends DocTree> tags, boolean depr, boolean first, Content htmltree) {
        if (this.configuration.nocomment) {
            return;
        }
        Content result = this.commentTagsToContent(null, element, tags, first);
        if (depr) {
            HtmlTree italic = HtmlTree.SPAN(HtmlStyle.deprecationComment, result);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, italic);
            htmltree.addContent(div);
        } else {
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, result);
            htmltree.addContent(div);
        }
        if (tags.isEmpty()) {
            htmltree.addContent(this.getSpace());
        }
    }

    boolean ignoreNonInlineTag(DocTree dtree) {
        org.openjdk.tools.doclint.HtmlTag htmlTag;
        Name name = null;
        if (dtree.getKind() == DocTree.Kind.START_ELEMENT) {
            StartElementTree setree = (StartElementTree)dtree;
            name = setree.getName();
        } else if (dtree.getKind() == DocTree.Kind.END_ELEMENT) {
            EndElementTree eetree = (EndElementTree)dtree;
            name = eetree.getName();
        }
        return name != null && (htmlTag = org.openjdk.tools.doclint.HtmlTag.get(name)) != null && htmlTag.blockType != HtmlTag.BlockType.INLINE;
    }

    boolean isAllWhiteSpace(String body) {
        for (int i = 0; i < body.length(); ++i) {
            if (Character.isWhitespace(body.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public Content commentTagsToContent(final DocTree holderTag, final Element element, final List<? extends DocTree> tags, final boolean isFirstSentence) {
        final ContentBuilder result = new ContentBuilder(){

            @Override
            public void addContent(CharSequence text) {
                super.addContent(HtmlDocletWriter.this.utils.normalizeNewlines(text));
            }
        };
        final CommentHelper ch = this.utils.getCommentHelper(element);
        this.configuration.tagletManager.checkTags(this.utils, element, tags, true);
        final ListIterator<? extends DocTree> iterator = tags.listIterator();
        while (iterator.hasNext()) {
            boolean allDone;
            final DocTree tag = iterator.next();
            if (isFirstSentence && this.ignoreNonInlineTag(tag) || isFirstSentence && iterator.nextIndex() == tags.size() && tag.getKind() == DocTree.Kind.TEXT && this.isAllWhiteSpace(ch.getText(tag)) || !(allDone = ((Boolean)new SimpleDocTreeVisitor<Boolean, Content>(){
                boolean commentRemoved = false;

                private boolean isLast(DocTree node) {
                    return node.equals(tags.get(tags.size() - 1));
                }

                private boolean isFirst(DocTree node) {
                    return node.equals(tags.get(0));
                }

                private boolean inAnAtag() {
                    StartElementTree st;
                    Name name;
                    if (HtmlDocletWriter.this.utils.isStartElement(tag) && (name = (st = (StartElementTree)tag).getName()) != null) {
                        org.openjdk.tools.doclint.HtmlTag htag = org.openjdk.tools.doclint.HtmlTag.get(name);
                        return htag != null && htag.equals((Object)org.openjdk.tools.doclint.HtmlTag.A);
                    }
                    return false;
                }

                @Override
                public Boolean visitAttribute(AttributeTree node, Content c) {
                    String quote;
                    StringBuilder sb = new StringBuilder(" ").append(node.getName());
                    if (node.getValueKind() == AttributeTree.ValueKind.EMPTY) {
                        result.addContent(sb);
                        return false;
                    }
                    sb.append("=");
                    switch (node.getValueKind()) {
                        case DOUBLE: {
                            quote = "\"";
                            break;
                        }
                        case SINGLE: {
                            quote = "'";
                            break;
                        }
                        default: {
                            quote = "";
                        }
                    }
                    sb.append(quote);
                    result.addContent(sb);
                    Content docRootContent = new ContentBuilder();
                    for (DocTree docTree : node.getValue()) {
                        if (HtmlDocletWriter.this.utils.isText(docTree) && this.inAnAtag()) {
                            String text = ((TextTree)docTree).getBody();
                            if (text.startsWith("/..") && !HtmlDocletWriter.this.configuration.docrootparent.isEmpty()) {
                                result.addContent(HtmlDocletWriter.this.configuration.docrootparent);
                                docRootContent = new ContentBuilder();
                                result.addContent(this.textCleanup(text.substring(3), this.isLast(node)));
                                continue;
                            }
                            if (!docRootContent.isEmpty()) {
                                docRootContent = this.copyDocRootContent(docRootContent);
                            } else {
                                text = HtmlDocletWriter.this.redirectRelativeLinks(element, (TextTree)docTree);
                            }
                            result.addContent(this.textCleanup(text, this.isLast(node)));
                            continue;
                        }
                        docRootContent = this.copyDocRootContent(docRootContent);
                        docTree.accept(this, docRootContent);
                    }
                    this.copyDocRootContent(docRootContent);
                    result.addContent(quote);
                    return false;
                }

                @Override
                public Boolean visitComment(CommentTree node, Content c) {
                    if (isFirstSentence && this.isFirst(node)) {
                        this.commentRemoved = true;
                        return (Boolean)this.visit((DocTree)iterator.next(), c);
                    }
                    result.addContent(new RawHtml(node.getBody()));
                    return false;
                }

                private Content copyDocRootContent(Content content) {
                    if (!content.isEmpty()) {
                        result.addContent(content);
                        return new ContentBuilder();
                    }
                    return content;
                }

                @Override
                public Boolean visitDocRoot(DocRootTree node, Content c) {
                    Content docRootContent = TagletWriter.getInlineTagOutput(element, HtmlDocletWriter.this.configuration.tagletManager, holderTag, node, HtmlDocletWriter.this.getTagletWriterInstance(isFirstSentence));
                    if (c != null) {
                        c.addContent(docRootContent);
                    } else {
                        result.addContent(docRootContent);
                    }
                    return false;
                }

                @Override
                public Boolean visitEndElement(EndElementTree node, Content c) {
                    RawHtml rawHtml = new RawHtml("</" + node.getName() + ">");
                    result.addContent(rawHtml);
                    return false;
                }

                @Override
                public Boolean visitEntity(EntityTree node, Content c) {
                    result.addContent(new RawHtml(node.toString()));
                    return false;
                }

                @Override
                public Boolean visitErroneous(ErroneousTree node, Content c) {
                    HtmlDocletWriter.this.configuration.getDocletSpecificMsg().warning(ch.getDocTreePath(node), "doclet.tag.invalid_usage", node);
                    result.addContent(new RawHtml(node.toString()));
                    return false;
                }

                @Override
                public Boolean visitInheritDoc(InheritDocTree node, Content c) {
                    Content output = TagletWriter.getInlineTagOutput(element, HtmlDocletWriter.this.configuration.tagletManager, holderTag, tag, HtmlDocletWriter.this.getTagletWriterInstance(isFirstSentence));
                    result.addContent(output);
                    return isFirstSentence && !output.isEmpty();
                }

                @Override
                public Boolean visitIndex(IndexTree node, Content p) {
                    Content output = TagletWriter.getInlineTagOutput(element, HtmlDocletWriter.this.configuration.tagletManager, holderTag, tag, HtmlDocletWriter.this.getTagletWriterInstance(isFirstSentence));
                    if (output != null) {
                        result.addContent(output);
                    }
                    return false;
                }

                @Override
                public Boolean visitLink(LinkTree node, Content c) {
                    result.addContent(HtmlDocletWriter.this.seeTagToContent(element, tag));
                    return false;
                }

                @Override
                public Boolean visitLiteral(LiteralTree node, Content c) {
                    String s = node.getBody().toString();
                    Content content = new StringContent(HtmlDocletWriter.this.utils.normalizeNewlines(s));
                    if (node.getKind() == DocTree.Kind.CODE) {
                        content = HtmlTree.CODE(content);
                    }
                    result.addContent(content);
                    return false;
                }

                @Override
                public Boolean visitSee(SeeTree node, Content c) {
                    result.addContent(HtmlDocletWriter.this.seeTagToContent(element, tag));
                    return false;
                }

                @Override
                public Boolean visitStartElement(StartElementTree node, Content c) {
                    String text = "<" + node.getName();
                    RawHtml rawHtml = new RawHtml(HtmlDocletWriter.this.utils.normalizeNewlines(text));
                    result.addContent(rawHtml);
                    for (DocTree docTree : node.getAttributes()) {
                        docTree.accept(this, null);
                    }
                    result.addContent(new RawHtml(node.isSelfClosing() ? "/>" : ">"));
                    return false;
                }

                private CharSequence textCleanup(String text, boolean isLast) {
                    return this.textCleanup(text, isLast, false);
                }

                private CharSequence textCleanup(String text, boolean isLast, boolean trimLeader) {
                    if (trimLeader) {
                        text = HtmlDocletWriter.this.removeLeadingWhitespace(text);
                    }
                    if (isFirstSentence && isLast) {
                        text = HtmlDocletWriter.this.removeTrailingWhitespace(text);
                    }
                    text = HtmlDocletWriter.this.utils.replaceTabs(text);
                    return HtmlDocletWriter.this.utils.normalizeNewlines(text);
                }

                @Override
                public Boolean visitText(TextTree node, Content c) {
                    String text = node.getBody();
                    result.addContent(new RawHtml(this.textCleanup(text, this.isLast(node), this.commentRemoved)));
                    this.commentRemoved = false;
                    return false;
                }

                @Override
                protected Boolean defaultAction(DocTree node, Content c) {
                    Content output = TagletWriter.getInlineTagOutput(element, HtmlDocletWriter.this.configuration.tagletManager, holderTag, tag, HtmlDocletWriter.this.getTagletWriterInstance(isFirstSentence));
                    if (output != null) {
                        result.addContent(output);
                    }
                    return false;
                }
            }.visit(tag, null)).booleanValue())) continue;
            break;
        }
        return result;
    }

    private String removeTrailingWhitespace(String text) {
        char[] buf = text.toCharArray();
        for (int i = buf.length - 1; i > 0; --i) {
            if (Character.isWhitespace(buf[i])) continue;
            return text.substring(0, i + 1);
        }
        return text;
    }

    private String removeLeadingWhitespace(String text) {
        char[] buf = text.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            if (Character.isWhitespace(buf[i])) continue;
            return text.substring(i);
        }
        return text;
    }

    private boolean shouldNotRedirectRelativeLinks() {
        return this instanceof AnnotationTypeWriter || this instanceof ClassWriter || this instanceof PackageSummaryWriter;
    }

    private String redirectRelativeLinks(Element element, TextTree tt) {
        String text = tt.getBody();
        if (element == null || this.utils.isOverviewElement(element) || this.shouldNotRedirectRelativeLinks()) {
            return text;
        }
        DocPath redirectPathFromRoot = (DocPath)new SimpleElementVisitor9<DocPath, Void>(){

            @Override
            public DocPath visitType(TypeElement e, Void p) {
                return DocPath.forPackage(HtmlDocletWriter.this.utils.containingPackage(e));
            }

            @Override
            public DocPath visitPackage(PackageElement e, Void p) {
                return DocPath.forPackage(e);
            }

            @Override
            public DocPath visitVariable(VariableElement e, Void p) {
                return DocPath.forPackage(HtmlDocletWriter.this.utils.containingPackage(e));
            }

            @Override
            public DocPath visitExecutable(ExecutableElement e, Void p) {
                return DocPath.forPackage(HtmlDocletWriter.this.utils.containingPackage(e));
            }

            @Override
            protected DocPath defaultAction(Element e, Void p) {
                return null;
            }
        }.visit(element);
        if (redirectPathFromRoot == null) {
            return text;
        }
        String lower = Utils.toLowerCase(text);
        if (!(lower.startsWith("mailto:") || lower.startsWith("http:") || lower.startsWith("https:") || lower.startsWith("file:"))) {
            text = "{@" + new DocRootTaglet().getName() + "}/" + redirectPathFromRoot.resolve(text).getPath();
            text = this.replaceDocRootDir(text);
        }
        return text;
    }

    public void addStyleSheetProperties(Content head) {
        DocPath stylesheet;
        String stylesheetfile = this.configuration.stylesheetfile;
        if (stylesheetfile.isEmpty()) {
            stylesheet = DocPaths.STYLESHEET;
        } else {
            DocFile file = DocFile.createFileForInput(this.configuration, stylesheetfile);
            stylesheet = DocPath.create(file.getName());
        }
        HtmlTree link = HtmlTree.LINK("stylesheet", "text/css", this.pathToRoot.resolve(stylesheet).getPath(), "Style");
        head.addContent(link);
        if (this.configuration.createindex) {
            HtmlTree jq_link = HtmlTree.LINK("stylesheet", "text/css", this.pathToRoot.resolve(DocPaths.JQUERY_FILES.resolve(DocPaths.JQUERY_STYLESHEET_FILE)).getPath(), "Style");
            head.addContent(jq_link);
        }
    }

    public void addScriptProperties(Content head) {
        HtmlTree javascript = HtmlTree.SCRIPT(this.pathToRoot.resolve(DocPaths.JAVASCRIPT).getPath());
        head.addContent(javascript);
        if (this.configuration.createindex) {
            if (this.pathToRoot != null && this.script != null) {
                String path = this.pathToRoot.isEmpty() ? "." : this.pathToRoot.getPath();
                this.script.addContent(new RawHtml("var pathtoroot = \"" + path + "/\";loadScripts(document, 'script');"));
            }
            this.addJQueryFile(head, DocPaths.JSZIP_MIN);
            this.addJQueryFile(head, DocPaths.JSZIPUTILS_MIN);
            head.addContent(new RawHtml("<!--[if IE]>"));
            this.addJQueryFile(head, DocPaths.JSZIPUTILS_IE_MIN);
            head.addContent(new RawHtml("<![endif]-->"));
            this.addJQueryFile(head, DocPaths.JQUERY_JS_1_10);
            this.addJQueryFile(head, DocPaths.JQUERY_JS);
        }
    }

    private void addJQueryFile(Content head, DocPath filePath) {
        HtmlTree jqyeryScriptFile = HtmlTree.SCRIPT(this.pathToRoot.resolve(DocPaths.JQUERY_FILES.resolve(filePath)).getPath());
        head.addContent(jqyeryScriptFile);
    }

    public boolean isCoreClass(TypeElement typeElement) {
        return this.utils.getEnclosingTypeElement(typeElement) == null || this.utils.isStatic(typeElement);
    }

    public void addAnnotationInfo(PackageElement packageElement, Content htmltree) {
        this.addAnnotationInfo(packageElement, packageElement.getAnnotationMirrors(), htmltree);
    }

    public void addReceiverAnnotationInfo(ExecutableElement method, List<AnnotationMirror> descList, Content htmltree) {
        this.addAnnotationInfo(0, method, descList, false, htmltree);
    }

    public void addReceiverAnnotationInfo(ExecutableElement method, TypeMirror rcvrTypeMirror, List<? extends AnnotationMirror> annotationMirrors, Content htmltree) {
        TypeMirror rcvrType = method.getReceiverType();
        List<? extends AnnotationMirror> annotationMirrors1 = rcvrType.getAnnotationMirrors();
        this.addAnnotationInfo(0, method, annotationMirrors1, false, htmltree);
    }

    public void addAnnotationInfo(Element element, Content htmltree) {
        this.addAnnotationInfo(element, element.getAnnotationMirrors(), htmltree);
    }

    public boolean addAnnotationInfo(int indent, Element element, VariableElement param, Content tree) {
        return this.addAnnotationInfo(indent, element, param.getAnnotationMirrors(), false, tree);
    }

    private void addAnnotationInfo(Element element, List<? extends AnnotationMirror> descList, Content htmltree) {
        this.addAnnotationInfo(0, element, descList, true, htmltree);
    }

    private boolean addAnnotationInfo(int indent, Element element, List<? extends AnnotationMirror> descList, boolean lineBreak, Content htmltree) {
        List<Content> annotations = this.getAnnotations(indent, descList, lineBreak);
        String sep = "";
        if (annotations.isEmpty()) {
            return false;
        }
        for (Content annotation : annotations) {
            htmltree.addContent(sep);
            htmltree.addContent(annotation);
            if (lineBreak) continue;
            sep = " ";
        }
        return true;
    }

    private List<Content> getAnnotations(int indent, List<? extends AnnotationMirror> descList, boolean linkBreak) {
        return this.getAnnotations(indent, descList, linkBreak, true);
    }

    private List<Content> getAnnotations(int indent, AnnotationMirror amirror, boolean linkBreak) {
        ArrayList<AnnotationMirror> descList = new ArrayList<AnnotationMirror>();
        descList.add(amirror);
        return this.getAnnotations(indent, descList, linkBreak, true);
    }

    /*
     * WARNING - void declaration
     */
    public List<Content> getAnnotations(int indent, List<? extends AnnotationMirror> descList, boolean linkBreak, boolean isJava5DeclarationLocation) {
        ArrayList<Content> results = new ArrayList<Content>();
        for (AnnotationMirror annotationMirror : descList) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!this.utils.isDocumentedAnnotation(annotationElement) && !this.isAnnotationDocumented && !this.isContainerDocumented) continue;
            ContentBuilder annotation = new ContentBuilder();
            this.isAnnotationDocumented = false;
            LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.ANNOTATION, annotationElement);
            Map<? extends ExecutableElement, ? extends AnnotationValue> pairs = annotationMirror.getElementValues();
            if (this.utils.configuration.workArounds.isSynthesized(annotationMirror)) {
                for (ExecutableElement executableElement : pairs.keySet()) {
                    final AnnotationValue annotationValue = pairs.get(executableElement);
                    ArrayList annotationTypeValues = new ArrayList();
                    new SimpleAnnotationValueVisitor9<Void, List<AnnotationValue>>(){

                        @Override
                        public Void visitArray(List<? extends AnnotationValue> vals, List<AnnotationValue> p) {
                            p.addAll(vals);
                            return null;
                        }

                        @Override
                        protected Void defaultAction(Object o, List<AnnotationValue> p) {
                            p.add(annotationValue);
                            return null;
                        }
                    }.visit(annotationValue, annotationTypeValues);
                    String sep = "";
                    for (AnnotationValue av : annotationTypeValues) {
                        annotation.addContent(sep);
                        annotation.addContent(this.annotationValueToContent(av));
                        sep = " ";
                    }
                }
            } else if (this.isAnnotationArray(pairs)) {
                if (pairs.size() == 1 && this.isAnnotationDocumented) {
                    ArrayList annotationTypeValues = new ArrayList();
                    for (AnnotationValue a : pairs.values()) {
                        new SimpleAnnotationValueVisitor9<Void, List<AnnotationValue>>(){

                            @Override
                            public Void visitArray(List<? extends AnnotationValue> vals, List<AnnotationValue> annotationTypeValues) {
                                for (AnnotationValue annotationValue : vals) {
                                    annotationTypeValues.add(annotationValue);
                                }
                                return null;
                            }
                        }.visit(a, annotationTypeValues);
                    }
                    String string = "";
                    for (AnnotationValue av : annotationTypeValues) {
                        void var13_17;
                        annotation.addContent((CharSequence)var13_17);
                        annotation.addContent(this.annotationValueToContent(av));
                        String string2 = " ";
                    }
                } else {
                    this.addAnnotations(annotationElement, linkInfo, annotation, pairs, indent, false);
                }
            } else {
                this.addAnnotations(annotationElement, linkInfo, annotation, pairs, indent, linkBreak);
            }
            annotation.addContent(linkBreak ? DocletConstants.NL : "");
            results.add(annotation);
        }
        return results;
    }

    private void addAnnotations(TypeElement annotationDoc, LinkInfoImpl linkInfo, ContentBuilder annotation, Map<? extends ExecutableElement, ? extends AnnotationValue> map, int indent, boolean linkBreak) {
        linkInfo.label = new StringContent("@");
        linkInfo.label.addContent(annotationDoc.getSimpleName());
        annotation.addContent(this.getLink(linkInfo));
        if (!map.isEmpty()) {
            annotation.addContent("(");
            boolean isFirst = true;
            Set<? extends ExecutableElement> keys = map.keySet();
            boolean multipleValues = keys.size() > 1;
            for (ExecutableElement executableElement : keys) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    annotation.addContent(",");
                    if (linkBreak) {
                        annotation.addContent(DocletConstants.NL);
                        int spaces = annotationDoc.getSimpleName().length() + 2;
                        for (int k = 0; k < spaces + indent; ++k) {
                            annotation.addContent(" ");
                        }
                    }
                }
                String simpleName = executableElement.getSimpleName().toString();
                if (multipleValues || !"value".equals(simpleName)) {
                    annotation.addContent(this.getDocLink(LinkInfoImpl.Kind.ANNOTATION, executableElement, simpleName, false));
                    annotation.addContent("=");
                }
                AnnotationValue annotationValue = map.get(executableElement);
                final ArrayList annotationTypeValues = new ArrayList();
                new SimpleAnnotationValueVisitor9<Void, AnnotationValue>(){

                    @Override
                    public Void visitArray(List<? extends AnnotationValue> vals, AnnotationValue p) {
                        annotationTypeValues.addAll(vals);
                        return null;
                    }

                    @Override
                    protected Void defaultAction(Object o, AnnotationValue p) {
                        annotationTypeValues.add(p);
                        return null;
                    }
                }.visit(annotationValue, annotationValue);
                annotation.addContent(annotationTypeValues.size() == 1 ? "" : "{");
                String sep = "";
                for (AnnotationValue av : annotationTypeValues) {
                    annotation.addContent(sep);
                    annotation.addContent(this.annotationValueToContent(av));
                    sep = ",";
                }
                annotation.addContent(annotationTypeValues.size() == 1 ? "" : "}");
                this.isContainerDocumented = false;
            }
            annotation.addContent(")");
        }
    }

    private boolean isAnnotationArray(Map<? extends ExecutableElement, ? extends AnnotationValue> pairs) {
        for (ExecutableElement executableElement : pairs.keySet()) {
            AnnotationValue annotationValue = pairs.get(executableElement);
            boolean rvalue = (Boolean)new SimpleAnnotationValueVisitor9<Boolean, Void>(){

                @Override
                public Boolean visitArray(List<? extends AnnotationValue> vals, Void p) {
                    if (vals.size() > 1 && vals.get(0) instanceof AnnotationMirror) {
                        HtmlDocletWriter.this.isContainerDocumented = true;
                        return (Boolean)new SimpleAnnotationValueVisitor9<Boolean, Void>(){

                            @Override
                            public Boolean visitAnnotation(AnnotationMirror a, Void p) {
                                HtmlDocletWriter.this.isContainerDocumented = true;
                                Element asElement = a.getAnnotationType().asElement();
                                if (HtmlDocletWriter.this.utils.isDocumentedAnnotation((TypeElement)asElement)) {
                                    HtmlDocletWriter.this.isAnnotationDocumented = true;
                                }
                                return true;
                            }

                            @Override
                            protected Boolean defaultAction(Object o, Void p) {
                                return false;
                            }
                        }.visit(vals.get(0));
                    }
                    return false;
                }

                @Override
                protected Boolean defaultAction(Object o, Void p) {
                    return false;
                }
            }.visit(annotationValue);
            if (!rvalue) continue;
            return true;
        }
        return false;
    }

    private Content annotationValueToContent(final AnnotationValue annotationValue) {
        return (Content)new SimpleAnnotationValueVisitor9<Content, Void>(){

            @Override
            public Content visitType(final TypeMirror t, Void p) {
                return (Content)new SimpleTypeVisitor9<Content, Void>(){

                    @Override
                    public Content visitDeclared(DeclaredType t2, Void p) {
                        LinkInfoImpl linkInfo = new LinkInfoImpl(HtmlDocletWriter.this.configuration, LinkInfoImpl.Kind.ANNOTATION, t2);
                        String name = HtmlDocletWriter.this.utils.isIncluded(t2.asElement()) ? t2.asElement().getSimpleName().toString() : HtmlDocletWriter.this.utils.getFullyQualifiedName(t2.asElement());
                        linkInfo.label = new StringContent(name + HtmlDocletWriter.this.utils.getDimension(t2) + ".class");
                        return HtmlDocletWriter.this.getLink(linkInfo);
                    }

                    @Override
                    protected Content defaultAction(TypeMirror e, Void p) {
                        return new StringContent(t + HtmlDocletWriter.this.utils.getDimension(t) + ".class");
                    }
                }.visit(t);
            }

            @Override
            public Content visitAnnotation(AnnotationMirror a, Void p) {
                List list = HtmlDocletWriter.this.getAnnotations(0, a, false);
                ContentBuilder buf = new ContentBuilder();
                for (Content c : list) {
                    buf.addContent(c);
                }
                return buf;
            }

            @Override
            public Content visitEnumConstant(VariableElement c, Void p) {
                return HtmlDocletWriter.this.getDocLink(LinkInfoImpl.Kind.ANNOTATION, c, c.getSimpleName(), false);
            }

            @Override
            public Content visitArray(List<? extends AnnotationValue> vals, Void p) {
                ContentBuilder buf = new ContentBuilder();
                String sep = "";
                for (AnnotationValue annotationValue2 : vals) {
                    buf.addContent(sep);
                    buf.addContent((Content)this.visit(annotationValue2));
                    sep = " ";
                }
                return buf;
            }

            @Override
            protected Content defaultAction(Object o, Void p) {
                return new StringContent(annotationValue.toString());
            }
        }.visit(annotationValue);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    static {
        for (HtmlTag t : HtmlTag.values()) {
            if (t.blockType != HtmlTag.BlockType.BLOCK) continue;
            blockTags.add(t.value);
        }
    }
}

