/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html.markup;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlAttr;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlVersion;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletConstants;

public class HtmlTree
extends Content {
    private HtmlTag htmlTag;
    private Map<HtmlAttr, String> attrs = Collections.emptyMap();
    private List<Content> content = Collections.emptyList();
    public static final Content EMPTY;
    public static final BitSet NONENCODING_CHARS;

    public HtmlTree(HtmlTag tag) {
        this.htmlTag = HtmlTree.nullCheck(tag);
    }

    public HtmlTree(HtmlTag tag, Content ... contents) {
        this(tag);
        for (Content content : contents) {
            this.addContent(content);
        }
    }

    public void addAttr(HtmlAttr attrName, String attrValue) {
        if (this.attrs.isEmpty()) {
            this.attrs = new LinkedHashMap<HtmlAttr, String>(3);
        }
        this.attrs.put(HtmlTree.nullCheck(attrName), HtmlTree.escapeHtmlChars(attrValue));
    }

    public void setTitle(Content body) {
        this.addAttr(HtmlAttr.TITLE, HtmlTree.stripHtml(body));
    }

    public void setRole(HtmlAttr.Role role) {
        this.addAttr(HtmlAttr.ROLE, role.toString());
    }

    public void addStyle(HtmlStyle style) {
        this.addAttr(HtmlAttr.CLASS, style.toString());
    }

    @Override
    public void addContent(Content tagContent) {
        if (tagContent instanceof ContentBuilder) {
            for (Content content : ((ContentBuilder)tagContent).contents) {
                this.addContent(content);
            }
        } else if (tagContent == EMPTY || tagContent.isValid()) {
            if (this.content.isEmpty()) {
                this.content = new ArrayList<Content>();
            }
            this.content.add(tagContent);
        }
    }

    @Override
    public void addContent(CharSequence stringContent) {
        if (!this.content.isEmpty()) {
            Content lastContent = this.content.get(this.content.size() - 1);
            if (lastContent instanceof StringContent) {
                lastContent.addContent(stringContent);
            } else {
                this.addContent(new StringContent(stringContent));
            }
        } else {
            this.addContent(new StringContent(stringContent));
        }
    }

    @Override
    public int charCount() {
        int n = 0;
        for (Content c : this.content) {
            n += c.charCount();
        }
        return n;
    }

    private static String escapeHtmlChars(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '&': 
                case '<': 
                case '>': {
                    StringBuilder sb = new StringBuilder(s.substring(0, i));
                    while (i < s.length()) {
                        ch = s.charAt(i);
                        switch (ch) {
                            case '<': {
                                sb.append("&lt;");
                                break;
                            }
                            case '>': {
                                sb.append("&gt;");
                                break;
                            }
                            case '&': {
                                sb.append("&amp;");
                                break;
                            }
                            default: {
                                sb.append(ch);
                            }
                        }
                        ++i;
                    }
                    return sb.toString();
                }
            }
        }
        return s;
    }

    private static String encodeURL(String url) {
        StringBuilder sb = new StringBuilder();
        for (byte c : url.getBytes(Charset.forName("UTF-8"))) {
            if (NONENCODING_CHARS.get(c & 0xFF)) {
                sb.append((char)c);
                continue;
            }
            sb.append(String.format("%%%02X", c & 0xFF));
        }
        return sb.toString();
    }

    public static HtmlTree A(String ref, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.A, HtmlTree.nullCheck(body));
        htmltree.addAttr(HtmlAttr.HREF, HtmlTree.encodeURL(ref));
        return htmltree;
    }

    public static HtmlTree A(HtmlVersion htmlVersion, String attr, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.A);
        htmltree.addAttr(htmlVersion == HtmlVersion.HTML4 ? HtmlAttr.NAME : HtmlAttr.ID, HtmlTree.nullCheck(attr));
        htmltree.addContent(HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree A_ID(String id, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.A);
        htmltree.addAttr(HtmlAttr.ID, HtmlTree.nullCheck(id));
        htmltree.addContent(HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree CAPTION(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.CAPTION, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree CODE(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.CODE, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree DD(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.DD, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree DL(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.DL, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree DIV(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.DIV, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree DIV(Content body) {
        return HtmlTree.DIV(null, body);
    }

    public static HtmlTree DT(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.DT, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree FOOTER() {
        HtmlTree htmltree = new HtmlTree(HtmlTag.FOOTER);
        htmltree.setRole(HtmlAttr.Role.CONTENTINFO);
        return htmltree;
    }

    public static HtmlTree HEADER() {
        HtmlTree htmltree = new HtmlTree(HtmlTag.HEADER);
        htmltree.setRole(HtmlAttr.Role.BANNER);
        return htmltree;
    }

    public static HtmlTree HEADING(HtmlTag headingTag, boolean printTitle, HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(headingTag, HtmlTree.nullCheck(body));
        if (printTitle) {
            htmltree.setTitle(body);
        }
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree HEADING(HtmlTag headingTag, HtmlStyle styleClass, Content body) {
        return HtmlTree.HEADING(headingTag, false, styleClass, body);
    }

    public static HtmlTree HEADING(HtmlTag headingTag, boolean printTitle, Content body) {
        return HtmlTree.HEADING(headingTag, printTitle, null, body);
    }

    public static HtmlTree HEADING(HtmlTag headingTag, Content body) {
        return HtmlTree.HEADING(headingTag, false, null, body);
    }

    public static HtmlTree HTML(String lang, Content head, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.HTML, HtmlTree.nullCheck(head), HtmlTree.nullCheck(body));
        htmltree.addAttr(HtmlAttr.LANG, HtmlTree.nullCheck(lang));
        return htmltree;
    }

    public static HtmlTree IFRAME(String src, String name, String title) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.IFRAME);
        htmltree.addAttr(HtmlAttr.SRC, HtmlTree.nullCheck(src));
        htmltree.addAttr(HtmlAttr.NAME, HtmlTree.nullCheck(name));
        htmltree.addAttr(HtmlAttr.TITLE, HtmlTree.nullCheck(title));
        return htmltree;
    }

    public static HtmlTree INPUT(String type, String id) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.INPUT);
        htmltree.addAttr(HtmlAttr.TYPE, HtmlTree.nullCheck(type));
        htmltree.addAttr(HtmlAttr.ID, HtmlTree.nullCheck(id));
        htmltree.addAttr(HtmlAttr.VALUE, " ");
        htmltree.addAttr(HtmlAttr.DISABLED, "disabled");
        return htmltree;
    }

    public static HtmlTree LI(Content body) {
        return HtmlTree.LI(null, body);
    }

    public static HtmlTree LI(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.LI, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree LINK(String rel, String type, String href, String title) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.LINK);
        htmltree.addAttr(HtmlAttr.REL, HtmlTree.nullCheck(rel));
        htmltree.addAttr(HtmlAttr.TYPE, HtmlTree.nullCheck(type));
        htmltree.addAttr(HtmlAttr.HREF, HtmlTree.nullCheck(href));
        htmltree.addAttr(HtmlAttr.TITLE, HtmlTree.nullCheck(title));
        return htmltree;
    }

    public static HtmlTree MAIN() {
        HtmlTree htmltree = new HtmlTree(HtmlTag.MAIN);
        htmltree.setRole(HtmlAttr.Role.MAIN);
        return htmltree;
    }

    public static HtmlTree MAIN(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.MAIN, HtmlTree.nullCheck(body));
        htmltree.setRole(HtmlAttr.Role.MAIN);
        return htmltree;
    }

    public static HtmlTree MAIN(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = HtmlTree.MAIN(body);
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree META(String httpEquiv, String content, String charSet) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.META);
        String contentCharset = content + "; charset=" + charSet;
        htmltree.addAttr(HtmlAttr.HTTP_EQUIV, HtmlTree.nullCheck(httpEquiv));
        htmltree.addAttr(HtmlAttr.CONTENT, contentCharset);
        return htmltree;
    }

    public static HtmlTree META(String name, String content) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.META);
        htmltree.addAttr(HtmlAttr.NAME, HtmlTree.nullCheck(name));
        htmltree.addAttr(HtmlAttr.CONTENT, HtmlTree.nullCheck(content));
        return htmltree;
    }

    public static HtmlTree NAV() {
        HtmlTree htmltree = new HtmlTree(HtmlTag.NAV);
        htmltree.setRole(HtmlAttr.Role.NAVIGATION);
        return htmltree;
    }

    public static HtmlTree NOSCRIPT(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.NOSCRIPT, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree P(Content body) {
        return HtmlTree.P(null, body);
    }

    public static HtmlTree P(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.P, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree SCRIPT(String src) {
        HtmlTree htmltree = HtmlTree.SCRIPT();
        htmltree.addAttr(HtmlAttr.SRC, HtmlTree.nullCheck(src));
        return htmltree;
    }

    public static HtmlTree SCRIPT() {
        HtmlTree htmltree = new HtmlTree(HtmlTag.SCRIPT);
        htmltree.addAttr(HtmlAttr.TYPE, "text/javascript");
        return htmltree;
    }

    public static HtmlTree SECTION() {
        HtmlTree htmltree = new HtmlTree(HtmlTag.SECTION);
        htmltree.setRole(HtmlAttr.Role.REGION);
        return htmltree;
    }

    public static HtmlTree SECTION(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.SECTION, HtmlTree.nullCheck(body));
        htmltree.setRole(HtmlAttr.Role.REGION);
        return htmltree;
    }

    public static HtmlTree SMALL(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.SMALL, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree SPAN(Content body) {
        return HtmlTree.SPAN(null, body);
    }

    public static HtmlTree SPAN(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.SPAN, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree SPAN(String id, HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.SPAN, HtmlTree.nullCheck(body));
        htmltree.addAttr(HtmlAttr.ID, HtmlTree.nullCheck(id));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree TABLE(HtmlStyle styleClass, String summary, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TABLE, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        htmltree.addAttr(HtmlAttr.SUMMARY, HtmlTree.nullCheck(summary));
        return htmltree;
    }

    public static HtmlTree TABLE(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TABLE, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree TD(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TD, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        return htmltree;
    }

    public static HtmlTree TD(Content body) {
        return HtmlTree.TD(null, body);
    }

    public static HtmlTree TH(HtmlStyle styleClass, String scope, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TH, HtmlTree.nullCheck(body));
        if (styleClass != null) {
            htmltree.addStyle(styleClass);
        }
        htmltree.addAttr(HtmlAttr.SCOPE, HtmlTree.nullCheck(scope));
        return htmltree;
    }

    public static HtmlTree TH(String scope, Content body) {
        return HtmlTree.TH(null, scope, body);
    }

    public static HtmlTree TITLE(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TITLE, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree TR(Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.TR, HtmlTree.nullCheck(body));
        return htmltree;
    }

    public static HtmlTree UL(HtmlStyle styleClass, Content body) {
        HtmlTree htmltree = new HtmlTree(HtmlTag.UL, HtmlTree.nullCheck(body));
        htmltree.addStyle(HtmlTree.nullCheck(styleClass));
        return htmltree;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasContent() && !this.hasAttrs();
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public boolean hasAttrs() {
        return !this.attrs.isEmpty();
    }

    public boolean hasAttr(HtmlAttr attrName) {
        return this.attrs.containsKey((Object)attrName);
    }

    @Override
    public boolean isValid() {
        switch (this.htmlTag) {
            case A: {
                return this.hasAttr(HtmlAttr.NAME) || this.hasAttr(HtmlAttr.ID) || this.hasAttr(HtmlAttr.HREF) && this.hasContent();
            }
            case BR: {
                return !this.hasContent() && (!this.hasAttrs() || this.hasAttr(HtmlAttr.CLEAR));
            }
            case IFRAME: {
                return this.hasAttr(HtmlAttr.SRC) && !this.hasContent();
            }
            case HR: 
            case INPUT: {
                return !this.hasContent();
            }
            case IMG: {
                return this.hasAttr(HtmlAttr.SRC) && this.hasAttr(HtmlAttr.ALT) && !this.hasContent();
            }
            case LINK: {
                return this.hasAttr(HtmlAttr.HREF) && !this.hasContent();
            }
            case META: {
                return this.hasAttr(HtmlAttr.CONTENT) && !this.hasContent();
            }
            case SCRIPT: {
                return this.hasAttr(HtmlAttr.TYPE) && this.hasAttr(HtmlAttr.SRC) && !this.hasContent() || this.hasAttr(HtmlAttr.TYPE) && this.hasContent();
            }
        }
        return this.hasContent();
    }

    public boolean isInline() {
        return this.htmlTag.blockType == HtmlTag.BlockType.INLINE;
    }

    @Override
    public boolean write(Writer out, boolean atNewline) throws IOException {
        if (!this.isInline() && !atNewline) {
            out.write(DocletConstants.NL);
        }
        String tagString = this.htmlTag.toString();
        out.write("<");
        out.write(tagString);
        for (HtmlAttr key : this.attrs.keySet()) {
            String value = this.attrs.get((Object)key);
            out.write(" ");
            out.write(key.toString());
            if (value.isEmpty()) continue;
            out.write("=\"");
            out.write(value);
            out.write("\"");
        }
        out.write(">");
        boolean nl = false;
        for (Content c : this.content) {
            nl = c.write(out, nl);
        }
        if (this.htmlTag.endTagRequired()) {
            out.write("</");
            out.write(tagString);
            out.write(">");
        }
        if (!this.isInline()) {
            out.write(DocletConstants.NL);
            return true;
        }
        return false;
    }

    private static String stripHtml(Content body) {
        String rawString = body.toString();
        rawString = rawString.replaceAll("\\<.*?>", " ");
        rawString = rawString.replaceAll("\\b\\s{2,}\\b", " ");
        return rawString.trim();
    }

    static {
        int i;
        EMPTY = new StringContent("");
        NONENCODING_CHARS = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            NONENCODING_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            NONENCODING_CHARS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            NONENCODING_CHARS.set(i);
        }
        String noEnc = ":/?#[]@!$&'()*+,;=";
        noEnc = noEnc + "-._~";
        for (int i2 = 0; i2 < noEnc.length(); ++i2) {
            NONENCODING_CHARS.set(noEnc.charAt(i2));
        }
    }
}

