/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.CodeTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.DocRootTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.IndexTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.InheritDocTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.LiteralTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.ParamTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.PropertyGetterTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.PropertySetterTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.ReturnTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.SeeTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.SimpleTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.Taglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.ThrowsTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.UserTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.ValueTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.CommentHelper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.MessageRetriever;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class TagletManager {
    public static final char SIMPLE_TAGLET_OPT_SEPARATOR = ':';
    public static final String ALT_SIMPLE_TAGLET_OPT_SEPARATOR = "-";
    private final LinkedHashMap<String, Taglet> customTags;
    private List<Taglet> packageTags;
    private List<Taglet> typeTags;
    private List<Taglet> fieldTags;
    private List<Taglet> constructorTags;
    private List<Taglet> methodTags;
    private List<Taglet> overviewTags;
    private List<Taglet> inlineTags;
    private List<Taglet> serializedFormTags;
    private final MessageRetriever message;
    private final Set<String> standardTags;
    private final Set<String> standardTagsLowercase;
    private final Set<String> overridenStandardTags = new HashSet<String>();
    private final Set<String> potentiallyConflictingTags = new HashSet<String>();
    private final Set<String> unseenCustomTags;
    private final boolean nosince;
    private final boolean showversion;
    private final boolean showauthor;
    private final boolean javafx;

    public TagletManager(boolean nosince, boolean showversion, boolean showauthor, boolean javafx, MessageRetriever message) {
        this.standardTags = new HashSet<String>();
        this.standardTagsLowercase = new HashSet<String>();
        this.unseenCustomTags = new HashSet<String>();
        this.customTags = new LinkedHashMap();
        this.nosince = nosince;
        this.showversion = showversion;
        this.showauthor = showauthor;
        this.javafx = javafx;
        this.message = message;
        this.initStandardTaglets();
        this.initStandardTagsLowercase();
    }

    public void addCustomTag(Taglet customTag) {
        if (customTag != null) {
            String name = customTag.getName();
            if (this.customTags.containsKey(name)) {
                this.customTags.remove(name);
            }
            this.customTags.put(name, customTag);
            this.checkTagName(name);
        }
    }

    public Set<String> getCustomTagNames() {
        return this.customTags.keySet();
    }

    public void addCustomTag(String classname, JavaFileManager fileManager, String tagletPath) {
        try {
            ClassLoader tagClassLoader;
            Class<?> customTagClass;
            Object instance;
            UserTaglet newLegacy;
            String tname;
            Taglet t;
            if (!fileManager.hasLocation(DocumentationTool.Location.TAGLET_PATH)) {
                ArrayList<File> paths = new ArrayList<File>();
                if (tagletPath != null) {
                    for (String pathname : tagletPath.split(File.pathSeparator)) {
                        paths.add(new File(pathname));
                    }
                }
                if (fileManager instanceof StandardJavaFileManager) {
                    ((StandardJavaFileManager)fileManager).setLocation(DocumentationTool.Location.TAGLET_PATH, paths);
                }
            }
            if ((t = this.customTags.get(tname = (newLegacy = new UserTaglet((org.openjdk.tools.javadoc.doclet.taglet.Taglet)(instance = (customTagClass = (tagClassLoader = fileManager.getClassLoader(DocumentationTool.Location.TAGLET_PATH)).loadClass(classname)).newInstance()))).getName())) != null) {
                this.customTags.remove(tname);
            }
            this.customTags.put(tname, newLegacy);
            this.message.notice("doclet.Notice_taglet_registered", classname);
        }
        catch (Exception exc) {
            this.message.error("doclet.Error_taglet_not_registered", exc.getClass().getName(), classname);
        }
    }

    public void addNewSimpleCustomTag(String tagName, String header, String locations) {
        if (tagName == null || locations == null) {
            return;
        }
        Taglet tag = this.customTags.get(tagName);
        locations = Utils.toLowerCase(locations);
        if (tag == null || header != null) {
            this.customTags.remove(tagName);
            this.customTags.put(tagName, new SimpleTaglet(tagName, header, locations));
            if (locations != null && locations.indexOf(120) == -1) {
                this.checkTagName(tagName);
            }
        } else {
            this.customTags.remove(tagName);
            this.customTags.put(tagName, tag);
        }
    }

    private void checkTagName(String name) {
        if (this.standardTags.contains(name)) {
            this.overridenStandardTags.add(name);
        } else {
            if (name.indexOf(46) == -1) {
                this.potentiallyConflictingTags.add(name);
            }
            this.unseenCustomTags.add(name);
        }
    }

    private void checkTaglet(Object taglet) {
        if (taglet instanceof Taglet) {
            this.checkTagName(((Taglet)taglet).getName());
        } else if (taglet instanceof org.openjdk.tools.javadoc.doclet.taglet.Taglet) {
            org.openjdk.tools.javadoc.doclet.taglet.Taglet legacyTaglet = (org.openjdk.tools.javadoc.doclet.taglet.Taglet)taglet;
            this.customTags.remove(legacyTaglet.getName());
            this.customTags.put(legacyTaglet.getName(), new UserTaglet(legacyTaglet));
            this.checkTagName(legacyTaglet.getName());
        } else {
            throw new IllegalArgumentException("Given object is not a taglet.");
        }
    }

    public void seenCustomTag(String name) {
        this.unseenCustomTags.remove(name);
    }

    public void checkTags(final Utils utils, Element element, Iterable<? extends DocTree> trees, boolean areInlineTags) {
        if (trees == null) {
            return;
        }
        CommentHelper ch = utils.getCommentHelper(element);
        for (final DocTree docTree : trees) {
            String name = docTree.getKind().tagName;
            if (name == null) continue;
            if (name.length() > 0 && name.charAt(0) == '@') {
                name = name.substring(1, name.length());
            }
            if (!this.standardTags.contains(name) && !this.customTags.containsKey(name)) {
                if (this.standardTagsLowercase.contains(Utils.toLowerCase(name))) {
                    this.message.warning(ch.getDocTreePath(docTree), "doclet.UnknownTagLowercase", ch.getTagName(docTree));
                    continue;
                }
                this.message.warning(ch.getDocTreePath(docTree), "doclet.UnknownTag", ch.getTagName(docTree));
                continue;
            }
            final Taglet taglet = this.customTags.get(name);
            if (taglet == null) continue;
            if (areInlineTags && !taglet.isInlineTag()) {
                this.printTagMisuseWarn(ch, taglet, docTree, "inline");
            }
            if (element == null) {
                return;
            }
            new SimpleElementVisitor9<Void, Void>(){

                @Override
                public Void visitPackage(PackageElement e, Void p) {
                    if (!taglet.inPackage()) {
                        TagletManager.this.printTagMisuseWarn(utils.getCommentHelper(e), taglet, docTree, "package");
                    }
                    return null;
                }

                @Override
                public Void visitType(TypeElement e, Void p) {
                    if (!taglet.inType()) {
                        TagletManager.this.printTagMisuseWarn(utils.getCommentHelper(e), taglet, docTree, "class");
                    }
                    return null;
                }

                @Override
                public Void visitExecutable(ExecutableElement e, Void p) {
                    if (utils.isConstructor(e) && !taglet.inConstructor()) {
                        TagletManager.this.printTagMisuseWarn(utils.getCommentHelper(e), taglet, docTree, "constructor");
                    } else if (!taglet.inMethod()) {
                        TagletManager.this.printTagMisuseWarn(utils.getCommentHelper(e), taglet, docTree, "method");
                    }
                    return null;
                }

                @Override
                public Void visitVariable(VariableElement e, Void p) {
                    if (utils.isField(e) && !taglet.inField()) {
                        TagletManager.this.printTagMisuseWarn(utils.getCommentHelper(e), taglet, docTree, "field");
                    }
                    return null;
                }

                @Override
                public Void visitUnknown(Element e, Void p) {
                    if (utils.isOverviewElement(e) && !taglet.inOverview()) {
                        TagletManager.this.printTagMisuseWarn(utils.getCommentHelper(e), taglet, docTree, "overview");
                    }
                    return null;
                }

                @Override
                protected Void defaultAction(Element e, Void p) {
                    return null;
                }
            }.visit(element);
        }
    }

    private void printTagMisuseWarn(CommentHelper ch, Taglet taglet, DocTree tag, String holderType) {
        String[] locations;
        LinkedHashSet<String> locationsSet = new LinkedHashSet<String>();
        if (taglet.inOverview()) {
            locationsSet.add("overview");
        }
        if (taglet.inPackage()) {
            locationsSet.add("package");
        }
        if (taglet.inType()) {
            locationsSet.add("class/interface");
        }
        if (taglet.inConstructor()) {
            locationsSet.add("constructor");
        }
        if (taglet.inField()) {
            locationsSet.add("field");
        }
        if (taglet.inMethod()) {
            locationsSet.add("method");
        }
        if (taglet.isInlineTag()) {
            locationsSet.add("inline text");
        }
        if ((locations = locationsSet.toArray(new String[0])) == null || locations.length == 0) {
            return;
        }
        StringBuilder combined_locations = new StringBuilder();
        for (int i = 0; i < locations.length; ++i) {
            if (i > 0) {
                combined_locations.append(", ");
            }
            combined_locations.append(locations[i]);
        }
        this.message.warning(ch.getDocTreePath(tag), "doclet.tag_misuse", "@" + taglet.getName(), holderType, combined_locations.toString());
    }

    public List<Taglet> getPackageCustomTaglets() {
        if (this.packageTags == null) {
            this.initCustomTaglets();
        }
        return this.packageTags;
    }

    public List<Taglet> getTypeCustomTaglets() {
        if (this.typeTags == null) {
            this.initCustomTaglets();
        }
        return this.typeTags;
    }

    public List<Taglet> getInlineCustomTaglets() {
        if (this.inlineTags == null) {
            this.initCustomTaglets();
        }
        return this.inlineTags;
    }

    public List<Taglet> getFieldCustomTaglets() {
        if (this.fieldTags == null) {
            this.initCustomTaglets();
        }
        return this.fieldTags;
    }

    public List<Taglet> getSerializedFormTaglets() {
        if (this.serializedFormTags == null) {
            this.initCustomTaglets();
        }
        return this.serializedFormTags;
    }

    public List<Taglet> getCustomTaglets(Element e) {
        switch (e.getKind()) {
            case CONSTRUCTOR: {
                return this.getConstructorCustomTaglets();
            }
            case METHOD: {
                return this.getMethodCustomTaglets();
            }
            case ENUM_CONSTANT: 
            case FIELD: {
                return this.getFieldCustomTaglets();
            }
            case ANNOTATION_TYPE: 
            case INTERFACE: 
            case CLASS: 
            case ENUM: {
                return this.getTypeCustomTaglets();
            }
            case PACKAGE: {
                return this.getPackageCustomTaglets();
            }
            case OTHER: {
                return this.getOverviewCustomTaglets();
            }
        }
        throw new AssertionError((Object)("unknown element: " + e + " ,kind: " + (Object)((Object)e.getKind())));
    }

    public List<Taglet> getConstructorCustomTaglets() {
        if (this.constructorTags == null) {
            this.initCustomTaglets();
        }
        return this.constructorTags;
    }

    public List<Taglet> getMethodCustomTaglets() {
        if (this.methodTags == null) {
            this.initCustomTaglets();
        }
        return this.methodTags;
    }

    public List<Taglet> getOverviewCustomTaglets() {
        if (this.overviewTags == null) {
            this.initCustomTaglets();
        }
        return this.overviewTags;
    }

    private void initCustomTaglets() {
        this.packageTags = new ArrayList<Taglet>();
        this.typeTags = new ArrayList<Taglet>();
        this.fieldTags = new ArrayList<Taglet>();
        this.constructorTags = new ArrayList<Taglet>();
        this.methodTags = new ArrayList<Taglet>();
        this.inlineTags = new ArrayList<Taglet>();
        this.overviewTags = new ArrayList<Taglet>();
        for (Taglet current : this.customTags.values()) {
            if (current.inPackage() && !current.isInlineTag()) {
                this.packageTags.add(current);
            }
            if (current.inType() && !current.isInlineTag()) {
                this.typeTags.add(current);
            }
            if (current.inField() && !current.isInlineTag()) {
                this.fieldTags.add(current);
            }
            if (current.inConstructor() && !current.isInlineTag()) {
                this.constructorTags.add(current);
            }
            if (current.inMethod() && !current.isInlineTag()) {
                this.methodTags.add(current);
            }
            if (current.isInlineTag()) {
                this.inlineTags.add(current);
            }
            if (!current.inOverview() || current.isInlineTag()) continue;
            this.overviewTags.add(current);
        }
        this.serializedFormTags = new ArrayList<Taglet>();
        this.serializedFormTags.add(this.customTags.get(DocTree.Kind.SERIAL_DATA.tagName));
        this.serializedFormTags.add(this.customTags.get(DocTree.Kind.THROWS.tagName));
        if (!this.nosince) {
            this.serializedFormTags.add(this.customTags.get(DocTree.Kind.SINCE.tagName));
        }
        this.serializedFormTags.add(this.customTags.get(DocTree.Kind.SEE.tagName));
    }

    private void initStandardTaglets() {
        if (this.javafx) {
            this.initJavaFXTaglets();
        }
        this.addStandardTaglet(new ParamTaglet());
        this.addStandardTaglet(new ReturnTaglet());
        this.addStandardTaglet(new ThrowsTaglet());
        this.addStandardTaglet(new SimpleTaglet(DocTree.Kind.EXCEPTION.tagName, null, "mc"));
        this.addStandardTaglet(!this.nosince, new SimpleTaglet(DocTree.Kind.SINCE.tagName, this.message.getText("doclet.Since", new Object[0]), "a"));
        this.addStandardTaglet(this.showversion, new SimpleTaglet(DocTree.Kind.VERSION.tagName, this.message.getText("doclet.Version", new Object[0]), "pto"));
        this.addStandardTaglet(this.showauthor, new SimpleTaglet(DocTree.Kind.AUTHOR.tagName, this.message.getText("doclet.Author", new Object[0]), "pto"));
        this.addStandardTaglet(new SimpleTaglet(DocTree.Kind.SERIAL_DATA.tagName, this.message.getText("doclet.SerialData", new Object[0]), "x"));
        SimpleTaglet temp = new SimpleTaglet("factory", this.message.getText("doclet.Factory", new Object[0]), "m");
        this.customTags.put(temp.getName(), temp);
        this.addStandardTaglet(new SeeTaglet());
        this.addStandardTaglet(new DocRootTaglet());
        this.addStandardTaglet(new InheritDocTaglet());
        this.addStandardTaglet(new ValueTaglet());
        this.addStandardTaglet(new LiteralTaglet());
        this.addStandardTaglet(new CodeTaglet());
        this.addStandardTaglet(new IndexTaglet());
        this.standardTags.add(DocTree.Kind.DEPRECATED.tagName);
        this.standardTags.add(DocTree.Kind.LINK.tagName);
        this.standardTags.add(DocTree.Kind.LINK_PLAIN.tagName);
        this.standardTags.add(DocTree.Kind.SERIAL.tagName);
        this.standardTags.add(DocTree.Kind.SERIAL_FIELD.tagName);
    }

    private void initJavaFXTaglets() {
        this.addStandardTaglet(new PropertyGetterTaglet());
        this.addStandardTaglet(new PropertySetterTaglet());
        this.addStandardTaglet(new SimpleTaglet("propertyDescription", this.message.getText("doclet.PropertyDescription", new Object[0]), "fm"));
        this.addStandardTaglet(new SimpleTaglet("defaultValue", this.message.getText("doclet.DefaultValue", new Object[0]), "fm"));
        this.addStandardTaglet(new SimpleTaglet("treatAsPrivate", null, "fmt"));
    }

    void addStandardTaglet(Taglet taglet) {
        String name = taglet.getName();
        this.customTags.put(name, taglet);
        this.standardTags.add(name);
    }

    void addStandardTaglet(boolean enable, Taglet taglet) {
        String name = taglet.getName();
        if (enable) {
            this.customTags.put(name, taglet);
        }
        this.standardTags.add(name);
    }

    private void initStandardTagsLowercase() {
        for (String standardTag : this.standardTags) {
            this.standardTagsLowercase.add(Utils.toLowerCase(standardTag));
        }
    }

    public boolean isKnownCustomTag(String tagName) {
        return this.customTags.containsKey(tagName);
    }

    public void printReport() {
        this.printReportHelper("doclet.Notice_taglet_conflict_warn", this.potentiallyConflictingTags);
        this.printReportHelper("doclet.Notice_taglet_overriden", this.overridenStandardTags);
        this.printReportHelper("doclet.Notice_taglet_unseen", this.unseenCustomTags);
    }

    private void printReportHelper(String noticeKey, Set<String> names) {
        if (names.size() > 0) {
            String[] namesArray = names.toArray(new String[0]);
            String result = " ";
            for (int i = 0; i < namesArray.length; ++i) {
                result = result + "@" + namesArray[i];
                if (i + 1 >= namesArray.length) continue;
                result = result + ", ";
            }
            this.message.notice(noticeKey, result);
        }
    }

    public Taglet getTaglet(String name) {
        if (name.indexOf("@") == 0) {
            return this.customTags.get(name.substring(1));
        }
        return this.customTags.get(name);
    }
}

