/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.openjdk.source.util.DocTrees;
import org.openjdk.source.util.TreePath;
import org.openjdk.tools.javac.api.JavacTrees;
import org.openjdk.tools.javac.code.ClassFinder;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.Check;
import org.openjdk.tools.javac.comp.Enter;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.file.JavacFileManager;
import org.openjdk.tools.javac.model.JavacElements;
import org.openjdk.tools.javac.model.JavacTypes;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javadoc.internal.tool.JavadocClassFinder;
import org.openjdk.tools.javadoc.internal.tool.JavadocEnter;
import org.openjdk.tools.javadoc.internal.tool.JavadocTool;
import org.openjdk.tools.javadoc.internal.tool.Messager;
import org.openjdk.tools.javadoc.internal.tool.RootDocImpl;

public class DocEnv {
    protected static final Context.Key<DocEnv> docEnvKey = new Context.Key();
    private final Messager messager;
    public final Symtab syms;
    private final ClassFinder finder;
    final Enter enter;
    private Names names;
    private String encoding;
    final Symbol externalizableSym;
    protected ModifierFilter filter;
    boolean quiet = false;
    Check chk;
    Types types;
    JavaFileManager fileManager;
    public final Context context;
    WeakHashMap<JCTree, TreePath> treePaths = new WeakHashMap();
    public final HashMap<PackageElement, JavaFileObject> pkgToJavaFOMap = new HashMap();
    boolean docClasses = false;
    public final Source source;
    public final Elements elements;
    public final JavacTypes typeutils;
    protected RootDocImpl root;
    public final DocTrees docTrees;
    public final Map<Element, TreePath> elementToTreePath;
    SimpleElementVisitor9<Boolean, Void> shouldDocumentVisitor = null;
    private final Set<Element> includedSet = new HashSet<Element>();
    private SimpleElementVisitor9<Boolean, Void> includedVisitor = null;

    public static DocEnv instance(Context context) {
        DocEnv instance = context.get(docEnvKey);
        if (instance == null) {
            instance = new DocEnv(context);
        }
        return instance;
    }

    protected DocEnv(Context context) {
        context.put(docEnvKey, this);
        this.context = context;
        this.messager = Messager.instance0(context);
        this.syms = Symtab.instance(context);
        this.finder = JavadocClassFinder.instance(context);
        this.enter = JavadocEnter.instance(context);
        this.names = Names.instance(context);
        this.externalizableSym = this.syms.enterClass(this.names.fromString("java.io.Externalizable"));
        this.chk = Check.instance(context);
        this.types = Types.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).setSymbolFileEnabled(false);
        }
        this.docTrees = JavacTrees.instance(context);
        this.source = Source.instance(context);
        this.elements = JavacElements.instance(context);
        this.typeutils = JavacTypes.instance(context);
        this.elementToTreePath = new HashMap<Element, TreePath>();
    }

    public void intialize(String encoding, String showAccess, String overviewpath, List<String> javaNames, Iterable<? extends JavaFileObject> fileObjects, List<String> subPackages, List<String> excludedPackages, boolean docClasses, boolean quiet) {
        this.filter = ModifierFilter.getModifierFilter(showAccess);
        this.quiet = quiet;
        this.setEncoding(encoding);
        this.docClasses = docClasses;
    }

    public TypeElement loadClass(String name) {
        try {
            Symbol.ClassSymbol c = this.finder.loadClass(this.names.fromString(name));
            return c;
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(null, ex);
            return null;
        }
    }

    private boolean isSynthetic(long flags) {
        return (flags & 0x1000L) != 0L;
    }

    private boolean isSynthetic(Symbol sym) {
        return this.isSynthetic(sym.flags_field);
    }

    public boolean shouldDocument(Element e) {
        if (this.shouldDocumentVisitor == null) {
            this.shouldDocumentVisitor = new SimpleElementVisitor9<Boolean, Void>(){

                @Override
                public Boolean visitType(TypeElement e, Void p) {
                    return DocEnv.this.shouldDocument((Symbol.ClassSymbol)e);
                }

                @Override
                public Boolean visitVariable(VariableElement e, Void p) {
                    return DocEnv.this.shouldDocument((Symbol.VarSymbol)e);
                }

                @Override
                public Boolean visitExecutable(ExecutableElement e, Void p) {
                    return DocEnv.this.shouldDocument((Symbol.MethodSymbol)e);
                }
            };
        }
        return (Boolean)this.shouldDocumentVisitor.visit(e);
    }

    public boolean shouldDocument(Symbol.VarSymbol sym) {
        long mod = sym.flags();
        if (this.isSynthetic(mod)) {
            return false;
        }
        return this.filter.checkModifier(DocEnv.translateModifiers(mod));
    }

    public boolean shouldDocument(Symbol.MethodSymbol sym) {
        long mod = sym.flags();
        if (this.isSynthetic(mod)) {
            return false;
        }
        return this.filter.checkModifier(DocEnv.translateModifiers(mod));
    }

    void setElementToTreePath(Element e, TreePath tree) {
        if (e == null || tree == null) {
            return;
        }
        this.elementToTreePath.put(e, tree);
    }

    private boolean hasLeaf(Symbol.ClassSymbol sym) {
        TreePath path = this.elementToTreePath.get(sym);
        if (path == null) {
            return false;
        }
        return path.getLeaf() != null;
    }

    public boolean shouldDocument(Symbol.ClassSymbol sym) {
        return !this.isSynthetic(sym.flags_field) && (this.docClasses || this.hasLeaf(sym)) && this.isVisible(sym);
    }

    public boolean isVisible(Symbol.ClassSymbol sym) {
        long mod = sym.flags_field;
        if (!this.filter.checkModifier(DocEnv.translateModifiers(mod))) {
            return false;
        }
        Symbol.ClassSymbol encl = sym.owner.enclClass();
        return encl == null || (mod & 8L) != 0L || this.isVisible(encl);
    }

    public void printError(String msg) {
        this.messager.printError(msg);
    }

    public void error(Element element, String key, String ... args) {
        if (element == null) {
            this.messager.error(key, args);
        } else {
            this.messager.error(element, key, (Object[])args);
        }
    }

    public void warning(String key, String ... args) {
        this.warning((Element)null, key, args);
    }

    public void warning(Element e, String key, String ... args) {
        if (e == null) {
            this.messager.warning(key, args);
        } else {
            this.messager.warning(e, key, (Object[])args);
        }
    }

    public void notice(String key) {
        if (this.quiet) {
            return;
        }
        this.messager.notice(key, new Object[0]);
    }

    public void notice(String key, String a1) {
        if (this.quiet) {
            return;
        }
        this.messager.notice(key, a1);
    }

    public void exit() {
        this.messager.exit();
    }

    void addAllClasses(Collection<TypeElement> list, TypeElement typeElement, boolean filtered) {
        Symbol.ClassSymbol klass = (Symbol.ClassSymbol)typeElement;
        try {
            if (this.isSynthetic(klass.flags())) {
                return;
            }
            if (!JavadocTool.isValidClassName(klass.name.toString())) {
                return;
            }
            if (filtered && !this.shouldDocument(klass)) {
                return;
            }
            if (list.contains(klass)) {
                return;
            }
            list.add(klass);
            for (Symbol sym : klass.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                Symbol.ClassSymbol s;
                if (sym == null || sym.kind != Kinds.Kind.TYP || this.isSynthetic((s = (Symbol.ClassSymbol)sym).flags())) continue;
                this.addAllClasses(list, s, filtered);
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            // empty catch block
        }
    }

    void addAllClasses(Collection<TypeElement> list, PackageElement pkg) {
        boolean filtered = true;
        Symbol.PackageSymbol sym = (Symbol.PackageSymbol)pkg;
        for (Symbol isym : sym.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            Symbol.ClassSymbol s;
            if (isym == null || this.isSynthetic(s = (Symbol.ClassSymbol)isym)) continue;
            this.addAllClasses(list, s, filtered);
        }
    }

    TreePath getTreePath(JCTree.JCCompilationUnit tree) {
        TreePath p = this.treePaths.get(tree);
        if (p == null) {
            p = new TreePath(tree);
            this.treePaths.put(tree, p);
        }
        return p;
    }

    TreePath getTreePath(JCTree.JCCompilationUnit toplevel, JCTree.JCPackageDecl tree) {
        TreePath p = this.treePaths.get(tree);
        if (p == null) {
            p = new TreePath(this.getTreePath(toplevel), tree);
            this.treePaths.put(tree, p);
        }
        return p;
    }

    TreePath getTreePath(JCTree.JCCompilationUnit toplevel, JCTree.JCClassDecl tree) {
        TreePath p = this.treePaths.get(tree);
        if (p == null) {
            p = new TreePath(this.getTreePath(toplevel), tree);
            this.treePaths.put(tree, p);
        }
        return p;
    }

    TreePath getTreePath(JCTree.JCCompilationUnit toplevel, JCTree.JCClassDecl cdecl, JCTree tree) {
        return new TreePath(this.getTreePath(toplevel, cdecl), tree);
    }

    public Types getTypes() {
        return this.types;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Env<AttrContext> getEnv(Symbol.ClassSymbol tsym) {
        return this.enter.getEnv(tsym);
    }

    public String getEncoding() {
        return this.encoding;
    }

    static int translateModifiers(long flags) {
        int result = 0;
        if ((flags & 0x400L) != 0L) {
            result |= 0x400;
        }
        if ((flags & 0x10L) != 0L) {
            result |= 0x10;
        }
        if ((flags & 0x200L) != 0L) {
            result |= 0x200;
        }
        if ((flags & 0x100L) != 0L) {
            result |= 0x100;
        }
        if ((flags & 2L) != 0L) {
            result |= 2;
        }
        if ((flags & 4L) != 0L) {
            result |= 4;
        }
        if ((flags & 1L) != 0L) {
            result |= 1;
        }
        if ((flags & 8L) != 0L) {
            result |= 8;
        }
        if ((flags & 0x20L) != 0L) {
            result |= 0x20;
        }
        if ((flags & 0x80L) != 0L) {
            result |= 0x80;
        }
        if ((flags & 0x40L) != 0L) {
            result |= 0x40;
        }
        return result;
    }

    public void setIncluded(Element element) {
        this.includedSet.add(element);
    }

    public boolean isIncluded(Element e) {
        if (e == null) {
            return false;
        }
        if (this.includedVisitor == null) {
            this.includedVisitor = new SimpleElementVisitor9<Boolean, Void>(){

                @Override
                public Boolean visitType(TypeElement e, Void p) {
                    if (DocEnv.this.includedSet.contains(e)) {
                        return true;
                    }
                    if (DocEnv.this.shouldDocument(e)) {
                        PackageElement pkg = DocEnv.this.elements.getPackageOf(e);
                        if (DocEnv.this.includedSet.contains(pkg)) {
                            DocEnv.this.setIncluded(e);
                            return true;
                        }
                        Element enclosing = e.getEnclosingElement();
                        if (enclosing != null && DocEnv.this.includedSet.contains(enclosing)) {
                            DocEnv.this.setIncluded(e);
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Boolean visitPackage(PackageElement e, Void p) {
                    return DocEnv.this.includedSet.contains(e);
                }

                @Override
                public Boolean visitUnknown(Element e, Void p) {
                    throw new AssertionError((Object)("unknown element: " + e));
                }

                @Override
                public Boolean defaultAction(Element e, Void p) {
                    return (Boolean)this.visit(e.getEnclosingElement()) != false && DocEnv.this.shouldDocument(e);
                }
            };
        }
        return (Boolean)this.includedVisitor.visit(e);
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    private static class ModifierFilter {
        private Set<FilterFlag> oneOf;

        ModifierFilter(Set<FilterFlag> oneOf) {
            this.oneOf = oneOf;
        }

        ModifierFilter(FilterFlag ... oneOf) {
            this.oneOf = new HashSet<FilterFlag>();
            this.oneOf.addAll(Arrays.asList(oneOf));
        }

        static ModifierFilter getModifierFilter(String showAccess) {
            switch (showAccess) {
                case "public": {
                    return new ModifierFilter(FilterFlag.PUBLIC);
                }
                case "package": {
                    return new ModifierFilter(FilterFlag.PUBLIC, FilterFlag.PROTECTED, FilterFlag.PACKAGE);
                }
                case "private": {
                    return new ModifierFilter(FilterFlag.PRIVATE);
                }
            }
            return new ModifierFilter(FilterFlag.PUBLIC, FilterFlag.PROTECTED);
        }

        private boolean hasFlag(long flag, long modifierBits) {
            return (flag & modifierBits) != 0L;
        }

        private List<FilterFlag> flagsToModifiers(long modifierBits) {
            ArrayList<FilterFlag> list = new ArrayList<FilterFlag>();
            boolean isPackage = true;
            if (this.hasFlag(2L, modifierBits)) {
                list.add(FilterFlag.PRIVATE);
                isPackage = false;
            }
            if (this.hasFlag(4L, modifierBits)) {
                list.add(FilterFlag.PROTECTED);
                isPackage = false;
            }
            if (this.hasFlag(1L, modifierBits)) {
                list.add(FilterFlag.PUBLIC);
                isPackage = false;
            }
            if (isPackage) {
                list.add(FilterFlag.PACKAGE);
            }
            return list;
        }

        public boolean checkModifier(int modifierBits) {
            return this.checkModifier(this.flagsToModifiers(modifierBits));
        }

        public boolean checkModifier(List<FilterFlag> modifiers) {
            if (this.oneOf.contains((Object)FilterFlag.PRIVATE)) {
                return true;
            }
            for (FilterFlag mod : modifiers) {
                if (!this.oneOf.contains((Object)mod)) continue;
                return true;
            }
            return false;
        }

        static enum FilterFlag {
            PACKAGE,
            PRIVATE,
            PROTECTED,
            PUBLIC;

        }
    }
}

