/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.routing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.twitter.finagle.NoBrokersAvailableException;
import com.twitter.finagle.stats.NullStatsReceiver;
import com.twitter.finagle.stats.StatsReceiver;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.apache.distributedlog.client.resolver.RegionResolver;
import org.apache.distributedlog.client.routing.RoutingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionsRoutingService
implements RoutingService {
    private static final Logger logger = LoggerFactory.getLogger(RegionsRoutingService.class);
    protected final RegionResolver regionResolver;
    protected final RoutingService[] routingServices;

    @Deprecated
    public static RegionsRoutingService of(RegionResolver regionResolver, RoutingService ... services) {
        return new RegionsRoutingService(regionResolver, services);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private RegionsRoutingService(RegionResolver resolver, RoutingService[] routingServices) {
        this.regionResolver = resolver;
        this.routingServices = routingServices;
    }

    @Override
    public Set<SocketAddress> getHosts() {
        HashSet hosts = Sets.newHashSet();
        for (RoutingService rs : this.routingServices) {
            hosts.addAll(rs.getHosts());
        }
        return hosts;
    }

    @Override
    public void startService() {
        for (RoutingService service : this.routingServices) {
            service.startService();
        }
        logger.info("Regions Routing Service Started");
    }

    @Override
    public void stopService() {
        for (RoutingService service : this.routingServices) {
            service.stopService();
        }
        logger.info("Regions Routing Service Stopped");
    }

    @Override
    public RoutingService registerListener(RoutingService.RoutingListener listener) {
        for (RoutingService service : this.routingServices) {
            service.registerListener(listener);
        }
        return this;
    }

    @Override
    public RoutingService unregisterListener(RoutingService.RoutingListener listener) {
        for (RoutingService service : this.routingServices) {
            service.registerListener(listener);
        }
        return this;
    }

    @Override
    public SocketAddress getHost(String key, RoutingService.RoutingContext routingContext) throws NoBrokersAvailableException {
        for (RoutingService service : this.routingServices) {
            try {
                String region;
                SocketAddress addr = service.getHost(key, routingContext);
                if (routingContext.hasUnavailableRegions() && routingContext.isUnavailableRegion(region = this.regionResolver.resolveRegion(addr)) || routingContext.isTriedHost(addr)) continue;
                return addr;
            }
            catch (NoBrokersAvailableException nbae) {
                logger.debug("No brokers available in region {} : ", (Object)service, (Object)nbae);
            }
        }
        throw new NoBrokersAvailableException("No host found for " + key + ", routing context : " + routingContext);
    }

    @Override
    public void removeHost(SocketAddress address, Throwable reason) {
        for (RoutingService service : this.routingServices) {
            service.removeHost(address, reason);
        }
    }

    public static class Builder
    implements RoutingService.Builder {
        private RegionResolver resolver;
        private RoutingService.Builder[] routingServiceBuilders;
        private StatsReceiver statsReceiver = NullStatsReceiver.get();

        private Builder() {
        }

        public Builder routingServiceBuilders(RoutingService.Builder ... builders) {
            this.routingServiceBuilders = builders;
            return this;
        }

        public Builder resolver(RegionResolver regionResolver) {
            this.resolver = regionResolver;
            return this;
        }

        @Override
        public RoutingService.Builder statsReceiver(StatsReceiver statsReceiver) {
            this.statsReceiver = statsReceiver;
            return this;
        }

        @Override
        public RegionsRoutingService build() {
            Preconditions.checkNotNull((Object)this.routingServiceBuilders, (Object)"No routing service builder provided.");
            Preconditions.checkNotNull((Object)this.resolver, (Object)"No region resolver provided.");
            Preconditions.checkNotNull((Object)this.statsReceiver, (Object)"No stats receiver provided");
            RoutingService[] services = new RoutingService[this.routingServiceBuilders.length];
            for (int i = 0; i < services.length; ++i) {
                String statsScope = 0 == i ? "local" : "remote_" + i;
                services[i] = this.routingServiceBuilders[i].statsReceiver(this.statsReceiver.scope(statsScope)).build();
            }
            return new RegionsRoutingService(this.resolver, services);
        }
    }
}

