/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.balancer;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import com.twitter.common.zookeeper.ServerSet;
import com.twitter.finagle.builder.ClientBuilder;
import com.twitter.finagle.thrift.ClientId$;
import com.twitter.util.Await;
import com.twitter.util.Awaitable;
import com.twitter.util.Duration;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.client.monitor.MonitorServiceClient;
import org.apache.distributedlog.client.serverset.DLZkServerSet;
import org.apache.distributedlog.service.ClientUtils;
import org.apache.distributedlog.service.DLSocketAddress;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.service.DistributedLogClientBuilder;
import org.apache.distributedlog.service.balancer.ClusterBalancer;
import org.apache.distributedlog.service.balancer.SimpleBalancer;
import org.apache.distributedlog.tools.Tool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancerTool
extends Tool {
    private static final Logger logger = LoggerFactory.getLogger(BalancerTool.class);

    static DistributedLogClientBuilder createDistributedLogClientBuilder(ServerSet serverSet) {
        return DistributedLogClientBuilder.newBuilder().name("rebalancer_tool").clientId(ClientId$.MODULE$.apply("rebalancer_tool")).maxRedirects(2).serverSet(serverSet).clientBuilder(ClientBuilder.get().connectionTimeout(Duration.fromSeconds((int)2)).tcpConnectTimeout(Duration.fromSeconds((int)2)).requestTimeout(Duration.fromSeconds((int)10)).hostConnectionLimit(1).hostConnectionCoresize(1).keepAlive(true).failFast(false));
    }

    public BalancerTool() {
        this.addCommand((Tool.Command)new ClusterBalancerCommand());
        this.addCommand((Tool.Command)new RegionBalancerCommand());
    }

    protected String getName() {
        return "balancer";
    }

    protected static class RegionBalancerCommand
    extends BalancerCommand {
        protected URI region1;
        protected URI region2;
        protected String source = null;

        protected RegionBalancerCommand() {
            super("regionbalancer", "Balance streams between regions");
            this.options.addOption("rs", "regions", true, "DistributedLog Region URI: uri1[,uri2]");
            this.options.addOption("s", "source", true, "DistributedLog Source Region to balance");
        }

        protected String getUsage() {
            return "regionbalancer [options]";
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (!cmdline.hasOption("rs")) {
                throw new ParseException("No regions provided.");
            }
            String regionsStr = cmdline.getOptionValue("rs");
            String[] regions = regionsStr.split(",");
            if (regions.length != 2) {
                throw new ParseException("Invalid regions provided. Expected : serverset1[,serverset2]");
            }
            this.region1 = URI.create(regions[0]);
            this.region2 = URI.create(regions[1]);
            if (cmdline.hasOption("s")) {
                this.source = cmdline.getOptionValue("s");
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        protected int executeCommand(CommandLine cmdline) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected int runBalancer(SimpleBalancer balancer) throws Exception {
            if (null == this.source) {
                balancer.balance(this.rebalanceWaterMark, this.rebalanceTolerancePercentage, this.rebalanceConcurrency, this.getRateLimiter());
            } else {
                balancer.balanceAll(this.source, this.rebalanceConcurrency, this.getRateLimiter());
            }
            return 0;
        }
    }

    protected static class ClusterBalancerCommand
    extends BalancerCommand {
        protected URI uri;
        protected String source = null;

        protected ClusterBalancerCommand() {
            super("clusterbalancer", "Balance streams inside a cluster");
            this.options.addOption("u", "uri", true, "DistributedLog URI");
            this.options.addOption("sp", "source-proxy", true, "Source proxy to balance");
        }

        protected String getUsage() {
            return "clusterbalancer [options]";
        }

        @Override
        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            super.parseCommandLine(cmdline);
            if (!cmdline.hasOption("u")) {
                throw new ParseException("No proxy serverset provided.");
            }
            this.uri = URI.create(cmdline.getOptionValue("u"));
            if (cmdline.hasOption("sp")) {
                String sourceProxyStr = cmdline.getOptionValue("sp");
                try {
                    DLSocketAddress.parseSocketAddress((String)sourceProxyStr);
                }
                catch (IllegalArgumentException iae) {
                    throw new ParseException("Invalid source proxy " + sourceProxyStr + " : " + iae.getMessage());
                }
                this.source = sourceProxyStr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int executeCommand(CommandLine cmdline) throws Exception {
            logger.info("Created serverset for {}", (Object)this.uri);
            try (DLZkServerSet serverSet = DLZkServerSet.of((URI)this.uri, (int)60000);){
                DistributedLogClientBuilder clientBuilder = BalancerTool.createDistributedLogClientBuilder(serverSet.getServerSet());
                ClusterBalancer balancer = new ClusterBalancer(clientBuilder);
                try {
                    int n = this.runBalancer(clientBuilder, balancer);
                    balancer.close();
                    return n;
                }
                catch (Throwable throwable) {
                    balancer.close();
                    throw throwable;
                }
            }
        }

        protected int runBalancer(DistributedLogClientBuilder clientBuilder, ClusterBalancer balancer) throws Exception {
            if (null == this.source) {
                balancer.balance(this.rebalanceWaterMark, this.rebalanceTolerancePercentage, this.rebalanceConcurrency, this.getRateLimiter());
            } else {
                this.balanceFromSource(clientBuilder, balancer, this.source, this.getRateLimiter());
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void balanceFromSource(DistributedLogClientBuilder clientBuilder, ClusterBalancer balancer, String source, Optional<RateLimiter> rateLimiter) throws Exception {
            InetSocketAddress sourceAddr = DLSocketAddress.parseSocketAddress((String)source);
            DistributedLogClientBuilder sourceClientBuilder = DistributedLogClientBuilder.newBuilder((DistributedLogClientBuilder)clientBuilder).host((SocketAddress)sourceAddr);
            Pair<DistributedLogClient, MonitorServiceClient> clientPair = ClientUtils.buildClient(sourceClientBuilder);
            try {
                Await.result((Awaitable)((MonitorServiceClient)clientPair.getRight()).setAcceptNewStream(false));
                logger.info("Disable accepting new stream on proxy {}.", (Object)source);
                balancer.balanceAll(source, this.rebalanceConcurrency, rateLimiter);
            }
            finally {
                ((DistributedLogClient)clientPair.getLeft()).close();
            }
        }
    }

    protected static abstract class BalancerCommand
    extends Tool.OptsCommand {
        protected Options options = new Options();
        protected int rebalanceWaterMark = 0;
        protected double rebalanceTolerancePercentage = 0.0;
        protected int rebalanceConcurrency = 1;
        protected Double rate = null;
        protected Optional<RateLimiter> rateLimiter;

        BalancerCommand(String name, String description) {
            super(name, description);
            this.options.addOption("rwm", "rebalance-water-mark", true, "Rebalance water mark per proxy");
            this.options.addOption("rtp", "rebalance-tolerance-percentage", true, "Rebalance tolerance percentage per proxy");
            this.options.addOption("rc", "rebalance-concurrency", true, "Concurrency to rebalance stream distribution");
            this.options.addOption("r", "rate", true, "Rebalance rate");
        }

        Optional<RateLimiter> getRateLimiter() {
            return this.rateLimiter;
        }

        protected Options getOptions() {
            return this.options;
        }

        protected void parseCommandLine(CommandLine cmdline) throws ParseException {
            if (cmdline.hasOption("rwm")) {
                this.rebalanceWaterMark = Integer.parseInt(cmdline.getOptionValue("rwm"));
            }
            if (cmdline.hasOption("rtp")) {
                this.rebalanceTolerancePercentage = Double.parseDouble(cmdline.getOptionValue("rtp"));
            }
            if (cmdline.hasOption("rc")) {
                this.rebalanceConcurrency = Integer.parseInt(cmdline.getOptionValue("rc"));
            }
            if (cmdline.hasOption("r")) {
                this.rate = Double.parseDouble(cmdline.getOptionValue("r"));
            }
            Preconditions.checkArgument((this.rebalanceWaterMark >= 0 ? 1 : 0) != 0, (Object)"Rebalance Water Mark should be a non-negative number");
            Preconditions.checkArgument((this.rebalanceTolerancePercentage >= 0.0 ? 1 : 0) != 0, (Object)"Rebalance Tolerance Percentage should be a non-negative number");
            Preconditions.checkArgument((this.rebalanceConcurrency > 0 ? 1 : 0) != 0, (Object)"Rebalance Concurrency should be a positive number");
            this.rateLimiter = null == this.rate || this.rate <= 0.0 ? Optional.absent() : Optional.of((Object)RateLimiter.create((double)this.rate));
        }

        protected int runCmd(CommandLine cmdline) throws Exception {
            try {
                this.parseCommandLine(cmdline);
            }
            catch (ParseException pe) {
                BalancerTool.println((String)("ERROR: fail to parse commandline : '" + pe.getMessage() + "'"));
                this.printUsage();
                return -1;
            }
            return this.executeCommand(cmdline);
        }

        protected abstract int executeCommand(CommandLine var1) throws Exception;
    }
}

