/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.balancer;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.service.balancer.StreamChooser;

class CountBasedStreamChooser
implements StreamChooser,
Serializable,
Comparator<Pair<SocketAddress, LinkedList<String>>> {
    private static final long serialVersionUID = 4664153397369979203L;
    final List<Pair<SocketAddress, LinkedList<String>>> streamsDistribution;
    int pivot;
    int pivotCount;
    int next;

    CountBasedStreamChooser(Map<SocketAddress, Set<String>> streams) {
        Preconditions.checkArgument((streams.size() > 0 ? 1 : 0) != 0, (Object)"Only support no-empty streams distribution");
        this.streamsDistribution = new ArrayList<Pair<SocketAddress, LinkedList<String>>>(streams.size());
        for (Map.Entry<SocketAddress, Set<String>> entry : streams.entrySet()) {
            LinkedList randomizedStreams = new LinkedList(entry.getValue());
            Collections.shuffle(randomizedStreams);
            this.streamsDistribution.add((Pair<SocketAddress, LinkedList<String>>)Pair.of((Object)entry.getKey(), randomizedStreams));
        }
        Collections.sort(this.streamsDistribution, this);
        this.pivot = 0;
        this.pivotCount = ((LinkedList)this.streamsDistribution.get(0).getValue()).size();
        this.findNextPivot();
        this.next = 0;
    }

    private void findNextPivot() {
        int prevPivotCount = this.pivotCount;
        while (++this.pivot < this.streamsDistribution.size()) {
            this.pivotCount = ((LinkedList)this.streamsDistribution.get(this.pivot).getValue()).size();
            if (this.pivotCount >= prevPivotCount) continue;
            return;
        }
        this.pivot = this.streamsDistribution.size();
        this.pivotCount = 0;
    }

    @Override
    public synchronized String choose() {
        LinkedList nextStreams;
        if (this.next == this.pivot) {
            if (((LinkedList)this.streamsDistribution.get(this.next - 1).getRight()).size() > this.pivotCount) {
                this.next = 0;
            } else {
                if (this.pivotCount == 0) {
                    return null;
                }
                this.findNextPivot();
                this.next = 0;
            }
        }
        if ((nextStreams = (LinkedList)this.streamsDistribution.get(this.next).getRight()).size() == 0) {
            return null;
        }
        String chosenStream = (String)nextStreams.remove();
        ++this.next;
        return chosenStream;
    }

    @Override
    public int compare(Pair<SocketAddress, LinkedList<String>> o1, Pair<SocketAddress, LinkedList<String>> o2) {
        return ((LinkedList)o2.getValue()).size() - ((LinkedList)o1.getValue()).size();
    }
}

