/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.entity;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.util.collections.MutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySpec<T extends Entity>
extends AbstractBrooklynObjectSpec<T, EntitySpec<T>> {
    private static final long serialVersionUID = -2247153452919128990L;
    private static final Logger LOG = LoggerFactory.getLogger(EntitySpec.class);
    private Class<? extends T> impl;
    private Entity parent;
    private final List<PolicySpec<?>> policySpecs = Lists.newArrayList();
    private final List<EnricherSpec<?>> enricherSpecs = Lists.newArrayList();
    private final List<Location> locations = Lists.newArrayList();
    private final List<LocationSpec<?>> locationSpecs = Lists.newArrayList();
    private final Set<Class<?>> additionalInterfaces = Sets.newLinkedHashSet();
    private final List<EntityInitializer> entityInitializers = Lists.newArrayList();
    private final List<EntitySpec<?>> children = Lists.newArrayList();
    private final List<Entity> members = Lists.newArrayList();
    private final List<Group> groups = Lists.newArrayList();
    private volatile boolean immutable;
    private List<Policy> policies;
    private List<Enricher> enrichers;

    public static <T extends Entity> EntitySpec<T> create(Class<T> type) {
        return new EntitySpec<T>(type);
    }

    public static <T extends Entity, U extends T> EntitySpec<T> create(Class<T> type, Class<U> implType) {
        return new EntitySpec<U>(type).impl(implType);
    }

    public static <T extends Entity> EntitySpec<T> create(Map<?, ?> config, Class<T> type) {
        return (EntitySpec)EntitySpec.create(type).configure(config);
    }

    public static <T extends Entity> EntitySpec<T> create(EntitySpec<T> spec) {
        return EntitySpec.create(spec.getType()).copyFrom(spec);
    }

    public static <T extends Entity> EntitySpec<T> newInstance(Class<T> type) {
        return new EntitySpec<T>(type);
    }

    public EntitySpec(Class<T> type) {
        super(type);
    }

    @Override
    protected Object readResolve() {
        if (this.policies != null && this.policies.size() > 0) {
            LOG.warn("NOT SUPPORTED: EntitySpec " + this + " has hard-coded policies, rather than use of PolicySpec - policies will be ignored (" + this.policies + ")");
            this.policies = null;
        }
        if (this.enrichers != null && this.enrichers.size() > 0) {
            LOG.warn("NOT SUPPORTED: EntitySpec " + this + " has hard-coded enrichers, rather than use of EnricherSpec - enrichers will be ignored (" + this.enrichers + ")");
            this.enrichers = null;
        }
        return super.readResolve();
    }

    @Override
    protected EntitySpec<T> copyFrom(EntitySpec<T> otherSpec) {
        super.copyFrom(otherSpec).additionalInterfaces(otherSpec.getAdditionalInterfaces()).policySpecs(otherSpec.getPolicySpecs()).enricherSpecs(otherSpec.getEnricherSpecs()).addInitializers(otherSpec.getInitializers()).children(this.copyFromSpecs(otherSpec.getChildren())).members(otherSpec.getMembers()).groups(otherSpec.getGroups()).locationSpecs(otherSpec.getLocationSpecs()).locations(otherSpec.getLocations());
        if (otherSpec.getParent() != null) {
            this.parent(otherSpec.getParent());
        }
        if (otherSpec.getImplementation() != null) {
            this.impl(otherSpec.getImplementation());
        }
        return this;
    }

    private List<EntitySpec<?>> copyFromSpecs(List<EntitySpec<?>> children) {
        return Lists.transform(children, (Function)new Function<EntitySpec<?>, EntitySpec<?>>(){

            @Nullable
            public EntitySpec<?> apply(@Nullable EntitySpec<?> entitySpec) {
                return EntitySpec.create(entitySpec);
            }
        });
    }

    @Override
    public Class<T> getType() {
        return super.getType();
    }

    @Override
    protected void checkValidType(Class<? extends T> type) {
    }

    @Nullable
    public Class<? extends T> getImplementation() {
        return this.impl;
    }

    public Set<Class<?>> getAdditionalInterfaces() {
        return this.additionalInterfaces;
    }

    public List<EntityInitializer> getInitializers() {
        return this.entityInitializers;
    }

    public List<EntitySpec<?>> getChildren() {
        return this.children;
    }

    public List<Entity> getMembers() {
        return this.members;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public Entity getParent() {
        return this.parent;
    }

    public List<PolicySpec<?>> getPolicySpecs() {
        return this.policySpecs;
    }

    public List<EnricherSpec<?>> getEnricherSpecs() {
        return this.enricherSpecs;
    }

    public List<LocationSpec<?>> getLocationSpecs() {
        return this.locationSpecs;
    }

    @Deprecated
    public List<Location> getLocations() {
        return this.locations;
    }

    public EntitySpec<T> impl(Class<? extends T> val) {
        this.checkMutable();
        this.checkIsImplementation((Class)Preconditions.checkNotNull(val, (Object)"impl"), this.getType());
        this.checkIsNewStyleImplementation(val);
        this.impl = val;
        return this;
    }

    public EntitySpec<T> additionalInterfaces(Class<?> ... vals) {
        this.checkMutable();
        for (Class<?> val : vals) {
            this.additionalInterfaces.add(val);
        }
        return this;
    }

    public EntitySpec<T> additionalInterfaces(Iterable<Class<?>> val) {
        this.checkMutable();
        this.additionalInterfaces.addAll(Sets.newLinkedHashSet(val));
        return this;
    }

    public EntitySpec<T> addInitializer(EntityInitializer initializer) {
        this.checkMutable();
        this.entityInitializers.add(initializer);
        return this;
    }

    public EntitySpec<T> addInitializers(Iterable<? extends EntityInitializer> initializers) {
        this.checkMutable();
        Iterables.addAll(this.entityInitializers, initializers);
        return this;
    }

    public EntitySpec<T> addInitializer(Class<? extends EntityInitializer> initializerType) {
        this.checkMutable();
        try {
            this.entityInitializers.add(initializerType.newInstance());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    public EntitySpec<T> children(Iterable<? extends EntitySpec<?>> children) {
        this.checkMutable();
        Iterables.addAll(this.children, children);
        return this;
    }

    public EntitySpec<T> child(EntitySpec<?> child) {
        this.checkMutable();
        this.children.add(child);
        return this;
    }

    public EntitySpec<T> members(Iterable<? extends Entity> members) {
        this.checkMutable();
        Iterables.addAll(this.members, members);
        return this;
    }

    public EntitySpec<T> member(Entity member) {
        this.checkMutable();
        this.members.add(member);
        return this;
    }

    public EntitySpec<T> groups(Iterable<? extends Group> groups) {
        this.checkMutable();
        Iterables.addAll(this.groups, groups);
        return this;
    }

    public EntitySpec<T> group(Group group) {
        this.checkMutable();
        this.groups.add(group);
        return this;
    }

    public EntitySpec<T> parent(Entity val) {
        this.checkMutable();
        this.parent = (Entity)Preconditions.checkNotNull((Object)val, (Object)"parent");
        return this;
    }

    public <V> EntitySpec<T> policy(PolicySpec<?> val) {
        this.checkMutable();
        this.policySpecs.add((PolicySpec<?>)Preconditions.checkNotNull(val, (Object)"policySpec"));
        return this;
    }

    public <V> EntitySpec<T> policySpecs(Iterable<? extends PolicySpec<?>> val) {
        this.checkMutable();
        this.policySpecs.addAll((Collection<PolicySpec<?>>)MutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(val, (Object)"policySpecs"))));
        return this;
    }

    public <V> EntitySpec<T> enricher(EnricherSpec<?> val) {
        this.checkMutable();
        this.enricherSpecs.add((EnricherSpec<?>)Preconditions.checkNotNull(val, (Object)"enricherSpec"));
        return this;
    }

    public <V> EntitySpec<T> enricherSpecs(Iterable<? extends EnricherSpec<?>> val) {
        this.checkMutable();
        this.enricherSpecs.addAll((Collection<EnricherSpec<?>>)MutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(val, (Object)"enricherSpecs"))));
        return this;
    }

    @Deprecated
    public <V> EntitySpec<T> location(Location val) {
        this.checkMutable();
        this.locations.add((Location)Preconditions.checkNotNull((Object)val, (Object)"location"));
        return this;
    }

    public <V> EntitySpec<T> location(LocationSpec<?> val) {
        this.checkMutable();
        this.locationSpecs.add((LocationSpec<?>)Preconditions.checkNotNull(val, (Object)"location"));
        return this;
    }

    public <V> EntitySpec<T> locationSpecs(Iterable<? extends LocationSpec<?>> val) {
        this.checkMutable();
        this.locationSpecs.addAll((Collection<LocationSpec<?>>)MutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(val, (Object)"locations"))));
        return this;
    }

    @Deprecated
    public <V> EntitySpec<T> locations(Iterable<? extends Location> val) {
        this.checkMutable();
        this.locations.addAll((Collection<Location>)MutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(val, (Object)"locations"))));
        return this;
    }

    public <V> EntitySpec<T> clearLocations() {
        this.checkMutable();
        this.locationSpecs.clear();
        this.locations.clear();
        return this;
    }

    public EntitySpec<T> immutable() {
        this.immutable = true;
        return this;
    }

    private void checkMutable() {
        if (this.immutable) {
            throw new IllegalStateException("Cannot modify immutable entity spec " + this);
        }
    }
}

