/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.lang.reflect.Constructor;
import org.apache.xbean.propertyeditor.AbstractConverter;
import org.apache.xbean.propertyeditor.PropertyEditorException;

public class ConstructorConverter
extends AbstractConverter {
    private final Constructor constructor;

    public ConstructorConverter(Class type, Constructor constructor) {
        super(type);
        this.constructor = constructor;
    }

    protected Object toObjectImpl(String text) {
        try {
            return this.constructor.newInstance(text);
        }
        catch (Exception e) {
            String message = String.format("Cannot convert string '%s' to %s.", text, super.getType());
            throw new PropertyEditorException(message, e);
        }
    }

    public static ConstructorConverter editor(Class type) {
        try {
            Constructor constructor = type.getConstructor(String.class);
            return new ConstructorConverter(type, constructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

