/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import org.jclouds.docker.suppliers.SSLContextBuilder;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;

@Singleton
public class DockerSSLContextSupplier
implements Supplier<SSLContext> {
    private final Supplier<Credentials> creds;
    private final String caCertPath;
    private final String caCertData;

    @Inject
    DockerSSLContextSupplier(@Provider Supplier<Credentials> creds, @Named(value="docker.cacert.path") String caCertPath, @Named(value="docker.cacert.data") String caCertData) {
        this.creds = creds;
        this.caCertPath = caCertPath;
        this.caCertData = caCertData;
    }

    public SSLContext get() {
        Credentials currentCreds = (Credentials)Preconditions.checkNotNull((Object)this.creds.get(), (Object)"credential supplier returned null");
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            if (SSLContextBuilder.isClientKeyAndCertificateData(currentCreds.credential, currentCreds.identity)) {
                builder.clientKeyAndCertificateData(currentCreds.credential, currentCreds.identity);
            } else {
                builder.clientKeyAndCertificatePaths(currentCreds.credential, currentCreds.identity);
            }
            if (!Strings.isNullOrEmpty((String)this.caCertPath)) {
                builder.caCertificatePath(this.caCertPath);
            } else if (!Strings.isNullOrEmpty((String)this.caCertData)) {
                builder.caCertificateData(this.caCertData);
            }
            return builder.build();
        }
        catch (GeneralSecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

