/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.location.Region;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.predicates.SecurityGroupPredicates;

public class NovaSecurityGroupExtension
implements SecurityGroupExtension {
    protected final NovaApi api;
    protected final ListeningExecutorService userExecutor;
    protected final Supplier<Set<String>> regionIds;
    protected final Function<SecurityGroupInRegion, SecurityGroup> groupConverter;
    protected final LoadingCache<RegionAndName, SecurityGroup> groupCreator;
    protected final GroupNamingConvention.Factory namingConvention;

    @Inject
    public NovaSecurityGroupExtension(NovaApi api, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, @Region Supplier<Set<String>> regionIds, Function<SecurityGroupInRegion, SecurityGroup> groupConverter, LoadingCache<RegionAndName, SecurityGroup> groupCreator, GroupNamingConvention.Factory namingConvention) {
        this.api = (NovaApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
        this.regionIds = (Supplier)Preconditions.checkNotNull(regionIds, (Object)"regionIds");
        this.groupConverter = (Function)Preconditions.checkNotNull(groupConverter, (Object)"groupConverter");
        this.groupCreator = (LoadingCache)Preconditions.checkNotNull(groupCreator, (Object)"groupCreator");
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention");
    }

    public Set<SecurityGroup> listSecurityGroups() {
        Iterable<? extends SecurityGroupInRegion> rawGroups = this.pollSecurityGroups();
        Iterable groups = Iterables.transform((Iterable)Iterables.filter(rawGroups, (Predicate)Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf((Iterable)groups);
    }

    public Set<SecurityGroup> listSecurityGroupsInLocation(Location location) {
        String region = location.getId();
        if (region == null) {
            return ImmutableSet.of();
        }
        return this.listSecurityGroupsInLocation(region);
    }

    public Set<SecurityGroup> listSecurityGroupsInLocation(String region) {
        Iterable<? extends SecurityGroupInRegion> rawGroups = this.pollSecurityGroupsByRegion(region);
        Iterable groups = Iterables.transform((Iterable)Iterables.filter(rawGroups, (Predicate)Predicates.notNull()), this.groupConverter);
        return ImmutableSet.copyOf((Iterable)groups);
    }

    public Set<SecurityGroup> listSecurityGroupsForNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        String region = regionAndId.getRegion();
        Set<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> allGroups = this.api.getServerApi(region).listSecurityGroupForServer(regionAndId.getId());
        ImmutableSet rawGroups = FluentIterable.from(allGroups).transform(this.groupToGroupInRegion(allGroups, region)).toSet();
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)rawGroups, (Predicate)Predicates.notNull()), this.groupConverter));
    }

    public SecurityGroup getSecurityGroupById(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        String region = regionAndId.getRegion();
        String groupId = regionAndId.getId();
        Optional<SecurityGroupApi> sgApi = this.api.getSecurityGroupApi(region);
        if (!sgApi.isPresent()) {
            return null;
        }
        FluentIterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> allGroups = ((SecurityGroupApi)sgApi.get()).list();
        SecurityGroupInRegion rawGroup = new SecurityGroupInRegion(((SecurityGroupApi)sgApi.get()).get(groupId), region, (Iterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup>)allGroups);
        return (SecurityGroup)this.groupConverter.apply((Object)rawGroup);
    }

    public SecurityGroup createSecurityGroup(String name, Location location) {
        String region = location.getId();
        if (region == null) {
            return null;
        }
        return this.createSecurityGroup(name, region);
    }

    public SecurityGroup createSecurityGroup(String name, String region) {
        String markerGroup = this.namingConvention.create().sharedNameForGroup(name);
        RegionSecurityGroupNameAndPorts regionAndName = new RegionSecurityGroupNameAndPorts(region, markerGroup, (Iterable<Integer>)ImmutableSet.of());
        SecurityGroup rawGroup = (SecurityGroup)this.groupCreator.getUnchecked((Object)regionAndName);
        return rawGroup;
    }

    public boolean removeSecurityGroup(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        String region = regionAndId.getRegion();
        String groupId = regionAndId.getId();
        Optional<SecurityGroupApi> sgApi = this.api.getSecurityGroupApi(region);
        if (!sgApi.isPresent()) {
            return false;
        }
        boolean deleted = ((SecurityGroupApi)sgApi.get()).delete(groupId);
        for (SecurityGroup cachedSg : this.groupCreator.asMap().values()) {
            if (!id.equals(cachedSg.getId())) continue;
            String groupName = cachedSg.getName();
            this.groupCreator.invalidate((Object)new RegionSecurityGroupNameAndPorts(region, groupName, (Iterable<Integer>)ImmutableSet.of()));
            break;
        }
        return deleted;
    }

    public SecurityGroup addIpPermission(IpPermission ipPermission, SecurityGroup group) {
        String region = group.getLocation().getId();
        RegionAndId groupRegionAndId = RegionAndId.fromSlashEncoded(group.getId());
        String id = groupRegionAndId.getId();
        Optional<SecurityGroupApi> sgApi = this.api.getSecurityGroupApi(region);
        if (!sgApi.isPresent()) {
            return null;
        }
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            for (String cidr : ipPermission.getCidrBlocks()) {
                ((SecurityGroupApi)sgApi.get()).createRuleAllowingCidrBlock(id, ((Ingress.Builder)((Ingress.Builder)((Ingress.Builder)Ingress.builder().ipProtocol(ipPermission.getIpProtocol())).fromPort(ipPermission.getFromPort())).toPort(ipPermission.getToPort())).build(), cidr);
            }
        }
        if (!ipPermission.getGroupIds().isEmpty()) {
            for (String regionAndGroupRaw : ipPermission.getGroupIds()) {
                RegionAndId regionAndId = RegionAndId.fromSlashEncoded(regionAndGroupRaw);
                String groupId = regionAndId.getId();
                ((SecurityGroupApi)sgApi.get()).createRuleAllowingSecurityGroupId(id, ((Ingress.Builder)((Ingress.Builder)((Ingress.Builder)Ingress.builder().ipProtocol(ipPermission.getIpProtocol())).fromPort(ipPermission.getFromPort())).toPort(ipPermission.getToPort())).build(), groupId);
            }
        }
        return this.getSecurityGroupById(RegionAndId.fromRegionAndId(region, id).slashEncode());
    }

    public SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.addIpPermission(permBuilder.build(), group);
    }

    public SecurityGroup removeIpPermission(IpPermission ipPermission, SecurityGroup group) {
        String region = group.getLocation().getId();
        RegionAndId groupRegionAndId = RegionAndId.fromSlashEncoded(group.getId());
        String id = groupRegionAndId.getId();
        Optional<SecurityGroupApi> sgApi = this.api.getSecurityGroupApi(region);
        if (!sgApi.isPresent()) {
            return null;
        }
        org.jclouds.openstack.nova.v2_0.domain.SecurityGroup securityGroup = ((SecurityGroupApi)sgApi.get()).get(id);
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            for (String cidr : ipPermission.getCidrBlocks()) {
                for (SecurityGroupRule rule : Iterables.filter(securityGroup.getRules(), (Predicate)Predicates.and((Predicate[])new Predicate[]{SecurityGroupPredicates.ruleCidr(cidr), SecurityGroupPredicates.ruleProtocol(ipPermission.getIpProtocol()), SecurityGroupPredicates.ruleStartPort(ipPermission.getFromPort()), SecurityGroupPredicates.ruleEndPort(ipPermission.getToPort())}))) {
                    ((SecurityGroupApi)sgApi.get()).deleteRule(rule.getId());
                }
            }
        }
        if (!ipPermission.getGroupIds().isEmpty()) {
            for (String groupId : ipPermission.getGroupIds()) {
                for (SecurityGroupRule rule : Iterables.filter(securityGroup.getRules(), (Predicate)Predicates.and((Predicate[])new Predicate[]{SecurityGroupPredicates.ruleGroup(groupId), SecurityGroupPredicates.ruleProtocol(ipPermission.getIpProtocol()), SecurityGroupPredicates.ruleStartPort(ipPermission.getFromPort()), SecurityGroupPredicates.ruleEndPort(ipPermission.getToPort())}))) {
                    ((SecurityGroupApi)sgApi.get()).deleteRule(rule.getId());
                }
            }
        }
        return this.getSecurityGroupById(RegionAndId.fromRegionAndId(region, id).slashEncode());
    }

    public SecurityGroup removeIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.removeIpPermission(permBuilder.build(), group);
    }

    public boolean supportsTenantIdGroupNamePairs() {
        return false;
    }

    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    public boolean supportsGroupIds() {
        return true;
    }

    public boolean supportsPortRangesForGroups() {
        return false;
    }

    public boolean supportsExclusionCidrBlocks() {
        return false;
    }

    protected Iterable<? extends SecurityGroupInRegion> pollSecurityGroups() {
        Iterable groups = Iterables.transform((Iterable)((Iterable)this.regionIds.get()), this.allSecurityGroupsInRegion());
        return Iterables.concat((Iterable)groups);
    }

    protected Iterable<? extends SecurityGroupInRegion> pollSecurityGroupsByRegion(String region) {
        return (Iterable)this.allSecurityGroupsInRegion().apply((Object)region);
    }

    protected Function<String, Set<? extends SecurityGroupInRegion>> allSecurityGroupsInRegion() {
        return new Function<String, Set<? extends SecurityGroupInRegion>>(){

            public Set<? extends SecurityGroupInRegion> apply(String from) {
                Optional<SecurityGroupApi> sgApi = NovaSecurityGroupExtension.this.api.getSecurityGroupApi(from);
                if (!sgApi.isPresent()) {
                    return ImmutableSet.of();
                }
                FluentIterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> allGroups = ((SecurityGroupApi)sgApi.get()).list();
                return allGroups.transform(NovaSecurityGroupExtension.this.groupToGroupInRegion((Iterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup>)allGroups, from)).toSet();
            }
        };
    }

    protected Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroupInRegion> groupToGroupInRegion(final Iterable<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> allGroups, final String region) {
        return new Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroupInRegion>(){

            public SecurityGroupInRegion apply(org.jclouds.openstack.nova.v2_0.domain.SecurityGroup group) {
                return new SecurityGroupInRegion(group, region, allGroups);
            }
        };
    }
}

