/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.common;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityManager;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecord;
import org.apache.brooklyn.api.mgmt.ha.ManagementPlaneSyncRecordPersister;
import org.apache.brooklyn.api.mgmt.rebind.PersistenceExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.RebindManager;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampPlatformLauncherNoServer;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Dumper;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.core.mgmt.ha.HighAvailabilityManagerImpl;
import org.apache.brooklyn.core.mgmt.ha.ManagementPlaneSyncRecordPersisterToObjectStore;
import org.apache.brooklyn.core.mgmt.internal.BrooklynShutdownHooks;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.persist.BrooklynMementoPersisterToObjectStore;
import org.apache.brooklyn.core.mgmt.persist.BrooklynPersistenceUtils;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.core.mgmt.rebind.PersistenceExceptionHandlerImpl;
import org.apache.brooklyn.core.mgmt.rebind.RebindManagerImpl;
import org.apache.brooklyn.core.mgmt.rebind.transformer.CompoundTransformer;
import org.apache.brooklyn.core.mgmt.rebind.transformer.impl.DeleteOrphanedStateTransformer;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.server.BrooklynServerPaths;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNode;
import org.apache.brooklyn.entity.brooklynnode.LocalBrooklynNode;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.stock.BasicApplication;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import org.apache.brooklyn.util.exceptions.FatalRuntimeException;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLauncher<T extends BasicLauncher<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicLauncher.class);
    private final Map<String, Object> brooklynAdditionalProperties = Maps.newLinkedHashMap();
    private BrooklynProperties brooklynProperties;
    private ManagementContext managementContext;
    private final List<String> locationSpecs = new ArrayList<String>();
    private final List<Location> locations = new ArrayList<Location>();
    private final List<EntitySpec<? extends Application>> appSpecsToManage = new ArrayList<EntitySpec<? extends Application>>();
    private final List<String> yamlAppsToManage = new ArrayList<String>();
    private final List<Application> apps = new ArrayList<Application>();
    private boolean startBrooklynNode = false;
    private boolean ignorePersistenceErrors = true;
    private boolean ignoreCatalogErrors = true;
    private boolean ignoreAppErrors = true;
    private CatalogInitialization catalogInitialization = null;
    private PersistMode persistMode = PersistMode.DISABLED;
    private HighAvailabilityMode highAvailabilityMode = HighAvailabilityMode.DISABLED;
    private String persistenceDir;
    private String persistenceLocation;
    private Duration persistPeriod = Duration.ONE_SECOND;
    private Duration haHeartbeatTimeoutOverride = null;
    private Duration haHeartbeatPeriodOverride = null;
    protected boolean startedPartTwo;
    protected boolean started;
    private BrooklynProperties.Factory.Builder brooklynPropertiesBuilder;
    private CampPlatform campPlatform;

    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    public List<Application> getApplications() {
        if (!this.started) {
            throw new IllegalStateException("Cannot retrieve application until started");
        }
        return ImmutableList.copyOf(this.apps);
    }

    public T application(EntitySpec<? extends Application> appSpec) {
        this.appSpecsToManage.add(appSpec);
        return this.self();
    }

    public T application(String yaml) {
        this.yamlAppsToManage.add(yaml);
        return this.self();
    }

    public T location(Location location) {
        this.locations.add((Location)Preconditions.checkNotNull((Object)location, (Object)"location"));
        return this.self();
    }

    public T location(String spec) {
        this.locationSpecs.add((String)Preconditions.checkNotNull((Object)spec, (Object)"spec"));
        return this.self();
    }

    public T locations(List<String> specs) {
        this.locationSpecs.addAll((Collection)Preconditions.checkNotNull(specs, (Object)"specs"));
        return this.self();
    }

    public T persistenceLocation(@Nullable String persistenceLocationSpec) {
        this.persistenceLocation = persistenceLocationSpec;
        return this.self();
    }

    public T managementContext(ManagementContext context) {
        if (this.brooklynProperties != null) {
            throw new IllegalStateException("Cannot set brooklynProperties and managementContext");
        }
        this.managementContext = context;
        return this.self();
    }

    public T brooklynProperties(BrooklynProperties brooklynProperties) {
        if (this.managementContext != null) {
            throw new IllegalStateException("Cannot set brooklynProperties and managementContext");
        }
        if (this.brooklynProperties != null && brooklynProperties != null && this.brooklynProperties != brooklynProperties) {
            LOG.warn("Brooklyn properties being reset in " + this.self() + "; set null first if you wish to clear it", new Throwable("Source of brooklyn properties reset"));
        }
        this.brooklynProperties = brooklynProperties;
        return this.self();
    }

    public T brooklynProperties(String field, Object value) {
        this.brooklynAdditionalProperties.put((String)Preconditions.checkNotNull((Object)field, (Object)"field"), value);
        return this.self();
    }

    public <C> T brooklynProperties(ConfigKey<C> key, C value) {
        return this.brooklynProperties(key.getName(), value);
    }

    public T ignorePersistenceErrors(boolean ignorePersistenceErrors) {
        this.ignorePersistenceErrors = ignorePersistenceErrors;
        return this.self();
    }

    public T ignoreCatalogErrors(boolean ignoreCatalogErrors) {
        this.ignoreCatalogErrors = ignoreCatalogErrors;
        return this.self();
    }

    public T ignoreAppErrors(boolean ignoreAppErrors) {
        this.ignoreAppErrors = ignoreAppErrors;
        return this.self();
    }

    @Beta
    public T catalogInitialization(CatalogInitialization catInit) {
        if (this.started) {
            throw new IllegalStateException("Cannot set catalog customization after start()");
        }
        if (this.catalogInitialization != null) {
            throw new IllegalStateException("Initial catalog customization already set.");
        }
        this.catalogInitialization = catInit;
        return this.self();
    }

    public T persistMode(PersistMode persistMode) {
        this.persistMode = (PersistMode)Preconditions.checkNotNull((Object)persistMode, (Object)"persistMode");
        return this.self();
    }

    public T highAvailabilityMode(HighAvailabilityMode highAvailabilityMode) {
        this.highAvailabilityMode = (HighAvailabilityMode)Preconditions.checkNotNull((Object)highAvailabilityMode, (Object)"highAvailabilityMode");
        return this.self();
    }

    public T persistenceDir(@Nullable String persistenceDir) {
        this.persistenceDir = persistenceDir;
        return this.self();
    }

    public T persistenceDir(@Nullable File persistenceDir) {
        if (persistenceDir == null) {
            return this.persistenceDir((String)null);
        }
        return this.persistenceDir(persistenceDir.getAbsolutePath());
    }

    public T persistPeriod(Duration persistPeriod) {
        this.persistPeriod = persistPeriod;
        return this.self();
    }

    public T haHeartbeatTimeout(Duration val) {
        this.haHeartbeatTimeoutOverride = val;
        return this.self();
    }

    public T startBrooklynNode(boolean val) {
        this.startBrooklynNode = val;
        return this.self();
    }

    public T haHeartbeatPeriod(Duration val) {
        this.haHeartbeatPeriodOverride = val;
        return this.self();
    }

    public void copyPersistedState(String destinationDir) {
        this.copyPersistedState(destinationDir, null, null);
    }

    public void copyPersistedState(String destinationDir, @Nullable String destinationLocation) {
        this.copyPersistedState(destinationDir, destinationLocation, null);
    }

    public void copyPersistedState(String destinationDir, @Nullable String destinationLocationSpec, @Nullable CompoundTransformer transformer) {
        this.initManagementContext();
        try {
            this.highAvailabilityMode = HighAvailabilityMode.HOT_STANDBY;
            this.initPersistence();
        }
        catch (Exception e) {
            this.handleSubsystemStartupError(this.ignorePersistenceErrors, "persistence", e);
        }
        try {
            BrooklynMementoRawData memento = this.managementContext.getRebindManager().retrieveMementoRawData();
            if (transformer != null) {
                memento = transformer.transform(memento);
            }
            ManagementPlaneSyncRecord planeState = this.managementContext.getHighAvailabilityManager().loadManagementPlaneSyncRecord(true);
            LOG.info("Copying persisted state to " + destinationDir + (destinationLocationSpec != null ? " @ " + destinationLocationSpec : ""));
            PersistenceObjectStore destinationObjectStore = BrooklynPersistenceUtils.newPersistenceObjectStore((ManagementContext)this.managementContext, (String)destinationLocationSpec, (String)destinationDir);
            BrooklynPersistenceUtils.writeMemento((ManagementContext)this.managementContext, (BrooklynMementoRawData)memento, (PersistenceObjectStore)destinationObjectStore);
            BrooklynPersistenceUtils.writeManagerMemento((ManagementContext)this.managementContext, (ManagementPlaneSyncRecord)planeState, (PersistenceObjectStore)destinationObjectStore);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.debug("Error copying persisted state (rethrowing): " + e, (Throwable)e);
            throw new FatalRuntimeException("Error copying persisted state: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
        }
    }

    public void cleanOrphanedState(String destinationDir, @Nullable String destinationLocationSpec) {
        this.copyPersistedState(destinationDir, destinationLocationSpec, (CompoundTransformer)DeleteOrphanedStateTransformer.builder().build());
    }

    @Deprecated
    public BrooklynMementoRawData retrieveState() {
        this.initManagementContext();
        this.initPersistence();
        return this.managementContext.getRebindManager().retrieveMementoRawData();
    }

    @Deprecated
    public void persistState(BrooklynMementoRawData memento, String destinationDir, @Nullable String destinationLocationSpec) {
        this.initManagementContext();
        PersistenceObjectStore destinationObjectStore = BrooklynPersistenceUtils.newPersistenceObjectStore((ManagementContext)this.managementContext, (String)destinationLocationSpec, (String)destinationDir);
        BrooklynPersistenceUtils.writeMemento((ManagementContext)this.managementContext, (BrooklynMementoRawData)memento, (PersistenceObjectStore)destinationObjectStore);
    }

    public T start() {
        this.startPartOne();
        this.startPartTwo();
        return this.self();
    }

    protected T startPartOne() {
        if (this.started) {
            throw new IllegalStateException("Cannot start() or launch() multiple times");
        }
        this.started = true;
        this.checkConfiguration();
        this.initManagementContext();
        CatalogInitialization catInit = ((ManagementContextInternal)this.managementContext).getCatalogInitialization();
        if (this.catalogInitialization != null && this.catalogInitialization != catInit) {
            throw new IllegalStateException("Unexpected catalog initialization: " + catInit + " != " + this.catalogInitialization);
        }
        this.catalogInitialization = catInit;
        this.markCatalogStartingUp(catInit);
        this.startingUp();
        this.initCamp();
        return this.self();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkConfiguration() {
        if (this.highAvailabilityMode == HighAvailabilityMode.DISABLED) return;
        if (this.persistMode == PersistMode.DISABLED) {
            if (this.highAvailabilityMode != HighAvailabilityMode.AUTO) throw new FatalConfigurationRuntimeException("Cannot specify highAvailability when persistence is disabled");
            this.highAvailabilityMode = HighAvailabilityMode.DISABLED;
            return;
        } else {
            if (this.persistMode != PersistMode.CLEAN || this.highAvailabilityMode != HighAvailabilityMode.STANDBY && this.highAvailabilityMode != HighAvailabilityMode.HOT_STANDBY && this.highAvailabilityMode != HighAvailabilityMode.HOT_BACKUP) return;
            throw new FatalConfigurationRuntimeException("Cannot specify highAvailability " + this.highAvailabilityMode + " when persistence is CLEAN");
        }
    }

    protected T startPartTwo() {
        if (this.startedPartTwo) {
            throw new IllegalStateException("Cannot start() or launch() multiple times");
        }
        this.startedPartTwo = true;
        if (this.persistMode != PersistMode.DISABLED) {
            this.handlePersistence();
        } else {
            ((LocalManagementContext)this.managementContext).generateManagementPlaneId();
            this.populateInitialCatalogNoPersistence(this.catalogInitialization);
            this.managementContext.getHighAvailabilityManager().disabled(false);
        }
        this.markCatalogStarted(this.catalogInitialization);
        this.addLocations();
        this.markStartupComplete();
        this.initApps();
        this.initBrooklynNode();
        this.persist();
        return this.self();
    }

    protected void persist() {
        if (this.persistMode != PersistMode.DISABLED) {
            this.managementContext.getRebindManager().forcePersistNow(false, null);
        }
    }

    protected void initBrooklynNode() {
        if (this.startBrooklynNode) {
            try {
                this.startBrooklynNode();
            }
            catch (Exception e) {
                this.handleSubsystemStartupError(this.ignoreAppErrors, "brooklyn node / self entity", e);
            }
        }
    }

    protected void initApps() {
        try {
            this.createApps();
            this.startApps();
        }
        catch (Exception e) {
            this.handleSubsystemStartupError(this.ignoreAppErrors, "brooklyn autostart apps", e);
        }
    }

    protected void markStartupComplete() {
        ((LocalManagementContext)this.managementContext).noteStartupComplete();
    }

    protected void addLocations() {
        this.locations.addAll(this.managementContext.getLocationRegistry().getListOfLocationsManaged(this.locationSpecs));
    }

    protected void startingUp() {
    }

    protected void populateInitialCatalogNoPersistence(CatalogInitialization catInit) {
        assert (this.persistMode == PersistMode.DISABLED) : "persistMode=" + this.persistMode;
        try {
            LOG.debug("Initializing initial catalog as part of launch sequence (prior to any persistence rebind)");
            catInit.populateInitialCatalogOnly();
        }
        catch (Exception e) {
            this.handleSubsystemStartupError(this.ignoreCatalogErrors, "initial catalog", e);
        }
    }

    private void markCatalogStarted(CatalogInitialization catInit) {
        catInit.setStartingUp(false);
    }

    protected void handlePersistence() {
        try {
            this.initPersistence();
            this.startPersistence();
        }
        catch (Exception e) {
            this.handleSubsystemStartupError(this.ignorePersistenceErrors, "persistence", e);
        }
    }

    protected void initCamp() {
        this.campPlatform = new BrooklynCampPlatformLauncherNoServer().useManagementContext(this.managementContext).launch().getCampPlatform();
    }

    protected void markCatalogStartingUp(CatalogInitialization catInit) {
        catInit.setStartingUp(true);
    }

    protected void initManagementContext() {
        if (this.managementContext == null) {
            this.managementContext = new LocalManagementContext(this.brooklynPropertiesBuilder, this.brooklynAdditionalProperties);
            this.brooklynProperties = ((ManagementContextInternal)this.managementContext).getBrooklynProperties();
            BrooklynShutdownHooks.invokeTerminateOnShutdown((ManagementContext)this.getManagementContext());
        } else if (this.brooklynProperties == null) {
            this.brooklynProperties = ((ManagementContextInternal)this.managementContext).getBrooklynProperties();
            this.brooklynProperties.addFromMap(this.brooklynAdditionalProperties);
        }
        if (this.catalogInitialization != null) {
            ((ManagementContextInternal)this.managementContext).setCatalogInitialization(this.catalogInitialization);
        }
    }

    protected void handleSubsystemStartupError(boolean ignoreSuchErrors, String system, Exception e) {
        Exceptions.propagateIfFatal((Throwable)e);
        if (ignoreSuchErrors) {
            LOG.error("Subsystem for " + system + " had startup error (continuing with startup): " + e, (Throwable)e);
            if (this.managementContext != null) {
                ((ManagementContextInternal)this.managementContext).errors().add(e);
            }
        } else {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected void initPersistence() {
        BrooklynMementoPersisterToObjectStore persister;
        PersistenceObjectStore objectStore;
        assert (this.persistMode != PersistMode.DISABLED) : "persistMode=" + this.persistMode + "; haMode=" + this.highAvailabilityMode;
        try {
            if (this.persistenceLocation == null) {
                this.persistenceLocation = (String)this.brooklynProperties.getConfig(BrooklynServerConfig.PERSISTENCE_LOCATION_SPEC);
            }
            this.persistenceDir = BrooklynServerPaths.newMainPersistencePathResolver((StringConfigMap)this.brooklynProperties).location(this.persistenceLocation).dir(this.persistenceDir).resolve();
            objectStore = BrooklynPersistenceUtils.newPersistenceObjectStore((ManagementContext)this.managementContext, (String)this.persistenceLocation, (String)this.persistenceDir, (PersistMode)this.persistMode, (HighAvailabilityMode)this.highAvailabilityMode);
            RebindManager rebindManager = this.managementContext.getRebindManager();
            persister = new BrooklynMementoPersisterToObjectStore(objectStore, this.managementContext);
            PersistenceExceptionHandler persistenceExceptionHandler = PersistenceExceptionHandlerImpl.builder().build();
            ((RebindManagerImpl)rebindManager).setPeriodicPersistPeriod(this.persistPeriod);
            rebindManager.setPersister((BrooklynMementoPersister)persister, persistenceExceptionHandler);
        }
        catch (FatalConfigurationRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.debug("Error initializing persistence subsystem (rethrowing): " + e, (Throwable)e);
            throw new FatalRuntimeException("Error initializing persistence subsystem: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
        }
        if (this.highAvailabilityMode == HighAvailabilityMode.DISABLED) {
            LOG.info("High availability disabled");
        } else {
            HighAvailabilityManager haManager = this.managementContext.getHighAvailabilityManager();
            persister = new ManagementPlaneSyncRecordPersisterToObjectStore(this.managementContext, objectStore, this.managementContext.getCatalogClassLoader());
            ((HighAvailabilityManagerImpl)haManager).setHeartbeatTimeout(this.haHeartbeatTimeoutOverride);
            ((HighAvailabilityManagerImpl)haManager).setPollPeriod(this.haHeartbeatPeriodOverride);
            haManager.setPersister((ManagementPlaneSyncRecordPersister)persister);
        }
    }

    protected void startPersistence() {
        assert (this.persistMode != PersistMode.DISABLED) : "persistMode=" + this.persistMode + "; haMode=" + this.highAvailabilityMode;
        if (this.highAvailabilityMode == HighAvailabilityMode.DISABLED) {
            HighAvailabilityManager haManager = this.managementContext.getHighAvailabilityManager();
            haManager.disabled(true);
            this.startPersistenceWithoutHA();
        } else {
            HighAvailabilityMode startMode;
            switch (this.highAvailabilityMode) {
                case AUTO: 
                case MASTER: 
                case STANDBY: 
                case HOT_STANDBY: 
                case HOT_BACKUP: {
                    startMode = this.highAvailabilityMode;
                    break;
                }
                case DISABLED: {
                    throw new IllegalStateException("Unexpected code-branch for high availability mode " + this.highAvailabilityMode);
                }
                default: {
                    throw new IllegalStateException("Unexpected high availability mode " + this.highAvailabilityMode);
                }
            }
            LOG.debug("Management node (with HA) starting");
            HighAvailabilityManager haManager = this.managementContext.getHighAvailabilityManager();
            haManager.start(startMode);
        }
    }

    private void startPersistenceWithoutHA() {
        RebindManager rebindManager = this.managementContext.getRebindManager();
        if (Strings.isNonBlank((CharSequence)this.persistenceLocation)) {
            LOG.info("Management node (no HA) rebinding to entities at " + this.persistenceLocation + " in " + this.persistenceDir);
        } else {
            LOG.info("Management node (no HA) rebinding to entities on file system in " + this.persistenceDir);
        }
        ClassLoader classLoader = this.managementContext.getCatalogClassLoader();
        try {
            rebindManager.rebind(classLoader, null, ManagementNodeState.MASTER);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.debug("Error rebinding to persisted state (rethrowing): " + e, (Throwable)e);
            throw new FatalRuntimeException("Error rebinding to persisted state: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
        }
        rebindManager.startPersistence();
    }

    protected void createApps() {
        Application app;
        for (EntitySpec<? extends Application> spec : this.appSpecsToManage) {
            app = (Application)this.managementContext.getEntityManager().createEntity(spec);
            this.apps.add(app);
        }
        for (String blueprint : this.yamlAppsToManage) {
            app = EntityManagementUtils.createUnstarted((ManagementContext)this.managementContext, (String)blueprint);
            this.apps.add(app);
        }
    }

    protected void startBrooklynNode() {
        String classpath = System.getenv("INITIAL_CLASSPATH");
        if (Strings.isBlank((CharSequence)classpath)) {
            LOG.warn("Cannot find INITIAL_CLASSPATH environment variable, skipping BrooklynNode entity creation");
            return;
        }
        EntitySpec<LocalBrooklynNode> brooklynNodeSpec = (EntitySpec<LocalBrooklynNode>)((EntitySpec)((EntitySpec)EntitySpec.create(LocalBrooklynNode.class).configure(SoftwareProcess.ENTITY_STARTED, (Object)true)).configure((ConfigKey.HasConfigKey)BrooklynNode.CLASSPATH, (Object)Splitter.on((String)":").splitToList((CharSequence)classpath))).displayName("Brooklyn Console");
        if ((brooklynNodeSpec = this.customizeBrooklynNodeSpec(brooklynNodeSpec)) != null) {
            EntityManagementUtils.createStarting((ManagementContext)this.managementContext, (EntitySpec)((EntitySpec)EntitySpec.create(BasicApplication.class).displayName("Brooklyn")).child(brooklynNodeSpec));
        }
    }

    protected EntitySpec<LocalBrooklynNode> customizeBrooklynNodeSpec(EntitySpec<LocalBrooklynNode> brooklynNodeSpec) {
        LOG.error("Skipping BrooklynNode registration. Configure a loopback REST endpoint configured for the node.");
        return null;
    }

    protected void startApps() {
        ArrayList appExceptions = Lists.newArrayList();
        for (Application app : this.apps) {
            if (!(app instanceof Startable)) continue;
            try {
                LOG.info("Starting brooklyn application {} in location{} {}", new Object[]{app, this.locations.size() != 1 ? "s" : "", this.locations});
                ((Startable)app).start(this.locations);
                Dumper.dumpInfo((Entity)app);
                String sensors = "";
                if (app.getAttribute(Attributes.MAIN_URI_MAPPED_PUBLIC) != null) {
                    sensors = ": " + app.getAttribute(Attributes.MAIN_URI_MAPPED_PUBLIC);
                } else if (app.getAttribute(Attributes.MAIN_URI) != null) {
                    sensors = sensors + ": " + app.getAttribute(Attributes.MAIN_URI);
                }
                LOG.info("Started brooklyn application {} in location{} {}{}", new Object[]{app, this.locations.size() != 1 ? "s" : "", this.locations, sensors});
            }
            catch (Exception e) {
                LOG.error("Error starting " + app + ": " + Exceptions.collapseText((Throwable)e), Exceptions.getFirstInteresting((Throwable)e));
                appExceptions.add(Exceptions.collapse((Throwable)e));
                if (!Thread.currentThread().isInterrupted()) continue;
                LOG.error("Interrupted while starting applications; aborting");
                break;
            }
        }
        if (!appExceptions.isEmpty()) {
            Throwable t = Exceptions.create((Iterable)appExceptions);
            throw new FatalRuntimeException("Error starting applications: " + Exceptions.collapseText((Throwable)t), t);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public PersistMode getPersistMode() {
        return this.persistMode;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public CampPlatform getCampPlatform() {
        return this.campPlatform;
    }

    private T self() {
        return (T)this;
    }

    public void setBrooklynPropertiesBuilder(BrooklynProperties.Factory.Builder brooklynPropertiesBuilder) {
        this.brooklynPropertiesBuilder = brooklynPropertiesBuilder;
    }

    public BrooklynProperties.Factory.Builder getBrooklynPropertiesBuilder() {
        return this.brooklynPropertiesBuilder;
    }

    public BrooklynProperties getBrooklynProperties() {
        return this.brooklynProperties;
    }
}

