/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.logging.Logger;
import org.jclouds.packet.compute.functions.FacilityToLocation;
import org.jclouds.packet.compute.functions.OperatingSystemToImage;
import org.jclouds.packet.compute.functions.PlanToHardware;
import org.jclouds.packet.domain.Device;
import org.jclouds.packet.domain.IpAddress;

@Singleton
public class DeviceToNodeMetadata
implements Function<Device, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final PlanToHardware planToHardware;
    private final OperatingSystemToImage operatingSystemToImage;
    private final FacilityToLocation facilityToLocation;
    private final Function<Device.State, NodeMetadata.Status> toPortableStatus;
    private final GroupNamingConvention groupNamingConvention;

    @Inject
    DeviceToNodeMetadata(PlanToHardware planToHardware, OperatingSystemToImage operatingSystemToImage, FacilityToLocation facilityToLocation, Function<Device.State, NodeMetadata.Status> toPortableStatus, GroupNamingConvention.Factory groupNamingConvention) {
        this.planToHardware = planToHardware;
        this.operatingSystemToImage = operatingSystemToImage;
        this.facilityToLocation = facilityToLocation;
        this.toPortableStatus = toPortableStatus;
        this.groupNamingConvention = groupNamingConvention.createWithoutPrefix();
    }

    public NodeMetadata apply(Device input) {
        return new NodeMetadataBuilder().ids(input.id()).name(input.hostname()).hostname(String.format("%s", input.hostname())).group(this.groupNamingConvention.extractGroup(input.hostname())).location(this.facilityToLocation.apply(input.facility())).hardware(this.planToHardware.apply(input.plan())).imageId(input.operatingSystem().slug()).operatingSystem(this.operatingSystemToImage.apply(input.operatingSystem()).getOperatingSystem()).status((NodeMetadata.Status)this.toPortableStatus.apply((Object)input.state())).publicAddresses(this.getPublicIpAddresses(input.ipAddresses())).privateAddresses(this.getPrivateIpAddresses(input.ipAddresses())).tags(input.tags()).build();
    }

    private Iterable<String> getPublicIpAddresses(List<IpAddress> input) {
        return this.filterAndTransformIpAddresses(input, new IsPublicIpAddress());
    }

    private Iterable<String> getPrivateIpAddresses(List<IpAddress> input) {
        return this.filterAndTransformIpAddresses(input, (Predicate<IpAddress>)Predicates.not((Predicate)new IsPublicIpAddress()));
    }

    private Iterable<String> filterAndTransformIpAddresses(List<IpAddress> input, Predicate<IpAddress> filter) {
        return FluentIterable.from(input).filter(filter).transform((Function)new IpAddressToIp());
    }

    private static class IsPublicIpAddress
    implements Predicate<IpAddress> {
        private IsPublicIpAddress() {
        }

        public boolean apply(IpAddress input) {
            return input.publicAddress();
        }
    }

    private static class IpAddressToIp
    implements Function<IpAddress, String> {
        private IpAddressToIp() {
        }

        public String apply(IpAddress input) {
            return input.address();
        }
    }
}

