/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jclouds.cloudstack.domain.SshKeyPair;

public class SshKeyPairPredicates {
    public static Predicate<SshKeyPair> nameMatches(final Predicate<String> name) {
        Preconditions.checkNotNull(name, (Object)"name must be defined");
        return new Predicate<SshKeyPair>(){

            public boolean apply(SshKeyPair ext) {
                return name.apply((Object)ext.getName());
            }

            public String toString() {
                return "nameMatches(" + name + ")";
            }
        };
    }

    public static Predicate<SshKeyPair> nameEquals(final String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must be defined");
        return new Predicate<SshKeyPair>(){

            public boolean apply(SshKeyPair ext) {
                return ext.getName() != null && ext.getName().equals(name);
            }

            public String toString() {
                return "nameEquals(" + name + ")";
            }
        };
    }
}

