/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.rebind.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.mgmt.rebind.mementos.EntityMemento;
import org.apache.brooklyn.api.mgmt.rebind.mementos.TreeNode;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.mgmt.rebind.dto.AbstractTreeNodeMemento;
import org.apache.brooklyn.core.objs.BrooklynTypes;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class BasicEntityMemento
extends AbstractTreeNodeMemento
implements EntityMemento,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(BasicEntityMemento.class);
    private static final long serialVersionUID = 8642959541121050126L;
    private Boolean isTopLevelApp;
    private Map<String, Object> config;
    private List<String> locations;
    private List<String> members;
    private Map<String, Object> attributes;
    private List<String> policies;
    private List<String> enrichers;
    private List<String> feeds;
    private Map<String, ConfigKey<?>> configKeys;
    private transient Map<String, ConfigKey<?>> staticConfigKeys;
    private Map<String, AttributeSensor<?>> attributeKeys;
    private transient Map<String, Sensor<?>> staticSensorKeys;
    private List<Effector<?>> effectors;
    private transient List<ConfigKey<?>> allConfigKeys;
    private transient Map<ConfigKey<?>, Object> configByKey;
    private transient Map<String, Object> configUnmatched;
    private transient Map<AttributeSensor<?>, Object> attributesByKey;
    static final String LEGACY_KEY_DESCRIPTION = "This item was defined in a different version of this blueprint; metadata unavailable here.";

    public static Builder builder() {
        return new Builder();
    }

    private BasicEntityMemento() {
    }

    protected BasicEntityMemento(Builder builder) {
        super(builder);
        ConfigKey key;
        this.isTopLevelApp = builder.isTopLevelApp == null || builder.isTopLevelApp == (this.getParent() == null) ? null : builder.isTopLevelApp;
        this.locations = this.toPersistedList(builder.locations);
        this.policies = this.toPersistedList(builder.policies);
        this.enrichers = this.toPersistedList(builder.enrichers);
        this.feeds = this.toPersistedList(builder.feeds);
        this.members = this.toPersistedList(builder.members);
        this.effectors = this.toPersistedList(builder.effectors);
        this.allConfigKeys = builder.configKeys;
        this.configByKey = builder.config;
        this.configUnmatched = builder.configUnmatched;
        this.attributesByKey = builder.attributes;
        this.staticConfigKeys = this.getStaticConfigKeys();
        this.staticSensorKeys = this.getStaticSensorKeys();
        this.configKeys = Maps.newLinkedHashMap();
        this.config = Maps.newLinkedHashMap();
        if (this.allConfigKeys != null) {
            for (ConfigKey<?> configKey : this.allConfigKeys) {
                if (configKey == this.staticConfigKeys.get(configKey.getName())) continue;
                this.configKeys.put(configKey.getName(), configKey);
            }
        }
        if (this.configByKey != null) {
            for (Map.Entry entry : this.configByKey.entrySet()) {
                key = (ConfigKey)entry.getKey();
                ConfigKey<?> staticKey = this.staticConfigKeys.get(key.getName());
                if (!this.configKeys.containsKey(key.getName()) && key != staticKey) {
                    if (BasicEntityMemento.isAnonymous(key)) {
                        log.trace("Skipping persistence of " + key + " on " + this.getId() + " because it is anonymous");
                    } else {
                        if (log.isTraceEnabled()) {
                            if (staticKey != null) {
                                log.trace("Persisting dynamic config key " + key + " on " + this.getId() + ", overriding key on type " + staticKey);
                            } else {
                                log.trace("Persisting dynamic config key " + key + " on " + this.getId());
                            }
                        }
                        this.configKeys.put(key.getName(), key);
                    }
                }
                this.config.put(key.getName(), entry.getValue());
            }
        }
        if (this.configUnmatched != null) {
            this.config.putAll(this.configUnmatched);
        }
        if (this.attributesByKey != null) {
            this.attributeKeys = Maps.newLinkedHashMap();
            this.attributes = Maps.newLinkedHashMap();
            for (Map.Entry entry : this.attributesByKey.entrySet()) {
                key = (AttributeSensor)entry.getKey();
                if (!key.equals(this.staticSensorKeys.get(key.getName()))) {
                    this.attributeKeys.put(key.getName(), (AttributeSensor<?>)key);
                }
                this.attributes.put(key.getName(), entry.getValue());
            }
        }
        this.configKeys = this.toPersistedMap(this.configKeys);
        this.config = this.toPersistedMap(this.config);
        this.attributeKeys = this.toPersistedMap(this.attributeKeys);
        this.attributes = this.toPersistedMap(this.attributes);
    }

    private static boolean isAnonymous(ConfigKey<?> key) {
        Preconditions.checkNotNull(key, (Object)"key");
        if (!Object.class.equals((Object)key.getType())) {
            return false;
        }
        if (!Strings.isBlank((CharSequence)key.getDescription())) {
            return false;
        }
        return key.getDefaultValue() == null;
    }

    protected synchronized Map<String, ConfigKey<?>> getStaticConfigKeys() {
        if (this.staticConfigKeys == null) {
            Class<?> clazz = this.getTypeClass();
            this.staticConfigKeys = clazz == null ? BrooklynTypes.getDefinedConfigKeys(this.getType()) : BrooklynTypes.getDefinedConfigKeys(clazz);
        }
        return this.staticConfigKeys;
    }

    protected ConfigKey<?> getConfigKey(String key) {
        ConfigKey<?> result = null;
        if (this.configKeys != null && (result = this.configKeys.get(key)) != null && !LEGACY_KEY_DESCRIPTION.equals(result.getDescription())) {
            return result;
        }
        ConfigKey<?> resultStatic = this.getStaticConfigKeys().get(key);
        if (resultStatic != null) {
            return resultStatic;
        }
        if (result != null) {
            return result;
        }
        return null;
    }

    protected synchronized Map<String, Sensor<?>> getStaticSensorKeys() {
        if (this.staticSensorKeys == null) {
            Class<?> clazz = this.getTypeClass();
            this.staticSensorKeys = clazz == null ? BrooklynTypes.getDefinedSensors(this.getType()) : BrooklynTypes.getDefinedSensors(clazz);
        }
        return this.staticSensorKeys;
    }

    protected AttributeSensor<?> getAttributeKey(String key) {
        AttributeSensor<?> result = null;
        if (this.attributeKeys != null && (result = this.attributeKeys.get(key)) != null && !LEGACY_KEY_DESCRIPTION.equals(result.getDescription())) {
            return result;
        }
        AttributeSensor resultStatic = (AttributeSensor)this.getStaticSensorKeys().get(key);
        if (resultStatic != null) {
            return resultStatic;
        }
        if (result != null) {
            return result;
        }
        log.warn("Sensor " + key + ": " + LEGACY_KEY_DESCRIPTION);
        return Sensors.newSensor(Object.class, key, LEGACY_KEY_DESCRIPTION);
    }

    private void postDeserialize() {
        this.configByKey = Maps.newLinkedHashMap();
        this.configUnmatched = Maps.newLinkedHashMap();
        if (this.config != null) {
            for (Map.Entry<String, Object> entry : this.config.entrySet()) {
                ConfigKey<?> configKey = this.getConfigKey(entry.getKey());
                if (configKey != null) {
                    this.configByKey.put(configKey, entry.getValue());
                    continue;
                }
                this.configUnmatched.put(entry.getKey(), entry.getValue());
            }
        }
        this.attributesByKey = Maps.newLinkedHashMap();
        if (this.attributes != null) {
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                this.attributesByKey.put(this.getAttributeKey(entry.getKey()), entry.getValue());
            }
        }
    }

    public boolean isTopLevelApp() {
        return this.isTopLevelApp != null ? this.isTopLevelApp : this.getParent() == null;
    }

    public List<ConfigKey<?>> getDynamicConfigKeys() {
        return this.configKeys == null ? ImmutableList.of() : ImmutableList.copyOf(this.configKeys.values());
    }

    public Map<ConfigKey<?>, Object> getConfig() {
        if (this.configByKey == null) {
            this.postDeserialize();
        }
        return Collections.unmodifiableMap(this.configByKey);
    }

    public Map<String, Object> getConfigUnmatched() {
        if (this.configUnmatched == null) {
            this.postDeserialize();
        }
        return Collections.unmodifiableMap(this.configUnmatched);
    }

    public Map<AttributeSensor<?>, Object> getAttributes() {
        if (this.attributesByKey == null) {
            this.postDeserialize();
        }
        return Collections.unmodifiableMap(this.attributesByKey);
    }

    public List<Effector<?>> getEffectors() {
        return this.fromPersistedList(this.effectors);
    }

    public List<String> getPolicies() {
        return this.fromPersistedList(this.policies);
    }

    public List<String> getEnrichers() {
        return this.fromPersistedList(this.enrichers);
    }

    public List<String> getMembers() {
        return this.fromPersistedList(this.members);
    }

    public List<String> getLocations() {
        return this.fromPersistedList(this.locations);
    }

    public List<String> getFeeds() {
        return this.fromPersistedList(this.feeds);
    }

    @Override
    protected MoreObjects.ToStringHelper newVerboseStringHelper() {
        return super.newVerboseStringHelper().add("members", this.getMembers()).add("config", Sanitizer.sanitize(this.getConfig())).add("configUnmatched", Sanitizer.sanitize(this.getConfigUnmatched())).add("attributes", Sanitizer.sanitize(this.getAttributes())).add("policies", (Object)this.getPolicies()).add("enrichers", (Object)this.getEnrichers()).add("locations", this.getLocations());
    }

    public static class Builder
    extends AbstractTreeNodeMemento.Builder<Builder> {
        protected Boolean isTopLevelApp;
        protected List<ConfigKey<?>> configKeys = Lists.newArrayList();
        protected Map<ConfigKey<?>, Object> config = Maps.newLinkedHashMap();
        protected Map<String, Object> configUnmatched = Maps.newLinkedHashMap();
        protected Map<AttributeSensor<?>, Object> attributes = Maps.newLinkedHashMap();
        protected List<String> locations = Lists.newArrayList();
        protected List<String> policies = Lists.newArrayList();
        protected List<String> enrichers = Lists.newArrayList();
        protected List<String> feeds = Lists.newArrayList();
        protected List<String> members = Lists.newArrayList();
        protected List<Effector<?>> effectors = Lists.newArrayList();

        public Builder from(EntityMemento other) {
            super.from((TreeNode)other);
            this.isTopLevelApp = other.isTopLevelApp();
            this.displayName = other.getDisplayName();
            this.config.putAll(other.getConfig());
            this.configUnmatched.putAll(other.getConfigUnmatched());
            this.attributes.putAll(other.getAttributes());
            this.locations.addAll(other.getLocations());
            this.policies.addAll(other.getPolicies());
            this.enrichers.addAll(other.getEnrichers());
            this.feeds.addAll(other.getFeeds());
            this.members.addAll(other.getMembers());
            this.effectors.addAll(other.getEffectors());
            return this;
        }

        public EntityMemento build() {
            this.invalidate();
            return new BasicEntityMemento(this);
        }
    }
}

