/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.AbstractApplication;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.enricher.stock.AbstractMultipleSensorAggregator;
import org.apache.brooklyn.entity.stock.AsyncApplication;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncApplicationImpl
extends AbstractApplication
implements AsyncApplication {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncApplicationImpl.class);

    @Override
    public void init() {
        if (Strings.isBlank((CharSequence)((CharSequence)this.getConfig(DEFAULT_DISPLAY_NAME)))) {
            this.setDefaultDisplayName("Application (" + this.getId() + ")");
        }
        super.init();
    }

    @Override
    protected void initEnrichers() {
        this.enrichers().add((EnricherSpec)((EnricherSpec)((EnricherSpec)EnricherSpec.create(ServiceStateComputer.class).configure(ServiceStateComputer.FROM_CHILDREN, (Object)true)).configure(ServiceStateComputer.UP_QUORUM_CHECK, this.config().get(UP_QUORUM_CHECK))).configure(ServiceStateComputer.RUNNING_QUORUM_CHECK, this.config().get(RUNNING_QUORUM_CHECK)));
    }

    @Override
    public void start(Collection<? extends Location> locations) {
        this.addLocations(locations);
        Object locationsToUse = locations == null ? ImmutableSet.of() : locations;
        ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((Entity)this, START);
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, Attributes.SERVICE_STATE_ACTUAL, (Object)"Application starting");
        ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this, START.getName());
        this.setExpectedStateAndRecordLifecycleEvent(Lifecycle.STARTING);
        try {
            try {
                this.preStart((Collection<? extends Location>)locationsToUse);
                Object val = this.config().get(START_LATCH);
                if (val != null) {
                    LOG.debug("{} finished waiting for start-latch; continuing...", (Object)this);
                }
                this.doStart((Collection<? extends Location>)locationsToUse);
                this.postStart((Collection<? extends Location>)locationsToUse);
            }
            catch (AbstractApplication.ProblemStartingChildrenException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (Exception e) {
                ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, START.getName(), (Object)Exceptions.collapseText((Throwable)e));
                throw Exceptions.propagate((Throwable)e);
            }
        }
        catch (Exception e) {
            this.recordApplicationEvent(Lifecycle.ON_FIRE);
            ServiceStateLogic.setExpectedStateRunningWithErrors((Entity)this);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this, Attributes.SERVICE_STATE_ACTUAL);
        }
    }

    public static class ServiceStateComputer
    extends AbstractMultipleSensorAggregator<Void>
    implements SensorEventListener<Object> {
        public static final String DEFAULT_UNIQUE_TAG = "async-service-state-computer";
        public static final ConfigKey<QuorumCheck> RUNNING_QUORUM_CHECK = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(QuorumCheck.class, "runningQuorumCheck").description("Logic for checking whether this service is running, based on children and/or members running (by default requires all, but ignores any that are stopping)")).defaultValue((QuorumCheck)QuorumCheck.QuorumChecks.all())).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
        public static final ConfigKey<QuorumCheck> UP_QUORUM_CHECK = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(QuorumCheck.class, "upQuorumCheck").description("Logic for checking whether this service is up, based on children and/or members (by default requires all)")).defaultValue((QuorumCheck)QuorumCheck.QuorumChecks.all())).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
        public static final ConfigKey<Set<Lifecycle>> ENTITY_FAILED_STATES = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<Set<Lifecycle>>(){}).name("entityFailedStates")).description("Service states that indicate a child/member has failed (by default just ON_FIRE will mean not healthy)")).defaultValue((ImmutableSet)ImmutableSet.of((Object)((Object)Lifecycle.ON_FIRE)))).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
        public static final ConfigKey<Set<Lifecycle>> ENTITY_TRANSITION_STATES_ON_STARTING = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<Set<Lifecycle>>(){}).name("entityTransitionStatesOnStarting")).description("Service states which indicate a child/member is still starting (used to compute when we have finished starting)")).defaultValue((Set)MutableSet.of(null, (Object)((Object)Lifecycle.CREATED), (Object)((Object)Lifecycle.STARTING), (Object[])new Lifecycle[0]).asUnmodifiable())).build();
        public static final ConfigKey<Set<Lifecycle>> ENTITY_IGNORED_STATES_ON_STARTING = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<Set<Lifecycle>>(){}).name("entityIgnoredStatesOnStarting")).description("Service states of a child/member that mean we'll ignore it, for calculating our own state when 'staring' (by default ignores children that are stopping/stopped)")).defaultValue((ImmutableSet)ImmutableSet.of((Object)((Object)Lifecycle.STOPPING), (Object)((Object)Lifecycle.STOPPED), (Object)((Object)Lifecycle.DESTROYED)))).build();
        public static final ConfigKey<Set<Lifecycle>> ENTITY_IGNORED_STATES_ON_OTHERS = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<Set<Lifecycle>>(){}).name("entityIgnoredStatesOnOthers")).description("Service states of a child/member that mean we'll ignore it, for calculating our own state when we are not 'staring' (by default ignores children that are starting/stopping)")).defaultValue((Set)MutableSet.of(null, (Object)((Object)Lifecycle.STOPPING), (Object)((Object)Lifecycle.STOPPED), (Object[])new Lifecycle[]{Lifecycle.DESTROYED, Lifecycle.CREATED, Lifecycle.STARTING}).asUnmodifiable())).build();
        public static final ConfigKey<Boolean> IGNORE_ENTITIES_WITH_SERVICE_UP_NULL = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("ignoreEntitiesWithServiceUpNull")).description("Whether to ignore children reporting null values for service up (i.e. don't treat them as 'down' when computing our own 'service.isUp')")).defaultValue(true)).build();
        static final Set<ConfigKey<?>> RECONFIGURABLE_KEYS = ImmutableSet.of(UP_QUORUM_CHECK, RUNNING_QUORUM_CHECK, ENTITY_IGNORED_STATES_ON_STARTING, ENTITY_IGNORED_STATES_ON_OTHERS, ENTITY_FAILED_STATES, ENTITY_TRANSITION_STATES_ON_STARTING, (Object[])new ConfigKey[0]);
        static final List<Sensor<?>> SOURCE_SENSORS = ImmutableList.of(Startable.SERVICE_UP, Attributes.SERVICE_STATE_ACTUAL);

        public AsyncApplicationImpl getEntity() {
            return (AsyncApplicationImpl)super.getEntity();
        }

        @Override
        protected void setEntityLoadingTargetConfig() {
            if (this.getConfig(TARGET_SENSOR) != null) {
                throw new IllegalArgumentException("Must not set " + TARGET_SENSOR + " when using " + this);
            }
        }

        @Override
        public void setEntity(EntityLocal entity) {
            if (!(entity instanceof AsyncApplicationImpl)) {
                throw new IllegalArgumentException("enricher designed to work only with async-apps");
            }
            if (!this.isRebinding() && Boolean.FALSE.equals(this.config().get(SUPPRESS_DUPLICATES))) {
                throw new IllegalArgumentException("Must not set " + SUPPRESS_DUPLICATES + " to false when using " + this);
            }
            super.setEntity(entity);
            if (this.suppressDuplicates == null) {
                this.suppressDuplicates = true;
            }
            this.subscriptions().subscribe((Entity)entity, Attributes.SERVICE_STATE_EXPECTED, new SensorEventListener<Lifecycle.Transition>(){

                public void onEvent(SensorEvent<Lifecycle.Transition> event) {
                    this.onUpdated();
                }
            });
        }

        @Override
        protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
            if (RECONFIGURABLE_KEYS.contains(key)) {
                return;
            }
            super.doReconfigureConfig(key, val);
        }

        @Override
        protected void onChanged() {
            super.onChanged();
            this.onUpdated();
        }

        @Override
        protected Collection<Sensor<?>> getSourceSensors() {
            return SOURCE_SENSORS;
        }

        @Override
        protected void onUpdated() {
            if (this.entity == null || !this.isRunning() || !Entities.isManaged((Entity)this.entity)) {
                BrooklynLogging.log(LOG, BrooklynLogging.levelDebugOrTraceIfReadOnly((Entity)this.entity), "Ignoring {} onUpdated when entity is not in valid state ({})", this, this.entity);
                return;
            }
            Lifecycle.Transition oldExpectedStateTransition = (Lifecycle.Transition)this.entity.sensors().get(Attributes.SERVICE_STATE_EXPECTED);
            Lifecycle oldExpectedState = oldExpectedStateTransition != null ? oldExpectedStateTransition.getState() : null;
            ValueAndReason<Boolean> newServiceUp = this.computeServiceUp(oldExpectedState);
            ValueAndReason<Lifecycle> newServiceState = this.computeServiceState(oldExpectedState);
            Lifecycle newExpectedState = this.computeExpectedState(oldExpectedState, (Lifecycle)((Object)newServiceState.val));
            this.emit(Attributes.SERVICE_STATE_ACTUAL, newServiceState.val);
            this.emit(Attributes.SERVICE_UP, newServiceUp.val);
            if (Boolean.TRUE.equals(newServiceUp.val)) {
                ServiceStateLogic.clearMapSensorEntry((Entity)this.entity, Attributes.SERVICE_NOT_UP_INDICATORS, DEFAULT_UNIQUE_TAG);
            } else {
                ServiceStateLogic.updateMapSensorEntry((Entity)this.entity, Attributes.SERVICE_NOT_UP_INDICATORS, DEFAULT_UNIQUE_TAG, newServiceUp.reason);
            }
            if (newServiceState.val != null && newServiceState.val == Lifecycle.ON_FIRE) {
                ServiceStateLogic.updateMapSensorEntry((Entity)this.entity, Attributes.SERVICE_PROBLEMS, DEFAULT_UNIQUE_TAG, newServiceState.reason);
            } else {
                ServiceStateLogic.clearMapSensorEntry((Entity)this.entity, Attributes.SERVICE_PROBLEMS, DEFAULT_UNIQUE_TAG);
            }
            if (oldExpectedState != newExpectedState) {
                this.getEntity().setExpectedStateAndRecordLifecycleEvent(newExpectedState);
            }
        }

        protected ValueAndReason<Boolean> computeServiceUp(Lifecycle expectedState) {
            boolean ignoreNull = this.getConfig(IGNORE_ENTITIES_WITH_SERVICE_UP_NULL);
            Set<Lifecycle> ignoredStates = expectedState == Lifecycle.STARTING ? this.getConfig(ENTITY_IGNORED_STATES_ON_STARTING) : this.getConfig(ENTITY_IGNORED_STATES_ON_OTHERS);
            Map<Entity, Boolean> values = this.getValues(Startable.SERVICE_UP);
            MutableList violators = MutableList.of();
            int entries = 0;
            int numUp = 0;
            for (Map.Entry<Entity, Boolean> entry : values.entrySet()) {
                Lifecycle entityState = (Lifecycle)((Object)entry.getKey().getAttribute(Attributes.SERVICE_STATE_ACTUAL));
                if (ignoreNull && entry.getValue() == null || ignoredStates.contains((Object)entityState)) continue;
                ++entries;
                if (Boolean.TRUE.equals(entry.getValue())) {
                    ++numUp;
                    continue;
                }
                violators.add(entry.getKey());
            }
            QuorumCheck qc = this.getRequiredConfig(UP_QUORUM_CHECK);
            if (qc.isQuorate(numUp, violators.size() + numUp)) {
                return new ValueAndReason<Boolean>(Boolean.TRUE, "quorate");
            }
            String reason = values.isEmpty() ? "No entities present" : (entries == 0 ? "No entities (in correct state) publishing service up" : (violators.isEmpty() ? "Not enough entities" : (violators.size() == 1 ? violators.get(0) + " is not up" : (violators.size() == entries ? "None of the entities are up" : violators.size() + " entities are not up, including " + violators.get(0)))));
            return new ValueAndReason<Boolean>(Boolean.FALSE, reason);
        }

        protected ValueAndReason<Lifecycle> computeServiceState(Lifecycle expectedState) {
            if (expectedState != null && expectedState != Lifecycle.STARTING && expectedState != Lifecycle.RUNNING) {
                return new ValueAndReason<Lifecycle>(expectedState, "expected state " + (Object)((Object)expectedState));
            }
            Set<Lifecycle> ignoredStates = expectedState == Lifecycle.STARTING ? this.getConfig(ENTITY_IGNORED_STATES_ON_STARTING) : this.getConfig(ENTITY_IGNORED_STATES_ON_OTHERS);
            Set<Lifecycle> transitionStates = expectedState == Lifecycle.STARTING ? this.getConfig(ENTITY_TRANSITION_STATES_ON_STARTING) : ImmutableSet.of();
            Map<Entity, Lifecycle> values = this.getValues(Attributes.SERVICE_STATE_ACTUAL);
            MutableList violators = MutableList.of();
            int entries = 0;
            int numRunning = 0;
            int numTransitioning = 0;
            for (Map.Entry<Entity, Lifecycle> entry : values.entrySet()) {
                if (ignoredStates.contains((Object)entry.getValue())) continue;
                ++entries;
                if (entry.getValue() == Lifecycle.RUNNING) {
                    ++numRunning;
                    continue;
                }
                if (transitionStates.contains((Object)entry.getValue())) {
                    ++numTransitioning;
                    continue;
                }
                violators.add(entry.getKey());
            }
            QuorumCheck qc = this.getConfig(RUNNING_QUORUM_CHECK);
            if (qc.isQuorate(numRunning, violators.size() + numRunning + numTransitioning)) {
                return new ValueAndReason<Lifecycle>(Lifecycle.RUNNING, "quorate");
            }
            boolean canEverBeQuorate = qc.isQuorate(numRunning + numTransitioning, violators.size() + numRunning + numTransitioning);
            if (expectedState == Lifecycle.STARTING && canEverBeQuorate) {
                return new ValueAndReason<Lifecycle>(Lifecycle.STARTING, "not yet quorate");
            }
            String reason = values.isEmpty() ? "No entities present" : (entries == 0 ? "No entities in interesting states" : (violators.isEmpty() ? "Not enough entities" : (violators.size() == 1 ? violators.get(0) + " is not healthy" : (violators.size() == entries ? "None of the entities are healthy" : violators.size() + " entities are not healthy, including " + violators.get(0)))));
            return new ValueAndReason<Lifecycle>(Lifecycle.ON_FIRE, reason);
        }

        protected Lifecycle computeExpectedState(Lifecycle oldExpectedState, Lifecycle newActualState) {
            boolean childIsStarting;
            if (oldExpectedState != Lifecycle.STARTING) {
                return oldExpectedState;
            }
            Map<Entity, Lifecycle> values = this.getValues(Attributes.SERVICE_STATE_ACTUAL);
            boolean bl = childIsStarting = values.containsValue((Object)Lifecycle.STARTING) || values.containsValue((Object)Lifecycle.CREATED) || values.containsValue(null);
            if (!childIsStarting) {
                return Lifecycle.RUNNING;
            }
            return oldExpectedState;
        }

        @Override
        protected Object compute() {
            return null;
        }

        static class ValueAndReason<T> {
            final T val;
            final String reason;

            ValueAndReason(T val, String reason) {
                this.val = val;
                this.reason = reason;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("val", this.val).add("reason", (Object)this.reason).toString();
            }
        }
    }
}

