/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.rabbit;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.entity.messaging.Queue;
import org.apache.brooklyn.entity.messaging.rabbit.RabbitDestination;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshFeed;
import org.apache.brooklyn.feed.ssh.SshPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;

public class RabbitQueue
extends RabbitDestination
implements Queue {
    private SshFeed sshFeed;

    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public void create() {
        this.sensors().set((AttributeSensor)QUEUE_NAME, (Object)this.getName());
        super.create();
    }

    @Override
    protected void connectSensors() {
        String runDir = this.getParent().getRunDir();
        String cmd = String.format("%s/sbin/rabbitmqctl list_queues -p /%s  | grep '%s'", runDir, this.getVirtualHost(), this.getQueueName());
        this.sshFeed = (SshFeed)((SshFeed.Builder)((SshFeed.Builder)SshFeed.builder().entity((Entity)this)).machine((MachineLocation)this.machine)).poll((CommandPollConfig)((CommandPollConfig)new SshPollConfig(QUEUE_DEPTH_BYTES).env(this.shellEnvironment).command(cmd).onFailure(Functions.constant((Object)-1))).onSuccess((Function)new Function<SshPollValue, Integer>(){

            public Integer apply(SshPollValue input) {
                return 0;
            }
        })).poll((CommandPollConfig)((CommandPollConfig)new SshPollConfig(QUEUE_DEPTH_MESSAGES).env(this.shellEnvironment).command(cmd).onFailure(Functions.constant((Object)-1))).onSuccess((Function)new Function<SshPollValue, Integer>(){

            public Integer apply(SshPollValue input) {
                return 0;
            }
        })).build();
    }

    @Override
    protected void disconnectSensors() {
        if (this.sshFeed != null) {
            this.sshFeed.stop();
        }
        super.disconnectSensors();
    }

    @Override
    public String getQueueName() {
        return this.getName();
    }
}

