/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.location.docker;

import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationResolver;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.container.location.docker.DockerJcloudsLocation;
import org.apache.brooklyn.core.location.AbstractLocationResolver;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.LocationPropertiesFromBrooklynProperties;
import org.apache.brooklyn.location.jclouds.JcloudsPropertiesFromBrooklynProperties;
import org.apache.brooklyn.util.collections.MutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerLocationResolver
extends AbstractLocationResolver
implements LocationResolver {
    public static final Logger log = LoggerFactory.getLogger(DockerLocationResolver.class);
    public static final String PREFIX = "docker";

    public boolean isEnabled() {
        return LocationConfigUtils.isResolverPrefixEnabled((ManagementContext)this.managementContext, (String)this.getPrefix());
    }

    public String getPrefix() {
        return PREFIX;
    }

    protected Class<? extends Location> getLocationType() {
        return DockerJcloudsLocation.class;
    }

    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"docker\"");
    }

    protected Map<String, Object> getFilteredLocationProperties(String provider, String namedLocation, Map<String, ?> prioritisedProperties, Map<String, ?> globalProperties) {
        Map dockerConf = new LocationPropertiesFromBrooklynProperties().getLocationProperties(this.getPrefix(), namedLocation, globalProperties);
        Object providerInConf = dockerConf.get("provider");
        if (providerInConf != null && !provider.equals(providerInConf)) {
            throw new IllegalArgumentException(provider + " location configured with provider '" + providerInConf + "', but must be blank or '" + provider + "'");
        }
        String providerOrApi = PREFIX;
        String regionName = (String)prioritisedProperties.get("region");
        Map jcloudsConf = new JcloudsPropertiesFromBrooklynProperties().getJcloudsProperties(providerOrApi, regionName, namedLocation, globalProperties);
        return MutableMap.builder().putAll(jcloudsConf).putAll(dockerConf).put((Object)"provider", (Object)providerOrApi).build();
    }
}

