/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.couchbase;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolver;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseCluster;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseNode;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseSyncGateway;
import org.apache.brooklyn.entity.nosql.couchbase.CouchbaseSyncGatewayDriver;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;

public class CouchbaseSyncGatewaySshDriver
extends AbstractSoftwareProcessSshDriver
implements CouchbaseSyncGatewayDriver {
    public CouchbaseSyncGatewaySshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public void stop() {
    }

    public void install() {
        DownloadResolver resolver = Entities.newDownloader((EntityDriver)this);
        List urls = resolver.getTargets();
        String saveAs = resolver.getFilename();
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        log.info("Installing couchbase-sync-gateway version: {}", (Object)this.getVersion());
        if (osDetails.isLinux()) {
            List<String> commands = this.installLinux(urls, saveAs);
            this.newScript((String)"installing").body.append(commands).execute();
        }
    }

    public void customize() {
    }

    public void launch() {
        Entity cbNode = (Entity)this.entity.getConfig(CouchbaseSyncGateway.COUCHBASE_SERVER);
        Entities.waitForServiceUp((Entity)cbNode, (Duration)Duration.ONE_HOUR);
        DependentConfiguration.waitInTaskForAttributeReady((Entity)cbNode, CouchbaseCluster.IS_CLUSTER_INITIALIZED, (Predicate)Predicates.equalTo((Object)true));
        Time.sleep((long)10000L);
        if (cbNode instanceof CouchbaseCluster) {
            Optional cbClusterNode = Iterables.tryFind((Iterable)((Iterable)cbNode.getAttribute(CouchbaseCluster.GROUP_MEMBERS)), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(CouchbaseNode.class), (Predicate)EntityPredicates.attributeEqualTo(CouchbaseNode.IS_IN_CLUSTER, (Object)Boolean.TRUE)));
            if (!cbClusterNode.isPresent()) {
                throw new IllegalArgumentException(String.format("The cluster %s does not contain any suitable Couchbase nodes to connect to..", cbNode.getId()));
            }
            cbNode = (Entity)cbClusterNode.get();
        }
        String hostname = (String)cbNode.getAttribute(CouchbaseNode.HOSTNAME);
        String webPort = ((Integer)cbNode.getAttribute((AttributeSensor)CouchbaseNode.COUCHBASE_WEB_ADMIN_PORT)).toString();
        String username = (String)cbNode.getConfig(CouchbaseNode.COUCHBASE_ADMIN_USERNAME);
        String password = (String)cbNode.getConfig(CouchbaseNode.COUCHBASE_ADMIN_PASSWORD);
        String bucketName = (String)this.entity.getConfig(CouchbaseSyncGateway.COUCHBASE_SERVER_BUCKET);
        String pool = (String)this.entity.getConfig(CouchbaseSyncGateway.COUCHBASE_SERVER_POOL);
        String pretty = (Boolean)this.entity.getConfig(CouchbaseSyncGateway.PRETTY) != false ? "-pretty" : "";
        String verbose = (Boolean)this.entity.getConfig(CouchbaseSyncGateway.VERBOSE) != false ? "-verbose" : "";
        String adminRestApiPort = ((Integer)((PortRange)this.entity.getConfig((ConfigKey.HasConfigKey)CouchbaseSyncGateway.ADMIN_REST_API_PORT)).iterator().next()).toString();
        String syncRestApiPort = ((Integer)((PortRange)this.entity.getConfig((ConfigKey.HasConfigKey)CouchbaseSyncGateway.SYNC_REST_API_PORT)).iterator().next()).toString();
        String serverWebAdminUrl = String.format("http://%s:%s@%s:%s", username, password, hostname, webPort);
        String options = String.format("-url %s -bucket %s -adminInterface 0.0.0.0:%s -interface 0.0.0.0:%s -pool %s %s %s", serverWebAdminUrl, bucketName, adminRestApiPort, syncRestApiPort, pool, pretty, verbose);
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").body.append((CharSequence)(String.format("/opt/couchbase-sync-gateway/bin/sync_gateway %s ", options) + "> out.log 2> err.log < /dev/null &")).failOnNonZeroResultCode().execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "check-running").execute() == 0;
    }

    public void kill() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "killing").execute();
    }

    private List<String> installLinux(List<String> urls, String saveAs) {
        String apt = BashCommands.chainGroup((String[])new String[]{"which apt-get", BashCommands.sudo((String)"apt-get update"), BashCommands.sudo((String)String.format("dpkg -i %s", saveAs))});
        String yum = BashCommands.chainGroup((String[])new String[]{"which yum", BashCommands.sudo((String)String.format("rpm --install %s", saveAs))});
        return ImmutableList.builder().add((Object)BashCommands.INSTALL_CURL).addAll((Iterable)BashCommands.commandsToDownloadUrlsAs(urls, (String)saveAs)).add((Object)BashCommands.alternatives((String[])new String[]{apt, yum})).build();
    }

    @Override
    public String getOsTag() {
        OsDetails os = this.getLocation().getOsDetails();
        if (os == null) {
            return "x86_64.rpm";
        }
        String osName = os.getName().toLowerCase();
        String fileExtension = osName.contains("deb") || osName.contains("ubuntu") ? ".deb" : ".rpm";
        String arch = os.is64bit() ? "x86_64" : "x86";
        return arch + fileExtension;
    }
}

