/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

public class HighAvailabilitySummary
implements Serializable {
    private static final long serialVersionUID = -317333127094471223L;
    private final String planeId;
    private final String ownId;
    private final String masterId;
    private final Map<String, HaNodeSummary> nodes;
    private final Map<String, URI> links;

    public HighAvailabilitySummary(@JsonProperty(value="planeId") String planeId, @JsonProperty(value="ownId") String ownId, @JsonProperty(value="masterId") String masterId, @JsonProperty(value="nodes") Map<String, HaNodeSummary> nodes, @JsonProperty(value="links") Map<String, URI> links) {
        this.planeId = planeId;
        this.ownId = ownId;
        this.masterId = masterId;
        this.nodes = nodes == null ? ImmutableMap.of() : nodes;
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    public String getPlaneId() {
        return this.planeId;
    }

    public String getOwnId() {
        return this.ownId;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public Map<String, HaNodeSummary> getNodes() {
        return this.nodes;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HighAvailabilitySummary)) {
            return false;
        }
        HighAvailabilitySummary that = (HighAvailabilitySummary)o;
        return Objects.equals(this.planeId, that.planeId) && Objects.equals(this.ownId, that.ownId) && Objects.equals(this.masterId, that.masterId) && Objects.equals(this.nodes, that.nodes) && Objects.equals(this.links, that.links);
    }

    public int hashCode() {
        return Objects.hash(this.ownId, this.masterId, this.nodes, this.links);
    }

    public String toString() {
        return "HighAvailabilitySummary{ownId='" + this.ownId + '\'' + ", masterId='" + this.masterId + '\'' + ", nodes=" + this.nodes + ", links=" + this.links + '}';
    }

    public static class HaNodeSummary
    implements Serializable {
        private static final long serialVersionUID = 9205960988226816539L;
        private final String nodeId;
        private final URI nodeUri;
        private final String status;
        private final Long localTimestamp;
        private final Long remoteTimestamp;

        public HaNodeSummary(@JsonProperty(value="nodeId") String nodeId, @JsonProperty(value="nodeUri") URI nodeUri, @JsonProperty(value="status") String status, @JsonProperty(value="localTimestamp") Long localTimestamp, @JsonProperty(value="remoteTimestamp") Long remoteTimestamp) {
            this.nodeId = nodeId;
            this.nodeUri = nodeUri;
            this.status = status;
            this.localTimestamp = localTimestamp;
            this.remoteTimestamp = remoteTimestamp;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public URI getNodeUri() {
            return this.nodeUri;
        }

        public String getStatus() {
            return this.status;
        }

        public Long getLocalTimestamp() {
            return this.localTimestamp;
        }

        public Long getRemoteTimestamp() {
            return this.remoteTimestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HaNodeSummary)) {
                return false;
            }
            HaNodeSummary that = (HaNodeSummary)o;
            return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.nodeUri, that.nodeUri) && Objects.equals(this.status, that.status) && Objects.equals(this.localTimestamp, that.localTimestamp) && Objects.equals(this.remoteTimestamp, that.remoteTimestamp);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.nodeUri, this.status, this.localTimestamp, this.remoteTimestamp);
        }

        public String toString() {
            return "HaNodeSummary{nodeId='" + this.nodeId + '\'' + ", nodeUri=" + this.nodeUri + ", status='" + this.status + '\'' + ", localTimestamp=" + this.localTimestamp + ", remoteTimestamp=" + this.remoteTimestamp + '}';
        }
    }
}

