/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import java.net.URI;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.Disk;
import org.jclouds.azurecompute.arm.domain.DiskProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Compute/disks")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface DiskApi {
    @Named(value="disk:list")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Disk> list();

    @Named(value="disk:create_or_update")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/{diskName}")
    public Disk createOrUpdate(@PathParam(value="diskName") String var1, @PayloadParam(value="location") String var2, @PayloadParam(value="properties") DiskProperties var3);

    @Named(value="disk:get")
    @Path(value="/{diskName}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Disk get(@PathParam(value="diskName") String var1);

    @Named(value="disk:delete")
    @Path(value="/{diskName}")
    @DELETE
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="diskName") String var1);
}

