/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.brooklyn.api.AssemblyTemplateSpecInstantiator;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import org.apache.brooklyn.camp.brooklyn.spi.creation.CampInternalUtils;
import org.apache.brooklyn.camp.brooklyn.spi.creation.CampResolver;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.camp.spi.Assembly;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.PlatformComponentTemplate;
import org.apache.brooklyn.camp.spi.collection.ResolvableLink;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.core.mgmt.HasBrooklynManagementContext;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynAssemblyTemplateInstantiator
implements AssemblyTemplateSpecInstantiator {
    private static final Logger log = LoggerFactory.getLogger(BrooklynAssemblyTemplateInstantiator.class);
    public static final String NEVER_UNWRAP_APPS_PROPERTY = "wrappedApp";

    public Assembly instantiate(AssemblyTemplate template, CampPlatform platform) {
        Application app = this.create(template, platform);
        EntityManagementUtils.CreationResult start = EntityManagementUtils.start((Application)app);
        log.debug("CAMP created " + app + "; starting in " + start.task());
        return (Assembly)platform.assemblies().get(app.getApplicationId());
    }

    private Application create(AssemblyTemplate template, CampPlatform platform) {
        ManagementContext mgmt = BrooklynAssemblyTemplateInstantiator.getManagementContext(platform);
        JavaBrooklynClassLoadingContext loader = JavaBrooklynClassLoadingContext.create((ManagementContext)mgmt);
        EntitySpec<? extends Application> spec = this.createApplicationSpec(template, platform, (BrooklynClassLoadingContext)loader, (Set<String>)MutableSet.of());
        Application instance = (Application)mgmt.getEntityManager().createEntity(spec);
        log.info("CAMP created '{}'", (Object)instance);
        return instance;
    }

    @Override
    public List<EntitySpec<?>> createServiceSpecs(AssemblyTemplate template, CampPlatform platform, BrooklynClassLoadingContext itemLoader, Set<String> encounteredRegisteredTypeIds) {
        return this.buildTemplateServicesAsSpecs(itemLoader, template, platform, encounteredRegisteredTypeIds);
    }

    @Override
    public EntitySpec<? extends Application> createApplicationSpec(AssemblyTemplate template, CampPlatform platform, BrooklynClassLoadingContext loader, Set<String> encounteredTypeSymbolicNames) {
        if (BasicBrooklynCatalog.currentlyResolvingType.get() != null) {
            if (log.isTraceEnabled()) {
                log.trace("CAMP instantiating application to resolve {} ({} / {})", new Object[]{BasicBrooklynCatalog.currentlyResolvingType.get(), template.getId(), CampResolver.currentlyCreatingSpec.get()});
            }
        } else {
            log.debug("CAMP instantiating application for {} ({})", (Object)template.getId(), CampResolver.currentlyCreatingSpec.get());
        }
        EntitySpec app = CampInternalUtils.createWrapperApp(template, loader);
        app.configure(EntityManagementUtils.WRAPPER_APP_MARKER, (Object)Boolean.TRUE);
        List<EntitySpec<?>> childSpecs = this.createServiceSpecs(template, platform, loader, encounteredTypeSymbolicNames);
        for (EntitySpec<?> childSpec : childSpecs) {
            app.child(EntityManagementUtils.unwrapEntity(childSpec));
        }
        if (this.allowedToUnwrap(template, app)) {
            app = EntityManagementUtils.unwrapApplication(app);
        }
        return app;
    }

    private boolean allowedToUnwrap(AssemblyTemplate template, EntitySpec<? extends Application> app) {
        return !Boolean.TRUE.equals(TypeCoercions.coerce(template.getCustomAttributes().get(NEVER_UNWRAP_APPS_PROPERTY), Boolean.class));
    }

    private List<EntitySpec<?>> buildTemplateServicesAsSpecs(BrooklynClassLoadingContext loader, AssemblyTemplate template, CampPlatform platform, Set<String> encounteredRegisteredTypeIds) {
        ArrayList result = Lists.newArrayList();
        for (ResolvableLink ctl : template.getPlatformComponentTemplates().links()) {
            PlatformComponentTemplate appChildComponentTemplate = (PlatformComponentTemplate)ctl.resolve();
            BrooklynComponentTemplateResolver entityResolver = BrooklynComponentTemplateResolver.Factory.newInstance(loader, (AbstractResource)appChildComponentTemplate);
            EntitySpec spec = entityResolver.resolveSpec(encounteredRegisteredTypeIds);
            result.add(spec);
        }
        return result;
    }

    private static ManagementContext getManagementContext(CampPlatform platform) {
        return ((HasBrooklynManagementContext)platform).getBrooklynManagementContext();
    }
}

