/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.hazelcast;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.entity.nosql.hazelcast.HazelcastCluster;
import org.apache.brooklyn.entity.nosql.hazelcast.HazelcastNode;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastClusterImpl
extends DynamicClusterImpl
implements HazelcastCluster {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastClusterImpl.class);
    private static final AtomicInteger nextMemberId = new AtomicInteger(0);

    protected EntitySpec<?> getMemberSpec() {
        EntitySpec spec = EntitySpec.create((EntitySpec)((EntitySpec)this.config().get(HazelcastCluster.MEMBER_SPEC)));
        spec.configure(HazelcastNode.NODE_CLUSTER_NAME, this.config().get(HazelcastCluster.CLUSTER_NAME));
        spec.configure(HazelcastNode.GROUP_NAME, this.config().get(HazelcastCluster.CLUSTER_NAME));
        if (LOG.isInfoEnabled()) {
            LOG.info("Cluster name : {} : used as a group name", this.getConfig(HazelcastNode.GROUP_NAME));
        }
        spec.configure(HazelcastNode.GROUP_PASSWORD, (Object)this.getClusterPassword());
        return spec;
    }

    public void init() {
        super.init();
        String clusterPassword = this.getClusterPassword();
        if (Strings.isBlank((CharSequence)clusterPassword)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(this + " cluster password not provided for " + CLUSTER_PASSWORD.getName() + " : generating random password");
            }
            this.config().set(CLUSTER_PASSWORD, (Object)Identifiers.makeRandomPassword((int)12));
        }
        this.policies().add((PolicySpec)((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Hazelcast members tracker")).configure((CharSequence)"group", (Object)this));
    }

    @Override
    public String getClusterName() {
        return (String)this.getConfig((ConfigKey.HasConfigKey)CLUSTER_NAME);
    }

    @Override
    public String getClusterPassword() {
        return (String)this.getConfig(CLUSTER_PASSWORD);
    }

    protected void initEnrichers() {
        super.initEnrichers();
    }

    public void start(Collection<? extends Location> locations) {
        super.start(locations);
        ArrayList clusterNodes = Lists.newArrayList();
        for (Entity member : this.getMembers()) {
            clusterNodes.add(member.getAttribute(Attributes.ADDRESS));
        }
        this.sensors().set(PUBLIC_CLUSTER_NODES, (Object)clusterNodes);
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityChange(Entity member) {
        }

        protected void onEntityAdded(Entity member) {
            if (member.getAttribute((AttributeSensor)HazelcastNode.NODE_NAME) == null) {
                ((EntityInternal)member).sensors().set((AttributeSensor)HazelcastNode.NODE_NAME, (Object)("hazelcast-" + nextMemberId.incrementAndGet()));
                if (LOG.isInfoEnabled()) {
                    LOG.info("Node {} added to the cluster", (Object)member);
                }
            }
        }

        protected void onEntityRemoved(Entity member) {
        }
    }
}

