/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.winrm;

import com.google.common.base.Suppliers;
import java.io.InputStream;
import java.io.Reader;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.location.winrm.WinRmPutTaskStub;
import org.apache.brooklyn.location.winrm.WinRmPutTaskWrapper;
import org.apache.brooklyn.util.stream.KnownSizeInputStream;
import org.apache.brooklyn.util.stream.ReaderInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmPutTaskFactory
extends WinRmPutTaskStub
implements TaskFactory<WinRmPutTaskWrapper> {
    private static final Logger log = LoggerFactory.getLogger(WinRmPutTaskFactory.class);
    private boolean dirty = false;

    public WinRmPutTaskFactory(String remoteFile) {
        this.remoteFile(remoteFile);
    }

    public WinRmPutTaskFactory(WinRmMachineLocation machine, String remoteFile) {
        this.machine(machine);
        this.remoteFile(remoteFile);
    }

    protected WinRmPutTaskFactory self() {
        return this;
    }

    protected void markDirty() {
        this.dirty = true;
    }

    public WinRmPutTaskFactory machine(WinRmMachineLocation machine) {
        this.markDirty();
        this.machine = machine;
        return this.self();
    }

    public WinRmPutTaskFactory remoteFile(String remoteFile) {
        this.remoteFile = remoteFile;
        return this.self();
    }

    public WinRmPutTaskFactory summary(String summary) {
        this.markDirty();
        this.summary = summary;
        return this.self();
    }

    public WinRmPutTaskFactory contents(String contents) {
        this.markDirty();
        this.contents = Suppliers.ofInstance((Object)KnownSizeInputStream.of((String)contents));
        return this.self();
    }

    public WinRmPutTaskFactory contents(byte[] contents) {
        this.markDirty();
        this.contents = Suppliers.ofInstance((Object)KnownSizeInputStream.of((byte[])contents));
        return this.self();
    }

    public WinRmPutTaskFactory contents(InputStream stream) {
        this.markDirty();
        this.contents = Suppliers.ofInstance((Object)stream);
        return this.self();
    }

    public WinRmPutTaskFactory contents(Reader reader) {
        this.markDirty();
        this.contents = Suppliers.ofInstance((Object)new ReaderInputStream(reader));
        return this.self();
    }

    public WinRmPutTaskFactory allowFailure() {
        this.markDirty();
        this.allowFailure = true;
        return this.self();
    }

    public WinRmPutTaskFactory createDirectory() {
        this.markDirty();
        this.createDirectory = true;
        return this.self();
    }

    public WinRmPutTaskWrapper newTask() {
        this.dirty = false;
        return new WinRmPutTaskWrapper(this);
    }

    protected void finalize() throws Throwable {
        if (this.dirty) {
            log.warn("Task " + this + " was modified but modification was never used");
        }
        super.finalize();
    }
}

