/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigConstraints;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourcePredicates;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;

@Beta
public class ConstraintSerialization {
    private final Map<String, String> predicateToStringToPreferredName = MutableMap.of();
    private final Map<String, Function<List<?>, Predicate<?>>> predicatePreferredNameToConstructor = MutableMap.of();
    private static String DOUBLE_QUOTED_STRING = "\"" + ConstraintSerialization.GROUP(ConstraintSerialization.ZERO_OR_MORE(ConstraintSerialization.OR_GROUP(ConstraintSerialization.NOT_CHARSET("\\", "\""), "\\."))) + "\"";
    private static String SINGLE_QUOTED_STRING = "'" + ConstraintSerialization.GROUP(ConstraintSerialization.ZERO_OR_MORE(ConstraintSerialization.OR_GROUP(ConstraintSerialization.NOT_CHARSET("\\", "'"), "\\."))) + "'";
    private static String SQUARE_BRACKETS = "\\[" + ConstraintSerialization.GROUP(ConstraintSerialization.ZERO_OR_MORE(ConstraintSerialization.OR_GROUP(ConstraintSerialization.NOT_CHARSET("\\", "["), "\\."))) + "\\]";
    private static String PREDICATE = "[A-Za-z0-9_\\-\\.]+";
    private static Pattern PATTERN_START_WITH_QUOTED_STRING = Pattern.compile("^" + ConstraintSerialization.OR_GROUP(DOUBLE_QUOTED_STRING, SINGLE_QUOTED_STRING));
    private static Pattern PATTERN_START_WITH_ARRAY = Pattern.compile("^" + ConstraintSerialization.OR_GROUP(SQUARE_BRACKETS));
    private static Pattern PATTERN_START_WITH_PREDICATE = Pattern.compile("^" + ConstraintSerialization.GROUP(PREDICATE));
    public static final ConstraintSerialization INSTANCE = new ConstraintSerialization();

    private static String GROUP(String in) {
        return "(" + in + ")";
    }

    private static String NOT_CHARSET(String ... in) {
        return "[^" + Strings.join((Object[])in, (String)"") + "]";
    }

    private static String OR_GROUP(String ... in) {
        return ConstraintSerialization.GROUP(Strings.join((Object[])in, (String)"|"));
    }

    private static String ZERO_OR_MORE(String in) {
        return in + "*";
    }

    private void init() {
        PredicateSerializationRuleAdder.predicateListConstructor(o -> ConfigConstraints.required()).equivalentPredicates(StringPredicates.isNonBlank()).add(this);
        PredicateSerializationRuleAdder.predicateListConstructor(o -> Predicates.or((Iterable)o)).preferredName("any").equivalentNames("or").add(this);
        PredicateSerializationRuleAdder.predicateListConstructor(o -> this.toPredicateFromJson(o)).preferredName("all").sample(Predicates.and(Collections.emptyList())).equivalentNames("and").add(this);
        PredicateSerializationRuleAdder.noArgConstructor(Predicates::alwaysFalse).add(this);
        PredicateSerializationRuleAdder.noArgConstructor(Predicates::alwaysTrue).add(this);
        PredicateSerializationRuleAdder.noArgConstructor(Predicates::notNull).add(this);
        PredicateSerializationRuleAdder.noArgConstructor(ResourcePredicates::urlExists).preferredName("urlExists").add(this);
        PredicateSerializationRuleAdder.noArgConstructor(StringPredicates::isBlank).add(this);
        PredicateSerializationRuleAdder.stringConstructor(StringPredicates::matchesRegex).preferredName("regex").add(this);
        PredicateSerializationRuleAdder.stringConstructor(StringPredicates::matchesGlob).preferredName("glob").add(this);
        PredicateSerializationRuleAdder.stringConstructor(ConfigConstraints::forbiddenIf).add(this);
        PredicateSerializationRuleAdder.stringConstructor(ConfigConstraints::forbiddenUnless).add(this);
        PredicateSerializationRuleAdder.stringConstructor(ConfigConstraints::requiredIf).add(this);
        PredicateSerializationRuleAdder.stringConstructor(ConfigConstraints::requiredUnless).add(this);
        PredicateSerializationRuleAdder.listConstructor(ConfigConstraints::requiredUnlessAnyOf).add(this);
        PredicateSerializationRuleAdder.listConstructor(ConfigConstraints::forbiddenUnlessAnyOf).add(this);
    }

    private ConstraintSerialization() {
        this.init();
    }

    public List<Object> toJsonList(ConfigKey<?> config) {
        return this.toJsonList(config.getConstraint());
    }

    public List<Object> toJsonList(Predicate<?> constraint) {
        try {
            return this.toExactJsonList(this.toPredicateFromJson(this.toExactJsonList(constraint)));
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            try {
                return this.toExactJsonList(constraint);
            }
            catch (Exception e2) {
                Exceptions.propagateIfFatal((Throwable)e);
                return Collections.singletonList(constraint.toString());
            }
        }
    }

    public List<Object> toExactJsonList(Predicate<?> constraint) {
        StringConstraintParser parser = StringConstraintParser.forConstraint(this, Strings.toString(constraint));
        if (!parser.parse()) {
            throw new IllegalStateException("cannot match: " + constraint);
        }
        if (parser.result instanceof Map && ((Map)parser.result).size() == 1 && ((Map)parser.result).containsKey("all")) {
            return (List)((Map)parser.result).get("all");
        }
        if ("Predicates.alwaysTrue".equals(parser.result)) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)parser.result);
    }

    private void collectPredicateListFromJson(Object o, Collection<Predicate<?>> result) {
        if (o instanceof Collection) {
            ((Collection)o).stream().forEach(i -> this.collectPredicateListFromJson(i, result));
            return;
        }
        Predicate<?> p = this.toPredicateFromJson(o);
        if (Predicates.alwaysTrue().equals(p)) {
            return;
        }
        result.add(p);
    }

    public Predicate<?> toPredicateFromJson(Object o) {
        Object args;
        String key;
        if (o instanceof Collection) {
            Predicate<?> result2 = this.and(this.toPredicateListFromJsonList((Collection)o));
            return result2;
        }
        if (o instanceof String) {
            key = (String)o;
            if (key.indexOf("(") >= 0) {
                StringConstraintParser parser = StringConstraintParser.forConstraint(this, key);
                if (!parser.parse()) {
                    Object a = parser.result;
                    throw new IllegalStateException("cannot match: " + key);
                }
                return this.toPredicateFromJson(parser.result);
            }
            args = MutableList.of();
        } else if (o instanceof Map) {
            if (((Map)o).size() != 1) {
                throw new IllegalArgumentException("Unsupported constraint; map input should have a single key: " + o);
            }
            key = (String)Iterables.getOnlyElement(((Map)o).keySet());
            Object v = Iterables.getOnlyElement(((Map)o).values());
            args = v instanceof Iterable ? MutableList.copyOf((Iterable)((Iterable)v)) : Collections.singletonList(v);
        } else {
            if (o instanceof Predicate) {
                return (Predicate)o;
            }
            throw new IllegalArgumentException("Unsupported constraint; constraint should be string, list, or single-key map: " + o);
        }
        Function<List<?>, Predicate<?>> constructor = this.predicatePreferredNameToConstructor.get(key);
        if (constructor == null) {
            String preferredName = this.predicateToStringToPreferredName.get(key);
            if (preferredName != null) {
                constructor = this.predicatePreferredNameToConstructor.get(preferredName);
                if (constructor == null) {
                    throw new IllegalArgumentException("Incomplete constraint: " + key + ", maps to " + preferredName + ", but no constructor known");
                }
            } else {
                throw new IllegalArgumentException("Unsupported constraint: " + key);
            }
        }
        return constructor.apply((List<?>)args);
    }

    private <T> Predicate<?> and(Iterable<Predicate<? super T>> preds) {
        Iterator<Predicate<T>> pi = preds.iterator();
        if (!pi.hasNext()) {
            return Predicates.alwaysTrue();
        }
        Predicate<? super T> first = pi.next();
        if (!pi.hasNext()) {
            return first;
        }
        return Predicates.and(preds);
    }

    public List<Predicate<?>> toPredicateListFromJsonList(Collection<?> o) {
        MutableSet result = MutableSet.of();
        this.collectPredicateListFromJson(o, (Collection<Predicate<?>>)result);
        return MutableList.copyOf((Iterable)result);
    }

    private static class StringConstraintParser {
        ConstraintSerialization serialization;
        String remaining;
        Object result;
        List<Object> resultList = MutableList.of();
        boolean list = false;

        private StringConstraintParser() {
        }

        static StringConstraintParser forConstraint(ConstraintSerialization serialization, String in) {
            StringConstraintParser result = new StringConstraintParser();
            result.serialization = serialization;
            result.remaining = in;
            return result;
        }

        static StringConstraintParser forArgsInternal(ConstraintSerialization serialization, String in) {
            StringConstraintParser result = StringConstraintParser.forConstraint(serialization, in);
            result.list = true;
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean parse() {
            this.remaining = this.remaining.trim();
            Matcher m = PATTERN_START_WITH_PREDICATE.matcher(this.remaining);
            if (!m.find()) {
                if (!this.list) {
                    return false;
                }
                if (this.remaining.startsWith(")")) {
                    this.result = this.resultList;
                    return true;
                }
                m = PATTERN_START_WITH_QUOTED_STRING.matcher(this.remaining);
                if (m.find()) {
                    this.result = StringEscapes.JavaStringEscapes.unwrapJavaString((String)m.group());
                    this.remaining = this.remaining.substring(m.end());
                } else {
                    m = PATTERN_START_WITH_ARRAY.matcher(this.remaining);
                    if (!m.find()) return false;
                    this.result = m.group().substring(1, m.group().length() - 1);
                    this.remaining = this.remaining.substring(m.end());
                }
            } else {
                String p1 = m.group(1);
                String p2 = (String)this.serialization.predicateToStringToPreferredName.get(p1);
                if (p2 == null) {
                    p2 = p1;
                }
                this.remaining = this.remaining.substring(m.end()).trim();
                if (!this.remaining.startsWith("(")) {
                    this.result = p2;
                } else {
                    this.remaining = this.remaining.substring(1).trim();
                    StringConstraintParser args = StringConstraintParser.forArgsInternal(this.serialization, this.remaining);
                    if (!args.parse()) {
                        return false;
                    }
                    this.result = args.resultList.isEmpty() ? p2 : (args.resultList.size() == 1 ? MutableMap.of((Object)p2, (Object)Iterables.getOnlyElement(args.resultList)) : MutableMap.of((Object)p2, (Object)args.result));
                    this.remaining = args.remaining;
                    if (!this.remaining.startsWith(")")) {
                        return false;
                    }
                    this.remaining = this.remaining.substring(1).trim();
                }
                if (!this.list) {
                    return this.remaining.isEmpty();
                }
            }
            this.resultList.add(this.result);
            if (this.remaining.isEmpty() || this.remaining.startsWith(")")) {
                this.result = this.resultList;
                return true;
            }
            if (!this.remaining.startsWith(",")) {
                return false;
            }
            this.remaining = this.remaining.substring(1);
            return this.parse();
        }
    }

    public static class PredicateSerializationRuleAdder<T> {
        private String preferredName;
        private Function<List<?>, T> constructorArgsFromList;
        private Function<T, Predicate<?>> constructor;
        private Predicate<?> predicateSample;
        private T constructorSampleInput;
        private Set<String> equivalentNames = MutableSet.of();
        private Set<Predicate<?>> equivalentPredicateSamples = MutableSet.of();
        ConstraintSerialization serialization;

        public PredicateSerializationRuleAdder(Function<T, Predicate<?>> constructor, Function<List<?>, T> constructorArgsFromList, T constructorSampleInput) {
            this.constructor = constructor;
            this.constructorArgsFromList = constructorArgsFromList;
            this.constructorSampleInput = constructorSampleInput;
        }

        public static PredicateSerializationRuleAdder<List<Predicate<?>>> predicateListConstructor(Function<List<Predicate<?>>, Predicate<?>> constructor) {
            PredicateSerializationRuleAdder<MutableList> result = new PredicateSerializationRuleAdder<MutableList>(constructor, null, MutableList.of());
            result.constructorArgsFromList = o -> result.serialization.toPredicateListFromJsonList((Collection<?>)o);
            return result;
        }

        public static PredicateSerializationRuleAdder<String> stringConstructor(Function<String, Predicate<?>> constructor) {
            return new PredicateSerializationRuleAdder<String>(constructor, o -> Strings.toString((Object)Iterables.getOnlyElement((Iterable)o)), "");
        }

        public static PredicateSerializationRuleAdder<List<String>> listConstructor(Function<List<String>, Predicate<?>> constructor) {
            Function<Object, String> cooercer = o -> TypeCoercions.coerce(o, String.class);
            Function<List, List> constructorArgsFromList = o -> o.stream().map(cooercer).collect(Collectors.toList());
            return new PredicateSerializationRuleAdder<ImmutableList>(constructor, constructorArgsFromList, ImmutableList.of());
        }

        public static PredicateSerializationRuleAdder<Void> noArgConstructor(Supplier<Predicate<?>> constructor) {
            return new PredicateSerializationRuleAdder<Object>(o -> (Predicate)constructor.get(), o -> null, null);
        }

        public PredicateSerializationRuleAdder<T> preferredName(String preferredName) {
            this.preferredName = preferredName;
            return this;
        }

        public PredicateSerializationRuleAdder<T> equivalentNames(String ... equivs) {
            for (String equiv : equivs) {
                this.equivalentNames.add(equiv);
            }
            return this;
        }

        public PredicateSerializationRuleAdder<T> sample(Predicate<?> samplePreferredPredicate) {
            this.predicateSample = samplePreferredPredicate;
            return this;
        }

        public PredicateSerializationRuleAdder<T> sampleArg(T arg) {
            this.constructorSampleInput = arg;
            return this;
        }

        public PredicateSerializationRuleAdder<T> equivalentPredicates(Predicate<?> ... equivs) {
            for (Predicate<?> equiv : equivs) {
                this.equivalentPredicateSamples.add(equiv);
            }
            return this;
        }

        public void add(ConstraintSerialization constraintSerialization) {
            this.serialization = constraintSerialization;
            if (this.predicateSample == null) {
                this.predicateSample = this.constructor.apply(this.constructorSampleInput);
            }
            String toStringName = Strings.removeAfter((String)((Predicate)Preconditions.checkNotNull(this.predicateSample, (Object)"sample or sampleArg must be supplied")).toString(), (String)"(", (boolean)false);
            if (this.preferredName == null) {
                this.preferredName = toStringName;
            } else {
                constraintSerialization.predicateToStringToPreferredName.put(this.preferredName, this.preferredName);
            }
            constraintSerialization.predicateToStringToPreferredName.put(toStringName, this.preferredName);
            for (String string : this.equivalentNames) {
                constraintSerialization.predicateToStringToPreferredName.put(string, this.preferredName);
            }
            constraintSerialization.predicatePreferredNameToConstructor.put(this.preferredName, this.constructor.compose(this.constructorArgsFromList));
            for (Predicate predicate : this.equivalentPredicateSamples) {
                String equivToStringName = Strings.removeAfter((String)predicate.toString(), (String)"(", (boolean)false);
                constraintSerialization.predicateToStringToPreferredName.put(equivToStringName, this.preferredName);
            }
        }
    }
}

