/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.typereg.BrooklynCatalogBundleResolver;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCatalogBundleResolver
implements BrooklynCatalogBundleResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractCatalogBundleResolver.class);
    protected ManagementContext mgmt;
    private final String format;
    private final String formatName;
    private final String formatDescription;

    @Override
    public void setManagementContext(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public AbstractCatalogBundleResolver withManagementContext(ManagementContext mgmt) {
        this.mgmt = mgmt;
        return this;
    }

    protected AbstractCatalogBundleResolver(String format, String formatName, String formatDescription) {
        this.format = format;
        this.formatName = formatName;
        this.formatDescription = formatDescription;
    }

    @Override
    public String getFormatCode() {
        return this.format;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public String getFormatDescription() {
        return this.formatDescription;
    }

    public String toString() {
        return this.getFormatCode() + ":" + JavaClassNames.simpleClassName((Object)this);
    }

    @Override
    public double scoreForBundle(String format, Supplier<InputStream> f) {
        if (this.getFormatCode().equals(format)) {
            return 1.0;
        }
        if (Strings.isBlank((CharSequence)format)) {
            return this.scoreForNullFormat(f);
        }
        return this.scoreForNonmatchingNonnullFormat(format, f);
    }

    protected abstract double scoreForNullFormat(Supplier<InputStream> var1);

    protected double scoreForNonmatchingNonnullFormat(String format, Supplier<InputStream> f) {
        return 0.0;
    }

    public static class FileTypeDetector
    implements AutoCloseable {
        final Supplier<InputStream> streamSupplier;
        private byte[] bytesRead = new byte[0];
        private boolean readAll = false;
        private static final byte[] HEADER_ZIP = new byte[]{80, 75, 3, 4};
        private static final byte[] HEADER_ZIP_EMPTY = new byte[]{80, 75, 5, 6};
        private static final byte[] HEADER_ZIP_SPANNED = new byte[]{80, 75, 7, 8};
        private static final List<byte[]> HEADERS_ZIP = Arrays.asList(HEADER_ZIP, HEADER_ZIP_EMPTY, HEADER_ZIP_SPANNED);
        private Object yaml;
        File zipFile = null;

        public FileTypeDetector(Supplier<InputStream> streamSupplier) {
            this.streamSupplier = streamSupplier;
        }

        protected byte[] readBytes(int length) {
            int size;
            if (this.bytesRead.length >= length) {
                return this.bytesRead;
            }
            this.bytesRead = new byte[length];
            InputStream stream = this.streamSupplier.get();
            try {
                size = stream.read(this.bytesRead);
                stream.close();
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            if (size < length) {
                this.bytesRead = Arrays.copyOf(this.bytesRead, size < 0 ? 0 : size);
                this.readAll = true;
            }
            return this.bytesRead;
        }

        private byte[] readAll() {
            int size;
            if (this.readAll) {
                return this.bytesRead;
            }
            for (size = 1024; size < this.bytesRead.length; size *= 16) {
            }
            while (true) {
                byte[] br;
                if ((br = this.readBytes(size)).length < size) {
                    this.readAll = true;
                    return br;
                }
                size *= 16;
            }
        }

        public boolean isZip() {
            byte[] header = this.readBytes(4);
            return HEADERS_ZIP.stream().anyMatch(zip -> Arrays.equals(header, zip));
        }

        private boolean isValidYamlChar(int c) {
            if (c < 32) {
                return c == 9 || c == 10 || c == 13;
            }
            if (c <= 126) {
                return true;
            }
            if (c < 160) {
                return c == 133;
            }
            if (c <= 55295) {
                return true;
            }
            if (c < 57344) {
                return false;
            }
            if (c <= 65533) {
                return true;
            }
            if (c < 65536) {
                return false;
            }
            return c <= 0x10FFFF;
        }

        public boolean isPrintableText() {
            int size = 16;
            byte[] headerB;
            String header;
            while ((header = new String(headerB = this.readBytes(size))).chars().allMatch(this::isValidYamlChar)) {
                if (headerB.length < size) {
                    return true;
                }
                size *= 16;
            }
            return false;
        }

        public boolean isYaml() {
            if (!this.isPrintableText()) {
                return false;
            }
            String header = new String(this.bytesRead);
            try {
                this.yaml = Yamls.parseAll((String)header);
                return true;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                return false;
            }
        }

        public Maybe<Object> getYaml() {
            if (this.yaml != null) {
                return Maybe.of((Object)this.yaml);
            }
            if (!this.isPrintableText()) {
                return Maybe.absent((String)"Input does not consist of valid printable YAML characters.");
            }
            try {
                this.yaml = Yamls.parseAll((String)new String(this.bytesRead));
                return Maybe.ofAllowingNull((Object)this.yaml);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                return Maybe.absent((Throwable)e);
            }
        }

        public List<String> zipFileMatchesGlob(String glob) {
            try {
                return this.getZipFile().stream().map(ZipEntry::getName).filter(name -> Os.isPathGlobMatched((String)glob, (String)name, (boolean)true)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error reading zip: " + e, e);
            }
        }

        public ZipFile getZipFile() throws IOException {
            if (this.zipFile == null) {
                this.zipFile = Os.newTempFile((String)"zip-bundle-detector", (String)"zip");
                FileOutputStream fout = new FileOutputStream(this.zipFile);
                Streams.copy((InputStream)this.streamSupplier.get(), (OutputStream)fout);
                fout.close();
            }
            ZipFile zf = new ZipFile(this.zipFile);
            return zf;
        }

        public String zipFileContents(String s) {
            try {
                ZipFile zf = this.getZipFile();
                ZipEntry ze = zf.getEntry(s);
                return Streams.readFullyStringAndClose((InputStream)zf.getInputStream(ze));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error reading zip: " + e, e);
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.close();
        }

        @Override
        public void close() {
            if (this.zipFile != null) {
                this.zipFile.delete();
                this.zipFile = null;
            }
        }
    }
}

