/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.appmodel.EntityValueToSet;
import org.apache.brooklyn.util.text.Strings;

public class ClearConfigWorkflowStep
extends WorkflowStepDefinition {
    public static final ConfigKey<EntityValueToSet> CONFIG = ConfigKeys.newConfigKey(EntityValueToSet.class, "config");
    public static final String SHORTHAND = "[ ${config.type} ] ${config.name}";

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        EntityValueToSet config = context.getInput(CONFIG);
        if (config == null) {
            throw new IllegalArgumentException("Config key name is required");
        }
        String configName = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, (Object)config.name, String.class);
        if (Strings.isBlank((CharSequence)configName)) {
            throw new IllegalArgumentException("Config key name is required");
        }
        TypeToken<?> type = context.lookupType(config.type, () -> TypeToken.of(Object.class));
        Entity entity = config.entity;
        if (entity == null) {
            entity = context.getEntity();
        }
        ((EntityInternal)entity).config().removeKey(ConfigKeys.newConfigKey(Object.class, configName));
        return context.getPreviousStepOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }
}

