/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import org.apache.brooklyn.util.core.xstream.OsgiClassPrefixer;

public class OsgiClassnameMapper
extends MapperWrapper {
    private final OsgiClassPrefixer prefixer;
    private final Supplier<XStream> xstream;

    public OsgiClassnameMapper(Supplier<XStream> xstream, MapperWrapper mapper) {
        super((Mapper)mapper);
        this.xstream = xstream;
        this.prefixer = new OsgiClassPrefixer();
    }

    public String serializedClass(Class type) {
        Optional<String> prefix;
        String superResult = super.serializedClass(type);
        if (type != null && type.getName().equals(superResult) && (prefix = this.prefixer.getPrefix(type)).isPresent()) {
            return (String)prefix.get() + superResult;
        }
        return superResult;
    }

    public Class realClass(String elementName) {
        try {
            return super.realClass(elementName);
        }
        catch (CannotResolveClassException e) {
            CannotResolveClassException tothrow = e;
            try {
                return ((XStream)this.xstream.get()).getClassLoaderReference().getReference().loadClass(elementName);
            }
            catch (ClassNotFoundException e2) {
                throw new CannotResolveClassException(elementName + " via super realClass (nested exception) or xstream reference classloader loadClass (class not found)", (Throwable)tothrow);
            }
        }
    }
}

